/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.stewardship;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum EvaluateAnnotationsGuard {
    ACTIONS_DETECTED("actions-detected", CompletionStatus.INVALID, "The survey report does contain at least one Request For Action (RfA) but no template is provided to action them."),
    ACTIONS_ACTIONED("actions-actioned", CompletionStatus.ACTIONED, "The survey report contains at least one Request For Action and ToDos have been created to resolve any issues they report."),
    MISSING_STEWARD("missing-steward", CompletionStatus.INVALID, "No steward has been provided in the action targets."),
    NO_SURVEY_REPORT("no-survey-report", CompletionStatus.INVALID, "There is no survey report to process.  Details of the survey report should be provided as an action target."),
    EVALUATION_FAILED("evaluation-failed", CompletionStatus.FAILED, "An unexpected error occurred during the evaluation and it is not able to complete.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private EvaluateAnnotationsGuard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (EvaluateAnnotationsGuard guard : EvaluateAnnotationsGuard.values()) {
            guardTypes.add(guard.getGuardType());
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

