/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.connectors.governanceactions.verification;

import java.util.ArrayList;
import org.odpi.openmetadata.adapters.connectors.governanceactions.ffdc.GovernanceActionConnectorsErrorCode;
import org.odpi.openmetadata.adapters.connectors.governanceactions.verification.VerifyAssetGuard;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.openmetadata.ffdc.OMFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.openmetadata.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class VerifyAssetGovernanceActionConnector
extends VerificationGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        ArrayList<String> outputGuards = new ArrayList<String>();
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() == null) {
                completionStatus = VerifyAssetGuard.NO_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(VerifyAssetGuard.NO_TARGETS_DETECTED.getName());
            } else if (this.governanceContext.getActionTargetElements().size() == 1) {
                ActionTargetElement actionTarget = (ActionTargetElement)this.governanceContext.getActionTargetElements().get(0);
                OpenMetadataElement targetElement = actionTarget.getTargetElement();
                if (this.propertyHelper.isTypeOf((ElementControlHeader)targetElement, OpenMetadataType.ASSET.typeName)) {
                    if (targetElement.getClassifications() == null) {
                        outputGuards.add(VerifyAssetGuard.NO_ZONES.getName());
                        outputGuards.add(VerifyAssetGuard.NO_OWNER.getName());
                        outputGuards.add(VerifyAssetGuard.NO_ORIGIN.getName());
                    } else {
                        boolean noZones = true;
                        boolean noOwner = true;
                        boolean noOrigin = true;
                        for (AttachedClassification classification : targetElement.getClassifications()) {
                            if (classification == null) continue;
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)classification, OpenMetadataType.ASSET_ZONE_MEMBERSHIP_CLASSIFICATION.typeName)) {
                                noZones = false;
                                continue;
                            }
                            if (this.propertyHelper.isTypeOf((ElementControlHeader)classification, OpenMetadataType.OWNERSHIP_CLASSIFICATION.typeName)) {
                                noOwner = false;
                                continue;
                            }
                            if (!this.propertyHelper.isTypeOf((ElementControlHeader)classification, OpenMetadataType.ASSET_ORIGIN_CLASSIFICATION.typeName)) continue;
                            noOrigin = false;
                        }
                        if (noZones) {
                            outputGuards.add(VerifyAssetGuard.NO_ZONES.getName());
                        } else {
                            outputGuards.add(VerifyAssetGuard.ZONES_ASSIGNED.getName());
                        }
                        if (noOwner) {
                            outputGuards.add(VerifyAssetGuard.NO_OWNER.getName());
                        } else {
                            outputGuards.add(VerifyAssetGuard.OWNER_ASSIGNED.getName());
                        }
                        if (noOrigin) {
                            outputGuards.add(VerifyAssetGuard.NO_ORIGIN.getName());
                        } else {
                            outputGuards.add(VerifyAssetGuard.ORIGIN_ASSIGNED.getName());
                        }
                    }
                    completionStatus = CompletionStatus.ACTIONED;
                } else {
                    completionStatus = VerifyAssetGuard.TARGET_NOT_ASSET.getCompletionStatus();
                    outputGuards.add(VerifyAssetGuard.TARGET_NOT_ASSET.getName());
                }
            } else {
                completionStatus = VerifyAssetGuard.MULTIPLE_TARGETS_DETECTED.getCompletionStatus();
                outputGuards.add(VerifyAssetGuard.MULTIPLE_TARGETS_DETECTED.getName());
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null);
        }
        catch (OMFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionConnectorsErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", error);
        }
    }
}

