/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataElement
extends ElementControlHeader {
    private static final long serialVersionUID = 1L;
    private String elementGUID = null;
    private ElementType elementType = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private List<ElementClassification> classifications = null;
    private ElementProperties elementProperties = null;

    public OpenMetadataElement() {
    }

    public OpenMetadataElement(OpenMetadataElement template) {
        super(template);
        if (template != null) {
            this.elementGUID = template.getElementGUID();
            this.elementType = template.getElementType();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.classifications = template.getClassifications();
            this.elementProperties = template.getElementProperties();
        }
    }

    public String getElementGUID() {
        return this.elementGUID;
    }

    public void setElementGUID(String guid) {
        this.elementGUID = guid;
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(ElementType type) {
        this.elementType = type;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public List<ElementClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<ElementClassification>(this.classifications);
    }

    public void setClassifications(List<ElementClassification> classifications) {
        this.classifications = classifications;
    }

    public ElementProperties getElementProperties() {
        return this.elementProperties;
    }

    public void setElementProperties(ElementProperties elementProperties) {
        this.elementProperties = elementProperties;
    }

    @Override
    public String toString() {
        return "OpenMetadataElement{elementGUID='" + this.elementGUID + '\'' + ", elementType=" + this.elementType + ", classifications=" + this.classifications + ", elementProperties=" + this.elementProperties + ", headerVersion=" + this.getHeaderVersion() + ", elementSourceServer='" + this.getElementSourceServer() + '\'' + ", elementOriginCategory=" + this.getElementOriginCategory() + ", elementMetadataCollectionId='" + this.getElementMetadataCollectionId() + '\'' + ", elementMetadataCollectionName='" + this.getElementMetadataCollectionName() + '\'' + ", elementLicense='" + this.getElementLicense() + '\'' + ", status=" + this.getStatus() + ", elementCreatedBy='" + this.getElementCreatedBy() + '\'' + ", elementUpdatedBy='" + this.getElementUpdatedBy() + '\'' + ", elementMaintainedBy=" + this.getElementMaintainedBy() + ", elementCreateTime=" + this.getElementCreateTime() + ", elementUpdateTime=" + this.getElementUpdateTime() + ", elementVersion=" + this.getElementVersion() + ", mappingProperties=" + this.getMappingProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataElement that = (OpenMetadataElement)objectToCompare;
        return Objects.equals(this.elementGUID, that.elementGUID) && Objects.equals(this.elementType, that.elementType) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.classifications, that.classifications) && Objects.equals(this.elementProperties, that.elementProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementGUID, this.elementType, this.classifications, this.elementProperties);
    }
}

