/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.logs;

import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.logs.AuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogBase
implements AuditLog {
    private String callerId = "";
    private String callerName = "";
    private String callerType = "";
    private String resourceId = "";
    private String resourceName = "";
    private String resourceType = "";
    private String contextId = "";
    private Properties properties = new Properties();
    private Logger auditLogFile = null;
    private String auditLogFileName;
    private String omasServerURL;

    public AuditLogBase(String name, String serverURL) {
        this.auditLogFileName = name;
        this.omasServerURL = serverURL;
    }

    private String getAuditLogName() {
        if (this.auditLogFileName == null) {
            this.auditLogFileName = "AuditLogBase" + this.callerType + ":" + this.callerName + ":" + this.callerId + ":" + this.resourceType + ":" + this.resourceName + ":" + this.resourceId;
        }
        return this.auditLogFileName;
    }

    @Override
    public void setCallerId(String newCallerId) {
        this.callerId = newCallerId;
    }

    @Override
    public String getCallerId() {
        return this.callerId;
    }

    @Override
    public void setCallerName(String newCallerName) {
        this.callerName = newCallerName;
    }

    @Override
    public String getCallerName() {
        return this.callerName;
    }

    @Override
    public void setCallerType(String newCallerType) {
        this.callerType = newCallerType;
    }

    @Override
    public String getCallerType() {
        return this.callerType;
    }

    @Override
    public void setResourceId(String newResourceId) {
        this.resourceId = newResourceId;
    }

    @Override
    public String getResourceId() {
        return this.resourceId;
    }

    @Override
    public void setResourceName(String newResourceName) {
        this.resourceName = newResourceName;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public void setResourceType(String newResourceType) {
        this.resourceType = newResourceType;
    }

    @Override
    public String getResourceType() {
        return this.resourceType;
    }

    @Override
    public List<String> getPropertyNames() {
        return null;
    }

    @Override
    public void setProperty(String newPropertyName, String newPropertyValue) {
        if (newPropertyName == null) {
            throw new GAFRuntimeException(GAFErrorCode.NULL_AUDITLOG_PROPERTY_NAME.getMessageDefinition(this.getAuditLogName()), this.getClass().getName(), "setProperty");
        }
        if (newPropertyValue == null) {
            this.properties.remove(newPropertyName);
        } else {
            this.properties.setProperty(newPropertyName, newPropertyValue);
        }
    }

    @Override
    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName, null);
    }

    @Override
    public void setContextId(String newContextId) {
        this.contextId = newContextId;
    }

    @Override
    public String getContextId() {
        return this.contextId;
    }

    @Override
    public void addLogMessage(String message) {
        Date timestamp = new Date();
        if (this.auditLogFile == null) {
            this.auditLogFile = LoggerFactory.getLogger((String)this.getAuditLogName());
        }
        this.auditLogFile.info(timestamp.toString() + this.contextId + message);
    }
}

