/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitivePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;

public class TriageGovernanceContext
extends GovernanceContext {
    public TriageGovernanceContext(String userId, String governanceActionGUID, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, OpenMetadataClient openMetadataStore) {
        super(userId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, openMetadataStore);
    }

    public String openToDo(String toDoQualifiedName, String title, String instructions, int priority, Date dueDate, String assignTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String todoTypeName = "ToDo";
        String personRoleTypeName = "PersonRole";
        String actionAssignmentTypeName = "ActionAssignment";
        String qualifiedNamePropertyName = "qualifiedName";
        String titlePropertyName = "name";
        String instructionsPropertyName = "description";
        String priorityPropertyName = "priority";
        String dueDatePropertyName = "dueTime";
        String statusPropertyName = "status";
        String openEnumPropertyValue = "Open";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignTo";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignTo, "assignTo", "openToDo");
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
        primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue(assignTo);
        primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty("qualifiedName");
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue(primitivePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        List<OpenMetadataElement> personRoleMatches = this.openMetadataStore.findMetadataElements("PersonRole", null, searchProperties, null, null, null, null, 0, 0);
        if (personRoleMatches == null || personRoleMatches.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo"), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        if (personRoleMatches.size() > 1) {
            ArrayList<String> matchingGUIDs = new ArrayList<String>();
            for (OpenMetadataElement element : personRoleMatches) {
                if (element == null) continue;
                matchingGUIDs.add(element.getElementGUID());
            }
            throw new InvalidParameterException(GAFErrorCode.DUPLICATE_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo", ((Object)matchingGUIDs).toString()), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        OpenMetadataElement personRoleElement = personRoleMatches.get(0);
        String personRoleGUID = null;
        if (personRoleElement != null && personRoleElement.getElementGUID() != null) {
            personRoleGUID = personRoleElement.getElementGUID();
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", toDoQualifiedName);
        if (title != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", title);
        }
        if (instructions != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", "description");
        }
        if (dueDate != null) {
            properties = this.propertyHelper.addDateProperty(properties, "dueTime", dueDate);
        }
        properties = this.propertyHelper.addIntProperty(properties, "priority", priority);
        properties = this.propertyHelper.addEnumProperty(properties, "status", "Open");
        String todoGUID = this.openMetadataStore.createMetadataElementInStore("ToDo", ElementStatus.ACTIVE, null, null, properties, null);
        this.openMetadataStore.createRelatedElementsInStore("ActionAssignment", personRoleGUID, todoGUID, null, null, null);
        return todoGUID;
    }
}

