/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitivePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;

public class PropertyHelper {
    public void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null || guid.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_GUID.getMessageDefinition(guidParameter, methodName), this.getClass().getName(), methodName, guidParameter);
        }
    }

    public void validateMandatoryName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null || name.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_NAME.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    private ElementProperties addPrimitivePropertyToInstance(ElementProperties properties, String propertyName, Object propertyValue, PrimitiveDefCategory propertyCategory) {
        if (propertyValue != null) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
            primitivePropertyValue.setPrimitiveDefCategory(propertyCategory);
            primitivePropertyValue.setPrimitiveValue(propertyValue);
            primitivePropertyValue.setTypeName(propertyCategory.getName());
            resultingProperties.setProperty(propertyName, primitivePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addStringProperty(ElementProperties properties, String propertyName, String propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    public ElementProperties addIntProperty(ElementProperties properties, String propertyName, int propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
    }

    public ElementProperties addLongProperty(ElementProperties properties, String propertyName, long propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
    }

    public ElementProperties addFloatProperty(ElementProperties properties, String propertyName, float propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, Float.valueOf(propertyValue), PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
    }

    public ElementProperties addDateProperty(ElementProperties properties, String propertyName, Date propertyValue) {
        Long longValue = propertyValue.getTime();
        return this.addPrimitivePropertyToInstance(properties, propertyName, longValue, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
    }

    public ElementProperties addBooleanProperty(ElementProperties properties, String propertyName, boolean propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
    }

    public ElementProperties addEnumProperty(ElementProperties properties, String propertyName, String symbolicName) {
        ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
        EnumPropertyValue enumPropertyValue = new EnumPropertyValue();
        enumPropertyValue.setSymbolicName(symbolicName);
        resultingProperties.setProperty(propertyName, enumPropertyValue);
        return resultingProperties;
    }

    public ElementProperties addStringArrayProperty(ElementProperties properties, String propertyName, List<String> arrayValues) {
        if (arrayValues != null && !arrayValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ArrayPropertyValue arrayPropertyValue = new ArrayPropertyValue();
            arrayPropertyValue.setArrayCount(arrayValues.size());
            int index = 0;
            for (String arrayValue : arrayValues) {
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(arrayValue);
                arrayPropertyValue.setArrayValue(index, primitivePropertyValue);
                ++index;
            }
            resultingProperties.setProperty(propertyName, arrayPropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addMapProperty(ElementProperties properties, String propertyName, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapPropertyValue mapPropertyValue = new MapPropertyValue();
                mapPropertyValue.setMapValues(mapElementProperties);
                resultingProperties.setProperty(propertyName, mapPropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addPropertyMap(ElementProperties properties, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitivePropertyValue primitivePropertyValue;
                Object mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    Long timestamp = ((Date)mapPropertyValue).getTime();
                    primitivePropertyValue.setPrimitiveValue(timestamp);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitivePropertyValue = new PrimitivePropertyValue();
                    primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue == null) continue;
                primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringMapProperty(ElementProperties properties, String propertyName, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addStringPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapPropertyValue mapPropertyValue = new MapPropertyValue();
                mapPropertyValue.setMapValues(mapElementProperties);
                resultingProperties.setProperty(propertyName, mapPropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringPropertyMap(ElementProperties properties, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                String mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitivePropertyValue primitivePropertyValue = new PrimitivePropertyValue();
                primitivePropertyValue.setPrimitiveDefCategory(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING);
                primitivePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitivePropertyValue.setTypeName(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                resultingProperties.setProperty(mapPropertyName, primitivePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    public Map<String, Boolean> getBooleanMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                booleanMap.put(mapPropertyName, (Boolean)actualPropertyValue);
            }
            if (!booleanMap.isEmpty()) {
                return booleanMap;
            }
        }
        return null;
    }

    public Map<String, Long> getLongMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Long> longMap = new HashMap<String, Long>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                longMap.put(mapPropertyName, (Long)actualPropertyValue);
            }
            if (!longMap.isEmpty()) {
                return longMap;
            }
        }
        return null;
    }

    public Map<String, Integer> getIntegerMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                integerMap.put(mapPropertyName, (Integer)actualPropertyValue);
            }
            if (!integerMap.isEmpty()) {
                return integerMap;
            }
        }
        return null;
    }

    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (propertyValue instanceof MapPropertyValue) {
                    MapPropertyValue mapPropertyValue = (MapPropertyValue)propertyValue;
                    return this.getElementPropertiesAsMap(mapPropertyValue.getMapValues());
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        return null;
    }

    public Map<String, Object> getElementPropertiesAsMap(ElementProperties properties) {
        if (properties != null) {
            Map<String, PropertyValue> propertyValues = properties.getInstanceProperties();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    if (actualPropertyValue == null) continue;
                    if (actualPropertyValue instanceof PrimitivePropertyValue) {
                        PrimitivePropertyValue primitivePropertyValue = (PrimitivePropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, primitivePropertyValue.getPrimitiveValue());
                        continue;
                    }
                    if (actualPropertyValue instanceof EnumPropertyValue) {
                        EnumPropertyValue enumPropertyValue = (EnumPropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, enumPropertyValue.getSymbolicName());
                        continue;
                    }
                    resultingMap.put(mapPropertyName, actualPropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public String getStringProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (propertyValue instanceof PrimitivePropertyValue && (primitivePropertyValue = (PrimitivePropertyValue)propertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING && primitivePropertyValue.getPrimitiveValue() != null) {
                    return primitivePropertyValue.getPrimitiveValue().toString();
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        return null;
    }

    public int getIntProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (propertyValue instanceof PrimitivePropertyValue && (primitivePropertyValue = (PrimitivePropertyValue)propertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_INT && primitivePropertyValue.getPrimitiveValue() != null) {
                    return Integer.parseInt(primitivePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        return 0;
    }

    public Date getDateProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (propertyValue instanceof PrimitivePropertyValue && (primitivePropertyValue = (PrimitivePropertyValue)propertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_DATE && primitivePropertyValue.getPrimitiveValue() != null) {
                    Long timestamp = (Long)primitivePropertyValue.getPrimitiveValue();
                    return new Date(timestamp);
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        return null;
    }

    public boolean getBooleanProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitivePropertyValue primitivePropertyValue;
                if (propertyValue instanceof PrimitivePropertyValue && (primitivePropertyValue = (PrimitivePropertyValue)propertyValue).getPrimitiveDefCategory() == PrimitiveDefCategory.OM_PRIMITIVE_TYPE_BOOLEAN && primitivePropertyValue.getPrimitiveValue() != null) {
                    return Boolean.parseBoolean(primitivePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Throwable error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        return false;
    }

    public SearchProperties getSearchProperties(ElementProperties properties, MatchCriteria matchCriteria) {
        SearchProperties matchProperties = null;
        if (properties != null) {
            matchProperties = new SearchProperties();
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            Iterator<String> propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                PropertyCondition propertyCondition = new PropertyCondition();
                propertyCondition.setProperty(propertyName);
                PropertyValue propertyValue = properties.getPropertyValue(propertyName);
                if (propertyValue instanceof PrimitivePropertyValue && ((PrimitivePropertyValue)propertyValue).getPrimitiveDefCategory().equals(PrimitiveDefCategory.OM_PRIMITIVE_TYPE_STRING)) {
                    propertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                } else {
                    propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                }
                propertyCondition.setValue(propertyValue);
                conditions.add(propertyCondition);
            }
            matchProperties.setConditions(conditions);
            matchProperties.setMatchCriteria(matchCriteria);
        }
        return matchProperties;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName);
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName, Throwable unexpectedException) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_EXCEPTION.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName, unexpectedException);
    }
}

