/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;

public class GovernanceContext {
    private String userId;
    private String requestType;
    private Map<String, String> requestParameters;
    private List<RequestSourceElement> requestSourceElements;
    private List<ActionTargetElement> actionTargetElements;
    private String governanceActionGUID;
    private volatile CompletionStatus completionStatus = null;
    OpenMetadataClient openMetadataStore;
    PropertyHelper propertyHelper = new PropertyHelper();

    public GovernanceContext(String userId, String governanceActionGUID, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, OpenMetadataClient openMetadataStore) {
        this.userId = userId;
        this.governanceActionGUID = governanceActionGUID;
        this.requestType = requestType;
        this.requestParameters = requestParameters;
        this.requestSourceElements = requestSourceElements;
        this.actionTargetElements = actionTargetElements;
        this.openMetadataStore = openMetadataStore;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    public List<RequestSourceElement> getRequestSourceElements() {
        return this.requestSourceElements;
    }

    public List<ActionTargetElement> getActionTargetElements() {
        return this.actionTargetElements;
    }

    public OpenMetadataStore getOpenMetadataStore() {
        return this.openMetadataStore;
    }

    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataStore.updateActionTargetStatus(actionTargetGUID, status, startDate, completionDate);
    }

    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, List<String> newActionTargetGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.openMetadataStore.recordCompletionStatus(status, outputGuards, this.requestParameters, newActionTargetGUIDs);
    }

    public synchronized CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String toString() {
        return "GovernanceContext{userId='" + this.userId + '\'' + ", requestType='" + this.requestType + '\'' + ", requestParameters=" + this.requestParameters + ", requestSourceElements=" + this.requestSourceElements + ", actionTargetElements=" + this.actionTargetElements + ", completionStatus=" + this.completionStatus + ", openMetadataStore=" + this.openMetadataStore + ", propertyHelper=" + this.propertyHelper + '}';
    }
}

