/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementClassificationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementClassification
extends ElementClassificationHeader {
    private static final long serialVersionUID = 1L;
    private String classificationName = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private ElementProperties classificationProperties = null;

    public ElementClassification() {
    }

    public ElementClassification(ElementClassification template) {
        super(template);
        if (template != null) {
            this.classificationName = template.getClassificationName();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.classificationProperties = template.getClassificationProperties();
        }
    }

    public void setClassificationName(String classificationName) {
        this.classificationName = classificationName;
    }

    public String getClassificationName() {
        return this.classificationName;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public void setClassificationProperties(ElementProperties classificationProperties) {
        this.classificationProperties = classificationProperties;
    }

    public ElementProperties getClassificationProperties() {
        return this.classificationProperties;
    }

    @Override
    public String toString() {
        return "ElementClassification{classificationName='" + this.classificationName + '\'' + ", effectiveFromTime=" + this.effectiveFromTime + ", effectiveToTime=" + this.effectiveToTime + ", classificationProperties=" + this.classificationProperties + ", classificationTypeId='" + this.getClassificationTypeId() + '\'' + ", classificationTypeVersion=" + this.getClassificationTypeVersion() + ", classificationTypeDescription='" + this.getClassificationTypeDescription() + '\'' + ", classificationOrigin=" + this.getClassificationOrigin() + ", classificationOriginGUID='" + this.getClassificationOriginGUID() + '\'' + ", classificationValidProperties=" + this.getClassificationValidProperties() + ", headerVersion=" + this.getHeaderVersion() + ", elementSourceServer='" + this.getElementSourceServer() + '\'' + ", elementOriginCategory=" + this.getElementOriginCategory() + ", elementMetadataCollectionId='" + this.getElementMetadataCollectionId() + '\'' + ", elementMetadataCollectionName='" + this.getElementMetadataCollectionName() + '\'' + ", elementLicense='" + this.getElementLicense() + '\'' + ", status=" + this.getStatus() + ", elementCreatedBy='" + this.getElementCreatedBy() + '\'' + ", elementUpdatedBy='" + this.getElementUpdatedBy() + '\'' + ", elementMaintainedBy=" + this.getElementMaintainedBy() + ", elementCreateTime=" + this.getElementCreateTime() + ", elementUpdateTime=" + this.getElementUpdateTime() + ", elementVersion=" + this.getElementVersion() + ", mappingProperties=" + this.getMappingProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        ElementClassification that = (ElementClassification)objectToCompare;
        return Objects.equals(this.classificationName, that.classificationName) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.classificationProperties, that.classificationProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.classificationName, this.effectiveFromTime, this.effectiveToTime, this.classificationProperties);
    }
}

