/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RelatedMetadataElement
extends ElementControlHeader {
    private static final long serialVersionUID = 1L;
    private String relationshipGUID = null;
    private ElementType relationshipType = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private ElementProperties relationshipProperties = null;
    private OpenMetadataElement elementProperties = null;

    public RelatedMetadataElement() {
    }

    public RelatedMetadataElement(RelatedMetadataElement template) {
        super(template);
        if (template != null) {
            this.relationshipType = template.getRelationshipType();
            this.relationshipGUID = template.getRelationshipGUID();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.relationshipProperties = template.getRelationshipProperties();
            this.elementProperties = template.getElementProperties();
        }
    }

    public String getRelationshipGUID() {
        return this.relationshipGUID;
    }

    public void setRelationshipGUID(String guid) {
        this.relationshipGUID = guid;
    }

    public ElementType getRelationshipType() {
        return this.relationshipType;
    }

    public void setRelationshipType(ElementType relationshipType) {
        this.relationshipType = relationshipType;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public ElementProperties getRelationshipProperties() {
        return this.relationshipProperties;
    }

    public void setRelationshipProperties(ElementProperties relationshipProperties) {
        this.relationshipProperties = relationshipProperties;
    }

    public OpenMetadataElement getElementProperties() {
        return this.elementProperties;
    }

    public void setElementProperties(OpenMetadataElement elementProperties) {
        this.elementProperties = elementProperties;
    }

    @Override
    public String toString() {
        return "RelatedMetadataElement{relationshipGUID='" + this.relationshipGUID + '\'' + ", relationshipType=" + this.relationshipType + ", effectiveFromTime=" + this.effectiveFromTime + ", effectiveToTime=" + this.effectiveToTime + ", relationshipProperties=" + this.relationshipProperties + ", elementProperties=" + this.elementProperties + ", headerVersion=" + this.getHeaderVersion() + ", elementSourceServer='" + this.getElementSourceServer() + '\'' + ", elementOriginCategory=" + this.getElementOriginCategory() + ", elementMetadataCollectionId='" + this.getElementMetadataCollectionId() + '\'' + ", elementMetadataCollectionName='" + this.getElementMetadataCollectionName() + '\'' + ", elementLicense='" + this.getElementLicense() + '\'' + ", status=" + this.getStatus() + ", elementCreatedBy='" + this.getElementCreatedBy() + '\'' + ", elementUpdatedBy='" + this.getElementUpdatedBy() + '\'' + ", elementMaintainedBy=" + this.getElementMaintainedBy() + ", elementCreateTime=" + this.getElementCreateTime() + ", elementUpdateTime=" + this.getElementUpdateTime() + ", elementVersion=" + this.getElementVersion() + ", mappingProperties=" + this.getMappingProperties() + '}';
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        RelatedMetadataElement that = (RelatedMetadataElement)objectToCompare;
        return Objects.equals(this.relationshipGUID, that.relationshipGUID) && Objects.equals(this.relationshipType, that.relationshipType) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.relationshipProperties, that.relationshipProperties) && Objects.equals(this.elementProperties, that.elementProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.relationshipGUID, this.relationshipType, this.effectiveFromTime, this.effectiveToTime, this.relationshipProperties, this.elementProperties);
    }
}

