/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class PrimitiveTypePropertyValue
extends PropertyValue {
    private static final long serialVersionUID = 1L;
    private PrimitiveTypeCategory primitiveTypeCategory = null;
    private Object primitiveValue = null;

    public PrimitiveTypePropertyValue() {
    }

    public PrimitiveTypePropertyValue(PrimitiveTypePropertyValue template) {
        super(template);
        if (template != null) {
            this.primitiveTypeCategory = template.getPrimitiveTypeCategory();
            this.primitiveValue = template.getPrimitiveValue();
        }
    }

    @Override
    public PropertyValue cloneFromSubclass() {
        return new PrimitiveTypePropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.primitiveValue == null ? "<null>" : this.primitiveValue.toString();
    }

    @Override
    public Object valueAsObject() {
        return this.primitiveValue;
    }

    public PrimitiveTypeCategory getPrimitiveTypeCategory() {
        return this.primitiveTypeCategory;
    }

    public void setPrimitiveTypeCategory(PrimitiveTypeCategory primitiveTypeCategory) {
        this.primitiveValue = this.validateValueAgainstType(primitiveTypeCategory, this.primitiveValue);
        this.primitiveTypeCategory = primitiveTypeCategory;
    }

    public Object getPrimitiveValue() {
        return this.primitiveValue;
    }

    public void setPrimitiveValue(Object primitiveValue) {
        this.primitiveValue = this.validateValueAgainstType(this.primitiveTypeCategory, primitiveValue);
    }

    @Override
    public String toString() {
        return "PrimitiveTypePropertyValue{primitiveValue=" + this.primitiveValue + ", primitiveTypeCategory=" + this.primitiveTypeCategory + ", typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        PrimitiveTypePropertyValue that = (PrimitiveTypePropertyValue)objectToCompare;
        return this.primitiveTypeCategory == that.primitiveTypeCategory && Objects.equals(this.primitiveValue, that.primitiveValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getPrimitiveTypeCategory(), this.getPrimitiveValue());
    }

    private Object validateValueAgainstType(PrimitiveTypeCategory primitiveTypeCategory, Object primitiveValue) {
        String methodName = "validateValueAgainstType";
        if (primitiveTypeCategory == null || primitiveValue == null) {
            return primitiveValue;
        }
        try {
            Class<?> testJavaClass = Class.forName(primitiveTypeCategory.getJavaClassName());
            if (!testJavaClass.isInstance(primitiveValue)) {
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE) {
                    if (primitiveValue instanceof Integer) {
                        Integer castValue = (Integer)primitiveValue;
                        return castValue.longValue();
                    }
                    throw new GAFRuntimeException(GAFErrorCode.INVALID_PRIMITIVE_TYPE.getMessageDefinition("OM_PRIMITIVE_TYPE_DATE", primitiveTypeCategory.getJavaClassName(), primitiveValue.getClass().getName()), this.getClass().getName(), "validateValueAgainstType");
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL) {
                    Integer castValue = (Integer)primitiveValue;
                    return new BigDecimal(castValue);
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER) {
                    Long castValue = (Long)primitiveValue;
                    return new BigInteger(castValue.toString());
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE) {
                    Integer castValue = (Integer)primitiveValue;
                    return castValue.toString();
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR) {
                    String castValue = (String)primitiveValue;
                    return Character.valueOf(castValue.charAt(0));
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT) {
                    Double castValue = (Double)primitiveValue;
                    return castValue;
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG) {
                    Integer castValue = (Integer)primitiveValue;
                    return castValue;
                }
                if (primitiveTypeCategory == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT) {
                    Integer castValue = (Integer)primitiveValue;
                    return castValue.toString();
                }
                throw new GAFRuntimeException(GAFErrorCode.INVALID_PRIMITIVE_VALUE.getMessageDefinition(primitiveTypeCategory.getJavaClassName(), primitiveValue.getClass().getName(), primitiveTypeCategory.getName()), this.getClass().getName(), "validateValueAgainstType");
            }
        }
        catch (ClassNotFoundException unknownPrimitiveClass) {
            throw new GAFRuntimeException(GAFErrorCode.INVALID_PRIMITIVE_CLASS_NAME.getMessageDefinition(primitiveTypeCategory.getJavaClassName(), primitiveTypeCategory.getName()), this.getClass().getName(), "validateValueAgainstType", unknownPrimitiveClass);
        }
        catch (Error invalidPrimitiveCategory) {
            throw new GAFRuntimeException(GAFErrorCode.INVALID_PRIMITIVE_CATEGORY.getMessageDefinition(primitiveTypeCategory.getName()), this.getClass().getName(), "validateValueAgainstType", invalidPrimitiveCategory);
        }
        return primitiveValue;
    }
}

