/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapPropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitivePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.StructPropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="class")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ArrayPropertyValue.class, name="ArrayPropertyValue"), @JsonSubTypes.Type(value=EnumPropertyValue.class, name="EnumPropertyValue"), @JsonSubTypes.Type(value=MapPropertyValue.class, name="MapPropertyValue"), @JsonSubTypes.Type(value=PrimitivePropertyValue.class, name="PrimitivePropertyValue"), @JsonSubTypes.Type(value=StructPropertyValue.class, name="StructPropertyValue")})
public abstract class PropertyValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String typeName = null;

    protected PropertyValue() {
    }

    protected PropertyValue(PropertyValue template) {
        if (template != null) {
            this.typeName = template.getTypeName();
        }
    }

    public abstract PropertyValue cloneFromSubclass();

    public abstract String valueAsString();

    public abstract Object valueAsObject();

    protected <K, V extends PropertyValue> Map<K, Object> mapValuesAsObject(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? null : ((PropertyValue)entry.getValue()).valueAsObject());
    }

    protected <K, V extends PropertyValue> Map<K, String> mapValuesAsString(Map<K, V> valMap) {
        return this.convertValues(valMap, entry -> entry.getValue() == null ? "<null>" : ((PropertyValue)entry.getValue()).valueAsString());
    }

    private <K, V extends PropertyValue, R> Map<K, R> convertValues(Map<K, V> valMap, Function<Map.Entry<K, V>, R> mapper) {
        return Optional.ofNullable(valMap).map(Map::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(HashMap::new, (m, e) -> m.put(e.getKey(), mapper.apply((Map.Entry)e)), HashMap::putAll);
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String toString() {
        return "PropertyValue{, typeName='" + this.typeName + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof PropertyValue)) {
            return false;
        }
        PropertyValue that = (PropertyValue)objectToCompare;
        return Objects.equals(this.getTypeName(), that.getTypeName());
    }

    public int hashCode() {
        return Objects.hash(this.getTypeName());
    }
}

