/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class MapPropertyValue
extends PropertyValue {
    private static final long serialVersionUID = 1L;
    private ElementProperties mapValues = null;

    public MapPropertyValue() {
    }

    public MapPropertyValue(MapPropertyValue template) {
        super(template);
        if (template != null) {
            this.mapValues = template.getMapValues();
        }
    }

    @Override
    public PropertyValue cloneFromSubclass() {
        return new MapPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.mapValuesAsString(this.mapValues.getInstanceProperties()).toString();
    }

    @Override
    public Object valueAsObject() {
        return this.mapValuesAsObject(this.mapValues.getInstanceProperties());
    }

    public int getMapElementCount() {
        if (this.mapValues == null) {
            return 0;
        }
        return this.mapValues.getPropertyCount();
    }

    public ElementProperties getMapValues() {
        if (this.mapValues == null) {
            return null;
        }
        return new ElementProperties(this.mapValues);
    }

    public void setMapValue(String propertyName, PropertyValue propertyValue) {
        if (this.mapValues == null) {
            this.mapValues = new ElementProperties();
        }
        this.mapValues.setProperty(propertyName, propertyValue);
    }

    public void setMapValues(ElementProperties mapValues) {
        this.mapValues = mapValues;
    }

    @Override
    public String toString() {
        return "MapPropertyValue{mapValues=" + this.mapValues + ", mapElementCount=" + this.getMapElementCount() + ", typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        MapPropertyValue that = (MapPropertyValue)objectToCompare;
        return Objects.equals(this.mapValues, that.mapValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mapValues);
    }
}

