/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ArrayPropertyValue
extends PropertyValue {
    private static final long serialVersionUID = 1L;
    private int arrayCount = 0;
    private ElementProperties arrayValues = null;

    public ArrayPropertyValue() {
    }

    public ArrayPropertyValue(ArrayPropertyValue template) {
        super(template);
        if (template != null) {
            this.arrayCount = template.getArrayCount();
            this.arrayValues = template.getArrayValues();
        }
    }

    @Override
    public PropertyValue cloneFromSubclass() {
        return new ArrayPropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.mapValuesAsString(this.arrayValues.getInstanceProperties()).toString();
    }

    @Override
    public Object valueAsObject() {
        return this.mapValuesAsObject(this.arrayValues.getInstanceProperties());
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public ElementProperties getArrayValues() {
        if (this.arrayValues == null) {
            return null;
        }
        return new ElementProperties(this.arrayValues);
    }

    public void setArrayValue(int elementNumber, PropertyValue propertyValue) {
        if (this.arrayCount > elementNumber) {
            if (this.arrayValues == null) {
                this.arrayValues = new ElementProperties();
            }
        } else {
            throw new GAFRuntimeException(GAFErrorCode.ARRAY_OUT_OF_BOUNDS.getMessageDefinition(this.getClass().getSimpleName(), Integer.toString(elementNumber), Integer.toString(this.arrayCount)), this.getClass().getName(), "setArrayValue");
        }
        this.arrayValues.setProperty(Integer.toString(elementNumber), propertyValue);
    }

    public void setArrayValues(ElementProperties arrayValues) {
        this.arrayValues = arrayValues;
    }

    @Override
    public String toString() {
        return "ArrayPropertyValue{arrayCount=" + this.arrayCount + ", arrayValues=" + this.arrayValues + ", typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        ArrayPropertyValue that = (ArrayPropertyValue)objectToCompare;
        return this.arrayCount == that.arrayCount && Objects.equals(this.arrayValues, that.arrayValues);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.arrayCount, this.arrayValues);
    }
}

