/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class ElementProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, PropertyValue> instanceProperties = new HashMap<String, PropertyValue>();

    public ElementProperties() {
    }

    public ElementProperties(ElementProperties templateProperties) {
        Iterator<String> propertyNames;
        if (templateProperties != null && (propertyNames = templateProperties.getPropertyNames()) != null) {
            while (propertyNames.hasNext()) {
                String newPropertyName = propertyNames.next();
                PropertyValue newPropertyValue = templateProperties.getPropertyValue(newPropertyName);
                this.instanceProperties.put(newPropertyName, newPropertyValue);
            }
        }
    }

    public Map<String, PropertyValue> getInstanceProperties() {
        if (this.instanceProperties == null) {
            return null;
        }
        if (this.instanceProperties.isEmpty()) {
            return null;
        }
        return new HashMap<String, PropertyValue>(this.instanceProperties);
    }

    public void setInstanceProperties(Map<String, PropertyValue> instanceProperties) {
        this.instanceProperties = instanceProperties == null ? new HashMap<String, PropertyValue>() : instanceProperties;
    }

    public Iterator<String> getPropertyNames() {
        return this.instanceProperties.keySet().iterator();
    }

    public PropertyValue getPropertyValue(String name) {
        return this.instanceProperties.get(name);
    }

    public void setProperty(String newPropertyName, PropertyValue newPropertyValue) {
        String methodName = "setProperty";
        if (newPropertyName == null) {
            throw new GAFRuntimeException(GAFErrorCode.NULL_PROPERTY_NAME.getMessageDefinition(), this.getClass().getName(), "setProperty");
        }
        if (newPropertyValue == null) {
            this.instanceProperties.remove(newPropertyName);
        } else {
            this.instanceProperties.put(newPropertyName, newPropertyValue);
        }
    }

    public int getPropertyCount() {
        return this.instanceProperties.size();
    }

    public String toString() {
        return "ElementProperties{propertyNames=" + this.getPropertyNames() + ", propertyCount=" + this.getPropertyCount() + ", instanceProperties=" + this.instanceProperties + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof ElementProperties)) {
            return false;
        }
        ElementProperties that = (ElementProperties)objectToCompare;
        return Objects.equals(this.getInstanceProperties(), that.getInstanceProperties());
    }

    public int hashCode() {
        return Objects.hash(this.getInstanceProperties());
    }
}

