/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.PortType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

public class ProvisioningGovernanceContext
extends GovernanceContext {
    public ProvisioningGovernanceContext(String userId, String governanceActionGUID, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, OpenMetadataClient openMetadataStore) {
        super(userId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, openMetadataStore);
    }

    private ElementProperties packBasicProperties(String qualifiedName, String name, String description, String methodName) throws InvalidParameterException {
        String qualifiedNamePropertyName = "qualifiedName";
        String namePropertyName = "name";
        String descriptionPropertyName = "description";
        this.propertyHelper.validateMandatoryName(qualifiedName, "qualifiedName", methodName);
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", qualifiedName);
        if (name != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", name);
        }
        if (description != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", description);
        }
        return properties;
    }

    public String createAsset(String assetTypeName, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, description, "createAsset");
        return this.openMetadataStore.createMetadataElementInStore(assetTypeName, ElementStatus.ACTIVE, null, null, properties, null);
    }

    public String createAssetFromTemplate(String templateGUID, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, description, "createAssetFromTemplate");
        return this.openMetadataStore.createMetadataElementInStore(null, ElementStatus.ACTIVE, null, null, properties, templateGUID);
    }

    public String createProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, description, "createProcess");
        return this.openMetadataStore.createMetadataElementInStore(processTypeName, initialStatus, null, null, properties, null);
    }

    public String createProcessFromTemplate(String templateGUID, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, description, "createProcess");
        return this.openMetadataStore.createMetadataElementInStore(null, initialStatus, null, null, properties, templateGUID);
    }

    public String createChildProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description, String parentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, description, "createProcess");
        String processGUID = this.openMetadataStore.createMetadataElementInStore(processTypeName, initialStatus, null, null, properties, null);
        if (processGUID != null) {
            ElementProperties relationshipProperties = this.propertyHelper.addEnumProperty(null, "containmentType", "ProcessContainmentType", "OWNED");
            this.openMetadataStore.createRelatedElementsInStore("ProcessHierarchy", parentGUID, processGUID, false, false, null, null, relationshipProperties, new Date());
        }
        return processGUID;
    }

    public String createPort(String processGUID, String qualifiedName, String displayName, PortType portType, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        String portTypeName = "PortImplementation";
        String processPortTypeName = "ProcessPort";
        String displayNamePropertyName = "displayName";
        String portTypePropertyName = "portType";
        String portTypeTypeName = "PortType";
        String processGUIDParameterName = "processGUID";
        this.propertyHelper.validateGUID(processGUID, "processGUID", "createProcess");
        ElementProperties properties = this.packBasicProperties(qualifiedName, null, null, "createProcess");
        if (displayName != null) {
            properties = this.propertyHelper.addStringProperty(properties, "displayName", displayName);
        }
        if (portType != null) {
            properties = this.propertyHelper.addEnumProperty(properties, "portType", "PortType", portType.getOpenTypeSymbolicName());
        }
        String portGUID = this.openMetadataStore.createMetadataElementInStore("PortImplementation", ElementStatus.ACTIVE, null, null, properties, templateGUID);
        this.openMetadataStore.createRelatedElementsInStore("ProcessPort", processGUID, portGUID, false, false, null, null, null, new Date());
        return portGUID;
    }

    public String createLineageMapping(String sourceElementGUID, String targetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLineageMapping";
        String lineageMappingTypeName = "LineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String targetElementGUIDParameterName = "targetElementGUID";
        this.propertyHelper.validateGUID(sourceElementGUID, "sourceElementGUID", "createLineageMapping");
        this.propertyHelper.validateGUID(targetElementGUID, "targetElementGUID", "createLineageMapping");
        return this.openMetadataStore.createRelatedElementsInStore("LineageMapping", sourceElementGUID, targetElementGUID, false, false, null, null, null, new Date());
    }
}

