/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public enum CompletionStatus implements Serializable
{
    ACTIONED(5, 10, "Actioned", "The governance action service for the governance action has successfully completed processing"),
    INVALID(6, 11, "Invalid", "The governance action service has not performed the requested action because it is not appropriate (for example, a false positive)"),
    FAILED(8, 13, "Failed", "The governance action service failed to execute the requested action"),
    OTHER(99, 99, "Other", "Undefined or unknown completion status");

    private static final long serialVersionUID = 1L;
    private static final String ENUM_TYPE_GUID = "a6e698b0-a4f7-4a39-8c80-db0bb0f972e";
    private static final String ENUM_TYPE_NAME = "GovernanceActionStatus";
    private String statusName;
    private String statusDescription;
    private int statusCode;
    private int openTypeOrdinal;

    private CompletionStatus(int statusCode, int openTypeOrdinal, String statusName, String statusDescription) {
        this.statusCode = statusCode;
        this.openTypeOrdinal = openTypeOrdinal;
        this.statusName = statusName;
        this.statusDescription = statusDescription;
    }

    public int getOrdinal() {
        return this.statusCode;
    }

    public String getName() {
        return this.statusName;
    }

    public String getDescription() {
        return this.statusDescription;
    }

    public int getOpenTypeOrdinal() {
        return this.openTypeOrdinal;
    }

    public String getOpenTypeGUID() {
        return ENUM_TYPE_GUID;
    }

    public String getOpenTypeName() {
        return ENUM_TYPE_NAME;
    }

    public String toString() {
        return "CompletionStatus{statusName='" + this.statusName + "', statusDescription='" + this.statusDescription + "', statusCode=" + this.statusCode + ", openTypeOrdinal=" + this.openTypeOrdinal + "}";
    }
}

