/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementStatus;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataStore;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceListener;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenGovernanceClient;
import org.odpi.openmetadata.frameworks.governanceaction.client.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.events.WatchdogEventType;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentDependency;
import org.odpi.openmetadata.frameworks.governanceaction.properties.IncidentImpactedElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.PortType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;

public class GovernanceActionContext
implements GovernanceContext,
ProvisioningGovernanceContext,
RemediationGovernanceContext,
TriageGovernanceContext,
VerificationGovernanceContext,
WatchdogGovernanceContext {
    private final String userId;
    private final String requestType;
    private final Map<String, String> requestParameters;
    private final List<RequestSourceElement> requestSourceElements;
    private final List<ActionTargetElement> actionTargetElements;
    private volatile CompletionStatus completionStatus = null;
    private final String governanceActionGUID;
    private final OpenGovernanceClient openGovernanceClient;
    private final OpenMetadataClient openMetadataClient;
    private final OpenMetadataStore openMetadataStore;
    private final PropertyHelper propertyHelper = new PropertyHelper();

    public GovernanceActionContext(String userId, String governanceActionGUID, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, OpenMetadataClient openMetadataClient, OpenGovernanceClient openGovernanceClient) {
        this.userId = userId;
        this.governanceActionGUID = governanceActionGUID;
        this.requestType = requestType;
        this.requestParameters = requestParameters;
        this.requestSourceElements = requestSourceElements;
        this.actionTargetElements = actionTargetElements;
        this.openMetadataClient = openMetadataClient;
        this.openGovernanceClient = openGovernanceClient;
        this.openMetadataStore = new OpenMetadataStore(openMetadataClient, userId);
    }

    @Override
    public String getGovernanceActionGUID() {
        return this.governanceActionGUID;
    }

    @Override
    public String getRequestType() {
        return this.requestType;
    }

    @Override
    public Map<String, String> getRequestParameters() {
        return this.requestParameters;
    }

    @Override
    public List<RequestSourceElement> getRequestSourceElements() {
        return this.requestSourceElements;
    }

    @Override
    public List<ActionTargetElement> getActionTargetElements() {
        return this.actionTargetElements;
    }

    @Override
    public OpenMetadataStore getOpenMetadataStore() {
        return this.openMetadataStore;
    }

    @Override
    public String createIncidentReport(String qualifiedName, int domainIdentifier, String background, List<IncidentImpactedElement> impactedResources, List<IncidentDependency> previousIncidents, Map<String, Integer> incidentClassifiers, Map<String, String> additionalProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createIncidentReport(this.userId, qualifiedName, domainIdentifier, background, impactedResources, previousIncidents, incidentClassifiers, additionalProperties, this.governanceActionGUID);
    }

    @Override
    public void updateActionTargetStatus(String actionTargetGUID, GovernanceActionStatus status, Date startDate, Date completionDate, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openGovernanceClient.updateActionTargetStatus(this.userId, actionTargetGUID, status, startDate, completionDate, completionMessage);
    }

    @Override
    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.openGovernanceClient.recordCompletionStatus(this.userId, this.governanceActionGUID, this.requestParameters, status, outputGuards, null, null);
    }

    @Override
    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        this.openGovernanceClient.recordCompletionStatus(this.userId, this.governanceActionGUID, this.requestParameters, status, outputGuards, newActionTargets, null);
    }

    @Override
    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.recordCompletionStatus(status, outputGuards, newRequestParameters, newActionTargets, null);
    }

    @Override
    public synchronized void recordCompletionStatus(CompletionStatus status, List<String> outputGuards, Map<String, String> newRequestParameters, List<NewActionTarget> newActionTargets, String completionMessage) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.completionStatus = status;
        HashMap<String, String> combinedRequestParameters = new HashMap<String, String>();
        if (this.requestParameters != null) {
            combinedRequestParameters.putAll(this.requestParameters);
        }
        if (newRequestParameters != null) {
            combinedRequestParameters.putAll(newRequestParameters);
        }
        this.openGovernanceClient.recordCompletionStatus(this.userId, this.governanceActionGUID, combinedRequestParameters, status, outputGuards, newActionTargets, completionMessage);
    }

    @Override
    public synchronized CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    private ElementProperties packBasicProperties(String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties, String methodName) throws InvalidParameterException {
        String qualifiedNamePropertyName = "qualifiedName";
        String namePropertyName = "name";
        String versionIdentifierPropertyName = "versionIdentifier";
        String descriptionPropertyName = "description";
        this.propertyHelper.validateMandatoryName(qualifiedName, "qualifiedName", methodName);
        ElementProperties properties = this.propertyHelper.addStringProperty(extendedProperties, "qualifiedName", qualifiedName);
        properties = this.propertyHelper.addStringProperty(properties, "name", name);
        properties = this.propertyHelper.addStringProperty(properties, "versionIdentifier", versionIdentifier);
        properties = this.propertyHelper.addStringProperty(properties, "description", description);
        return properties;
    }

    @Override
    public String createAsset(String assetTypeName, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset(simple)";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createAsset(simple)");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, assetTypeName, ElementStatus.ACTIVE, null, null, properties, null);
    }

    @Override
    public String createAsset(String assetTypeName, String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAsset";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createAsset");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, assetTypeName, ElementStatus.ACTIVE, null, null, properties, null);
    }

    @Override
    public String createAssetFromTemplate(String templateGUID, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createAssetFromTemplate");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, "Asset", ElementStatus.ACTIVE, null, null, properties, templateGUID);
    }

    @Override
    public String createAssetFromTemplate(String assetTypeName, String templateGUID, String qualifiedName, String name, String versionIdentifier, String description, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createAssetFromTemplate";
        String metadataElementTypeName = "Asset";
        if (assetTypeName != null) {
            metadataElementTypeName = assetTypeName;
        }
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createAssetFromTemplate");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, metadataElementTypeName, ElementStatus.ACTIVE, null, null, properties, templateGUID);
    }

    @Override
    public String createProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createProcess");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, properties, null);
    }

    @Override
    public String createProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createProcess");
        properties = this.propertyHelper.addStringProperty(properties, "formula", formula);
        return this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, properties, null);
    }

    @Override
    public String createProcessFromTemplate(String templateGUID, ElementStatus initialStatus, String qualifiedName, String name, String description) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createProcessFromTemplate");
        return this.openMetadataClient.createMetadataElementInStore(this.userId, null, initialStatus, null, null, properties, templateGUID);
    }

    @Override
    public String createProcessFromTemplate(String templateGUID, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcessFromTemplate";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createProcessFromTemplate");
        properties = this.propertyHelper.addStringProperty(properties, "formula", formula);
        return this.openMetadataClient.createMetadataElementInStore(this.userId, null, initialStatus, null, null, properties, templateGUID);
    }

    @Override
    public String createChildProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String description, String parentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createChildProcess(simple)";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, null, description, null, "createChildProcess(simple)");
        String processGUID = this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, properties, null);
        if (processGUID != null) {
            ElementProperties relationshipProperties = this.propertyHelper.addEnumProperty(null, "containmentType", "ProcessContainmentType", "OWNED");
            this.openMetadataClient.createRelatedElementsInStore(this.userId, "ProcessHierarchy", parentGUID, processGUID, true, false, null, null, relationshipProperties, new Date());
        }
        return processGUID;
    }

    @Override
    public String createChildProcess(String processTypeName, ElementStatus initialStatus, String qualifiedName, String name, String versionIdentifier, String description, String formula, ElementProperties extendedProperties, String parentGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createChildProcess";
        ElementProperties properties = this.packBasicProperties(qualifiedName, name, versionIdentifier, description, extendedProperties, "createChildProcess");
        String processGUID = this.openMetadataClient.createMetadataElementInStore(this.userId, processTypeName, initialStatus, null, null, properties = this.propertyHelper.addStringProperty(properties, "formula", formula), null);
        if (processGUID != null) {
            ElementProperties relationshipProperties = this.propertyHelper.addEnumProperty(null, "containmentType", "ProcessContainmentType", "OWNED");
            this.openMetadataClient.createRelatedElementsInStore(this.userId, "ProcessHierarchy", parentGUID, processGUID, true, false, null, null, relationshipProperties, new Date());
        }
        return processGUID;
    }

    @Override
    public String createPort(String processGUID, String qualifiedName, String displayName, PortType portType, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createProcess";
        String portTypeName = "PortImplementation";
        String processPortTypeName = "ProcessPort";
        String displayNamePropertyName = "displayName";
        String portTypePropertyName = "portType";
        String portTypeTypeName = "PortType";
        String processGUIDParameterName = "processGUID";
        this.propertyHelper.validateGUID(processGUID, "processGUID", "createProcess");
        ElementProperties properties = this.packBasicProperties(qualifiedName, null, null, null, null, "createProcess");
        if (displayName != null) {
            properties = this.propertyHelper.addStringProperty(properties, "displayName", displayName);
        }
        if (portType != null) {
            properties = this.propertyHelper.addEnumProperty(properties, "portType", "PortType", portType.getOpenTypeSymbolicName());
        }
        String portGUID = this.openMetadataClient.createMetadataElementInStore(this.userId, "PortImplementation", ElementStatus.ACTIVE, null, null, properties, templateGUID);
        this.openMetadataClient.createRelatedElementsInStore(this.userId, "ProcessPort", processGUID, portGUID, true, false, null, null, null, new Date());
        return portGUID;
    }

    @Override
    public String createLineageRelationship(String sourceElementGUID, String targetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLineageMapping";
        String lineageMappingTypeName = "LineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String targetElementGUIDParameterName = "targetElementGUID";
        this.propertyHelper.validateGUID(sourceElementGUID, "sourceElementGUID", "createLineageMapping");
        this.propertyHelper.validateGUID(targetElementGUID, "targetElementGUID", "createLineageMapping");
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, "LineageMapping", sourceElementGUID, targetElementGUID, true, false, null, null, null, new Date());
    }

    @Override
    public String createLineageRelationship(String relationshipName, String sourceElementGUID, String qualifiedName, String description, String formula, String targetElementGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "createLineageRelationship";
        String lineageMappingTypeName = "LineageMapping";
        String sourceElementGUIDParameterName = "sourceElementGUID";
        String targetElementGUIDParameterName = "targetElementGUID";
        this.propertyHelper.validateGUID(sourceElementGUID, "sourceElementGUID", "createLineageRelationship");
        this.propertyHelper.validateGUID(targetElementGUID, "targetElementGUID", "createLineageRelationship");
        ElementProperties relationshipProperties = this.propertyHelper.addStringProperty(null, "qualifiedName", qualifiedName);
        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, "description", description);
        relationshipProperties = this.propertyHelper.addStringProperty(relationshipProperties, "formula", formula);
        if (relationshipName == null) {
            return this.openMetadataClient.createRelatedElementsInStore(this.userId, "LineageMapping", sourceElementGUID, targetElementGUID, true, false, null, null, relationshipProperties, new Date());
        }
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, relationshipName, sourceElementGUID, targetElementGUID, true, false, null, null, relationshipProperties, new Date());
    }

    @Override
    public String createMetadataElement(String metadataElementTypeName, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, metadataElementTypeName, ElementStatus.ACTIVE, null, null, properties, templateGUID);
    }

    @Override
    public String createMetadataElement(String metadataElementTypeName, ElementStatus initialStatus, Date effectiveFrom, Date effectiveTo, ElementProperties properties, String templateGUID) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createMetadataElementInStore(this.userId, metadataElementTypeName, initialStatus, effectiveFrom, effectiveTo, properties, templateGUID);
    }

    @Override
    public void updateMetadataElement(String metadataElementGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementInStore(this.userId, metadataElementGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateMetadataElementStatus(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, ElementStatus newElementStatus, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementStatusInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, newElementStatus, effectiveTime);
    }

    @Override
    public void updateMetadataElementEffectivity(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateMetadataElementEffectivityInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void deleteMetadataElement(String metadataElementGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteMetadataElementInStore(this.userId, metadataElementGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void classifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, null, null, properties, effectiveTime);
    }

    @Override
    public void classifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.classifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void reclassifyMetadataElement(String metadataElementGUID, String classificationName, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.reclassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateClassificationStatus(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateClassificationEffectivityInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void declassifyMetadataElement(String metadataElementGUID, String classificationName, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.declassifyMetadataElementInStore(this.userId, metadataElementGUID, classificationName, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public String createRelatedElements(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, null, null, properties, effectiveTime);
    }

    @Override
    public String createRelatedElements(String relationshipTypeName, String metadataElement1GUID, String metadataElement2GUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openMetadataClient.createRelatedElementsInStore(this.userId, relationshipTypeName, metadataElement1GUID, metadataElement2GUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElements(String relationshipGUID, boolean replaceProperties, boolean forLineage, boolean forDuplicateProcessing, ElementProperties properties, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsInStore(this.userId, relationshipGUID, replaceProperties, forLineage, forDuplicateProcessing, properties, effectiveTime);
    }

    @Override
    public void updateRelatedElementsStatus(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveFrom, Date effectiveTo, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.updateRelatedElementsEffectivityInStore(this.userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveFrom, effectiveTo, effectiveTime);
    }

    @Override
    public void deleteRelatedElements(String relationshipGUID, boolean forLineage, boolean forDuplicateProcessing, Date effectiveTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openMetadataClient.deleteRelatedElementsInStore(this.userId, relationshipGUID, forLineage, forDuplicateProcessing, effectiveTime);
    }

    @Override
    public void linkElementsAsPeerDuplicates(String metadataElement1GUID, String metadataElement2GUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, boolean setKnownDuplicate) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openGovernanceClient.linkElementsAsPeerDuplicates(this.userId, metadataElement1GUID, metadataElement2GUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, setKnownDuplicate);
    }

    @Override
    public void linkConsolidatedDuplicate(String consolidatedElementGUID, int statusIdentifier, String steward, String stewardTypeName, String stewardPropertyName, String source, String notes, List<String> sourceElementGUIDs) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        this.openGovernanceClient.linkConsolidatedDuplicate(this.userId, consolidatedElementGUID, statusIdentifier, steward, stewardTypeName, stewardPropertyName, source, notes, sourceElementGUIDs);
    }

    @Override
    public String openToDo(String toDoQualifiedName, String title, String instructions, int priority, Date dueDate, String assignTo) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        String methodName = "openToDo";
        String todoTypeName = "ToDo";
        String personRoleTypeName = "PersonRole";
        String actionAssignmentTypeName = "ActionAssignment";
        String qualifiedNamePropertyName = "qualifiedName";
        String titlePropertyName = "name";
        String instructionsPropertyName = "description";
        String priorityPropertyName = "priority";
        String dueDatePropertyName = "dueTime";
        String statusPropertyName = "status";
        String statusPropertyTypeName = "ToDoStatus";
        String openEnumPropertyValue = "Open";
        String toDoQualifiedNameParameterName = "toDoQualifiedName";
        String assignToParameterName = "assignTo";
        this.propertyHelper.validateMandatoryName(toDoQualifiedName, "toDoQualifiedName", "openToDo");
        this.propertyHelper.validateMandatoryName(assignTo, "assignTo", "openToDo");
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
        primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitiveTypePropertyValue.setPrimitiveValue(assignTo);
        primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty("qualifiedName");
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue(primitiveTypePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        List<OpenMetadataElement> personRoleMatches = this.openMetadataClient.findMetadataElements(this.userId, "PersonRole", null, searchProperties, null, null, null, null, false, false, new Date(), 0, 0);
        if (personRoleMatches == null || personRoleMatches.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.UNKNOWN_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo"), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        if (personRoleMatches.size() > 1) {
            ArrayList<String> matchingGUIDs = new ArrayList<String>();
            for (OpenMetadataElement element : personRoleMatches) {
                if (element == null) continue;
                matchingGUIDs.add(element.getElementGUID());
            }
            throw new InvalidParameterException(GAFErrorCode.DUPLICATE_ELEMENT.getMessageDefinition(toDoQualifiedName, "toDoQualifiedName", "openToDo", ((Object)matchingGUIDs).toString()), this.getClass().getName(), "openToDo", "toDoQualifiedName");
        }
        OpenMetadataElement personRoleElement = personRoleMatches.get(0);
        String personRoleGUID = null;
        if (personRoleElement != null && personRoleElement.getElementGUID() != null) {
            personRoleGUID = personRoleElement.getElementGUID();
        }
        ElementProperties properties = this.propertyHelper.addStringProperty(null, "qualifiedName", toDoQualifiedName);
        if (title != null) {
            properties = this.propertyHelper.addStringProperty(properties, "name", title);
        }
        if (instructions != null) {
            properties = this.propertyHelper.addStringProperty(properties, "description", "description");
        }
        if (dueDate != null) {
            properties = this.propertyHelper.addDateProperty(properties, "dueTime", dueDate);
        }
        properties = this.propertyHelper.addIntProperty(properties, "priority", priority);
        properties = this.propertyHelper.addEnumProperty(properties, "status", "ToDoStatus", "Open");
        String todoGUID = this.openMetadataClient.createMetadataElementInStore(this.userId, "ToDo", ElementStatus.ACTIVE, null, null, properties, null);
        this.openMetadataClient.createRelatedElementsInStore(this.userId, "ActionAssignment", personRoleGUID, todoGUID, false, false, null, null, null, new Date());
        return todoGUID;
    }

    @Override
    public void registerListener(WatchdogGovernanceListener listener, List<WatchdogEventType> interestingEventTypes, List<String> interestingMetadataTypes, String specificInstance) throws InvalidParameterException {
        this.openGovernanceClient.registerListener(listener, interestingEventTypes, interestingMetadataTypes, specificInstance);
    }

    @Override
    public void disconnectListener() {
        this.openGovernanceClient.disconnectListener();
    }

    @Override
    public String initiateGovernanceAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openGovernanceClient.initiateGovernanceAction(this.userId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, null, startTime, governanceEngineName, requestType, requestParameters, null, null, this.governanceActionGUID, governanceEngineName);
    }

    @Override
    public String initiateGovernanceAction(String qualifiedName, int domainIdentifier, String displayName, String description, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime, String governanceEngineName, String requestType, Map<String, String> requestParameters, String processName) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openGovernanceClient.initiateGovernanceAction(this.userId, qualifiedName, domainIdentifier, displayName, description, requestSourceGUIDs, actionTargets, null, startTime, governanceEngineName, requestType, requestParameters, processName, null, this.governanceActionGUID, governanceEngineName);
    }

    @Override
    public String initiateGovernanceActionProcess(String processQualifiedName, Map<String, String> requestParameters, List<String> requestSourceGUIDs, List<NewActionTarget> actionTargets, Date startTime) throws InvalidParameterException, UserNotAuthorizedException, PropertyServerException {
        return this.openGovernanceClient.initiateGovernanceActionProcess(this.userId, processQualifiedName, requestSourceGUIDs, actionTargets, startTime, requestParameters, null, null);
    }

    public String toString() {
        return "GovernanceContext{userId='" + this.userId + "', requestType='" + this.requestType + "', requestParameters=" + this.requestParameters + ", requestSourceElements=" + this.requestSourceElements + ", actionTargetElements=" + this.actionTargetElements + ", completionStatus=" + this.completionStatus + ", openMetadataStore=" + this.openGovernanceClient + ", propertyHelper=" + this.propertyHelper + "}";
    }
}

