/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class EnumTypePropertyValue
extends PropertyValue {
    private static final long serialVersionUID = 1L;
    private String symbolicName = null;

    public EnumTypePropertyValue() {
    }

    public EnumTypePropertyValue(EnumTypePropertyValue template) {
        super(template);
        if (template != null) {
            this.symbolicName = template.getSymbolicName();
        }
    }

    @Override
    public PropertyValue cloneFromSubclass() {
        return new EnumTypePropertyValue(this);
    }

    @Override
    public String valueAsString() {
        return this.symbolicName == null ? "<null>" : this.symbolicName;
    }

    @Override
    public Object valueAsObject() {
        return this.symbolicName;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    @Override
    public String toString() {
        return "EnumTypePropertyValue{symbolicName='" + this.symbolicName + "', typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof EnumTypePropertyValue)) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        EnumTypePropertyValue that = (EnumTypePropertyValue)objectToCompare;
        return Objects.equals(this.getSymbolicName(), that.getSymbolicName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSymbolicName());
    }
}

