/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class SearchProperties {
    private List<PropertyCondition> conditions = null;
    private MatchCriteria matchCriteria = MatchCriteria.ALL;

    public SearchProperties() {
    }

    public SearchProperties(SearchProperties templateProperties) {
        if (templateProperties != null) {
            this.matchCriteria = templateProperties.getMatchCriteria();
            this.conditions = new ArrayList<PropertyCondition>();
            this.conditions.addAll(templateProperties.getConditions());
        }
    }

    public List<PropertyCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<PropertyCondition> conditions) {
        this.conditions = conditions;
    }

    public MatchCriteria getMatchCriteria() {
        return this.matchCriteria;
    }

    public void setMatchCriteria(MatchCriteria matchCriteria) {
        this.matchCriteria = matchCriteria;
    }

    public String toString() {
        return "SearchProperties{matchCriteria=" + this.matchCriteria + ", conditions=" + this.conditions + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (!(objectToCompare instanceof SearchProperties)) {
            return false;
        }
        SearchProperties that = (SearchProperties)objectToCompare;
        return this.getMatchCriteria() == that.getMatchCriteria() && Objects.equals(this.getConditions(), that.getConditions());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getMatchCriteria(), this.getConditions()});
    }
}

