/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction;

import java.util.List;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.auditlog.AuditLoggingComponent;
import org.odpi.openmetadata.frameworks.auditlog.ComponentDescription;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ConnectorBase;
import org.odpi.openmetadata.frameworks.connectors.VirtualConnectorExtension;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionContext;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GovernanceServiceException;

public abstract class GovernanceActionServiceConnector
extends ConnectorBase
implements GovernanceActionService,
AuditLoggingComponent,
VirtualConnectorExtension {
    protected String governanceServiceName = "<Unknown>";
    protected AuditLog auditLog = null;
    protected List<Connector> embeddedConnectors = null;

    public void setAuditLog(AuditLog auditLog) {
        this.auditLog = auditLog;
    }

    public ComponentDescription getConnectorComponentDescription() {
        if (this.auditLog != null && this.auditLog.getReport() != null) {
            return this.auditLog.getReport().getReportingComponent();
        }
        return null;
    }

    public void initializeEmbeddedConnectors(List<Connector> embeddedConnectors) {
        this.embeddedConnectors = embeddedConnectors;
    }

    public void setGovernanceServiceName(String governanceServiceName) {
        this.governanceServiceName = governanceServiceName;
    }

    protected void handleUnexpectedException(String methodName, Throwable error) throws ConnectorCheckedException {
        throw new GovernanceServiceException(GAFErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), methodName, error.getMessage()), this.getClass().getName(), methodName);
    }

    public abstract void setGovernanceContext(GovernanceActionContext var1);

    public void validateContext(GovernanceContext governanceContext) throws ConnectorCheckedException {
        String methodName = "start";
        if (governanceContext == null) {
            throw new GovernanceServiceException(GAFErrorCode.NULL_GOVERNANCE_CONTEXT.getMessageDefinition(this.governanceServiceName), this.getClass().getName(), "start");
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        super.disconnectConnectors(this.embeddedConnectors);
        super.disconnect();
    }
}

