/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum ActionTarget {
    ANY_ELEMENT("*", "Any type of element.", OpenMetadataType.OPEN_METADATA_ROOT.typeName, null),
    ANY_REFERENCEABLE("*", "Any element of type Referenceable (or a subtype of).", OpenMetadataType.REFERENCEABLE.typeName, null),
    ANY_ASSET("*", "Any element of type Asset (or a subtype of).", OpenMetadataType.ASSET.typeName, null);

    public final String name;
    public final String description;
    public final String typeName;
    private final String deployedImplementationType;

    private ActionTarget(String name, String description, String typeName, String deployedImplementationType) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
    }

    public static List<ActionTargetType> getActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        for (ActionTarget actionTarget : ActionTarget.values()) {
            actionTargetTypes.add(actionTarget.getActionTargetType());
        }
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        return actionTargetType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String toString() {
        return "ActionTarget{name='" + this.name + "}";
    }
}

