/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestTypeType;

public enum RequestType {
    SAMPLE("sample_request_type", "Description of the operation of the sample request type.");

    public final String requestType;
    public final String description;

    private RequestType(String requestType, String description) {
        this.requestType = requestType;
        this.description = description;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<RequestTypeType> getRequestTypeTypes() {
        ArrayList<RequestTypeType> requestTypeTypes = new ArrayList<RequestTypeType>();
        for (RequestType requestTypeValue : RequestType.values()) {
            RequestTypeType requestTypeType = new RequestTypeType();
            requestTypeType.setRequestType(requestTypeValue.requestType);
            requestTypeType.setDescription(requestTypeValue.description);
            requestTypeTypes.add(requestTypeType);
        }
        return requestTypeTypes;
    }

    public RequestTypeType getRequestTypeType() {
        RequestTypeType requestTypeType = new RequestTypeType();
        requestTypeType.setRequestType(this.requestType);
        requestTypeType.setDescription(this.description);
        return requestTypeType;
    }

    public String toString() {
        return "RequestType{" + this.requestType + "}";
    }
}

