/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.ElementControlHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataElement
extends ElementControlHeader {
    private String elementGUID = null;
    private Date effectiveFromTime = null;
    private Date effectiveToTime = null;
    private List<AttachedClassification> classifications = null;
    private ElementProperties elementProperties = null;

    public OpenMetadataElement() {
    }

    public OpenMetadataElement(OpenMetadataElement template) {
        super((ElementControlHeader)template);
        if (template != null) {
            this.elementGUID = template.getElementGUID();
            this.effectiveFromTime = template.getEffectiveFromTime();
            this.effectiveToTime = template.getEffectiveToTime();
            this.classifications = template.getClassifications();
            this.elementProperties = template.getElementProperties();
        }
    }

    public String getElementGUID() {
        return this.elementGUID;
    }

    public void setElementGUID(String guid) {
        this.elementGUID = guid;
    }

    public Date getEffectiveFromTime() {
        return this.effectiveFromTime;
    }

    public void setEffectiveFromTime(Date effectiveFromTime) {
        this.effectiveFromTime = effectiveFromTime;
    }

    public Date getEffectiveToTime() {
        return this.effectiveToTime;
    }

    public void setEffectiveToTime(Date effectiveToTime) {
        this.effectiveToTime = effectiveToTime;
    }

    public List<AttachedClassification> getClassifications() {
        if (this.classifications == null) {
            return null;
        }
        if (this.classifications.isEmpty()) {
            return null;
        }
        return new ArrayList<AttachedClassification>(this.classifications);
    }

    public void setClassifications(List<AttachedClassification> classifications) {
        this.classifications = classifications;
    }

    public ElementProperties getElementProperties() {
        return this.elementProperties;
    }

    public void setElementProperties(ElementProperties elementProperties) {
        this.elementProperties = elementProperties;
    }

    public String toString() {
        return "OpenMetadataElement{elementGUID='" + this.elementGUID + "', effectiveFromTime=" + this.effectiveFromTime + ", effectiveToTime=" + this.effectiveToTime + ", classifications=" + this.classifications + ", elementProperties=" + this.elementProperties + ", status=" + this.getStatus() + ", type=" + this.getType() + ", origin=" + this.getOrigin() + ", versions=" + this.getVersions() + ", headerVersion=" + this.getHeaderVersion() + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataElement that = (OpenMetadataElement)((Object)objectToCompare);
        return Objects.equals(this.elementGUID, that.elementGUID) && Objects.equals(this.effectiveFromTime, that.effectiveFromTime) && Objects.equals(this.effectiveToTime, that.effectiveToTime) && Objects.equals(this.classifications, that.classifications) && Objects.equals(this.elementProperties, that.elementProperties);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.elementGUID, this.effectiveFromTime, this.effectiveToTime, this.classifications, this.elementProperties);
    }
}

