/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefCategory;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataTypeDefLink;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenMetadataTypeDefSummary
extends OpenMetadataTypeDefLink {
    protected long version = 0L;
    protected String versionName = null;
    protected OpenMetadataTypeDefCategory category = OpenMetadataTypeDefCategory.UNKNOWN_DEF;

    public OpenMetadataTypeDefSummary() {
    }

    OpenMetadataTypeDefSummary(OpenMetadataTypeDefCategory category, String guid, String name, long version, String versionName) {
        super(guid, name);
        this.category = category;
        this.version = version;
        this.versionName = versionName;
    }

    public OpenMetadataTypeDefSummary(OpenMetadataTypeDefSummary template) {
        super(template);
        if (template != null) {
            this.category = template.getCategory();
            this.versionName = template.getVersionName();
            this.version = template.getVersion();
        }
    }

    public OpenMetadataTypeDefCategory getCategory() {
        return this.category;
    }

    public void setCategory(OpenMetadataTypeDefCategory category) {
        this.category = category;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(String versionName) {
        this.versionName = versionName;
    }

    @Override
    public String toString() {
        return "OpenMetadataTypeDefSummary{version=" + this.version + ", versionName='" + this.versionName + "', category=" + this.category + ", guid='" + this.guid + "', name='" + this.name + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        OpenMetadataTypeDefSummary that = (OpenMetadataTypeDefSummary)objectToCompare;
        return this.version == that.version && Objects.equals(this.versionName, that.versionName) && this.category == that.category;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.version, this.versionName, this.category});
    }
}

