/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.converters;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ToDoStatus;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassificationHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementStub;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedElement;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.properties.RelationshipProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;

public abstract class OpenMetadataConverterBase<B> {
    protected PropertyHelper propertyHelper;
    protected String serviceName;
    protected String serverName;

    public OpenMetadataConverterBase(PropertyHelper propertyHelper, String serviceName, String serverName) {
        this.propertyHelper = propertyHelper;
        this.serviceName = serviceName;
        this.serverName = serverName;
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(openMetadataElement)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(openMetadataElement)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(relatedMetadataElement)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(relatedMetadataElement)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewBean(Class<B> beanClass, OpenMetadataElement element, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewBean(element, relationship)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewBean(element, relationship)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<RelatedMetadataElement> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewComplexBean(Class<B> beanClass, OpenMetadataElement primaryElement, List<OpenMetadataElement> supplementaryEntities, List<OpenMetadataRelationship> relationships, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewComplexBean(with supplementary entities)";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewComplexBean(with supplementary entities)", this.getClass().getName(), methodName);
        return null;
    }

    public B getNewRelatedMetadataElementsBean(Class<B> beanClass, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewRelatedMetadataElementsBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewRelatedMetadataElementsBean", this.getClass().getName(), methodName);
        return null;
    }

    public <T> B getNewSchemaAttributeBean(Class<B> beanClass, OpenMetadataElement schemaAttributeElement, Class<T> typeClass, T schemaType, List<OpenMetadataRelationship> schemaAttributeOpenMetadataElements, String methodName) throws PropertyServerException {
        String thisMethodName = "getNewSchemaAttributeBean";
        this.handleUnimplementedConverterMethod(beanClass.getName(), "getNewSchemaAttributeBean", this.getClass().getName(), methodName);
        return null;
    }

    protected void handleUnimplementedConverterMethod(String beanClassName, String missingMethodName, String converterClassName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GAFErrorCode.MISSING_CONVERTER_METHOD.getMessageDefinition(this.serviceName, missingMethodName, converterClassName, beanClassName, methodName), this.getClass().getName(), methodName);
    }

    protected void handleInvalidBeanClass(String beanClassName, Exception error, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GAFErrorCode.INVALID_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, error.getMessage()), this.getClass().getName(), methodName, (Throwable)error);
    }

    protected void handleUnexpectedBeanClass(String beanClassName, String expectedBeanClass, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GAFErrorCode.UNEXPECTED_BEAN_CLASS.getMessageDefinition(beanClassName, methodName, this.serviceName, this.serverName, expectedBeanClass), this.getClass().getName(), methodName);
    }

    protected void handleMissingMetadataInstance(String beanClassName, String elementClassName, String methodName) throws PropertyServerException {
        throw new PropertyServerException(GAFErrorCode.MISSING_METADATA_INSTANCE.getMessageDefinition(this.serviceName, beanClassName, elementClassName, methodName), this.getClass().getName(), methodName);
    }

    protected void handleBadEntity(String beanClassName, OpenMetadataElement element, String methodName) throws PropertyServerException {
        if (element != null) {
            throw new PropertyServerException(GAFErrorCode.BAD_ENTITY.getMessageDefinition(methodName, this.serviceName, element.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, OpenMetadataElement.class.getName(), methodName);
    }

    protected void handleBadRelatedMetadataElements(String beanClassName, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            throw new PropertyServerException(GAFErrorCode.BAD_RELATIONSHIP.getMessageDefinition(methodName, this.serviceName, relationship.toString()), this.getClass().getName(), methodName);
        }
        this.handleMissingMetadataInstance(beanClassName, OpenMetadataRelationship.class.getName(), methodName);
    }

    protected ElementProperties getClassificationProperties(String classificationName, OpenMetadataElement element) {
        List<AttachedClassification> elementClassifications;
        if (element != null && (elementClassifications = element.getClassifications()) != null) {
            return this.getClassificationProperties(classificationName, elementClassifications);
        }
        return null;
    }

    protected ElementProperties getClassificationProperties(String classificationName, List<AttachedClassification> elementClassifications) {
        if (elementClassifications != null) {
            for (AttachedClassification elementClassification : elementClassifications) {
                if (elementClassification == null || !classificationName.equals(elementClassification.getClassificationName())) continue;
                return elementClassification.getClassificationProperties();
            }
        }
        return null;
    }

    protected ElementHeader getMetadataElementHeader(Class<B> beanClass, OpenMetadataElement element, String methodName) throws PropertyServerException {
        if (element != null) {
            return this.getMetadataElementHeader(beanClass, element, element.getElementGUID(), element.getClassifications(), methodName);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
        return null;
    }

    public ElementHeader getMetadataElementHeader(Class<B> beanClass, ElementControlHeader header, String elementGUID, List<AttachedClassification> classifications, String methodName) throws PropertyServerException {
        if (header != null) {
            ElementHeader elementHeader = new ElementHeader(header);
            elementHeader.setGUID(elementGUID);
            elementHeader.setClassifications(this.getElementClassifications(classifications));
            return elementHeader;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), ElementControlHeader.class.getName(), methodName);
        return null;
    }

    public MetadataElementSummary getElementSummary(Class<B> beanClass, OpenMetadataElement element, String methodName) throws PropertyServerException {
        if (element != null) {
            MetadataElementSummary elementSummary = new MetadataElementSummary();
            ElementHeader elementHeader = new ElementHeader((ElementControlHeader)element);
            elementHeader.setGUID(element.getElementGUID());
            elementHeader.setClassifications(this.getElementClassifications(element.getClassifications()));
            elementSummary.setElementHeader(elementHeader);
            if (element.getElementProperties() != null) {
                elementSummary.setProperties(element.getElementProperties().getPropertiesAsStrings());
            }
            return elementSummary;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
        return null;
    }

    public RelatedMetadataElementSummary getRelatedElementSummary(Class<B> beanClass, RelatedMetadataElement relatedElement, String methodName) throws PropertyServerException {
        if (relatedElement != null && relatedElement.getElement() != null) {
            RelatedMetadataElementSummary relatedElementSummary = new RelatedMetadataElementSummary();
            MetadataElementSummary elementSummary = new MetadataElementSummary();
            ElementHeader elementHeader = new ElementHeader((ElementControlHeader)relatedElement);
            elementHeader.setGUID(relatedElement.getRelationshipGUID());
            relatedElementSummary.setRelationshipHeader(elementHeader);
            if (relatedElement.getRelationshipProperties() != null) {
                relatedElementSummary.setRelationshipProperties(relatedElement.getRelationshipProperties().getPropertiesAsStrings());
            }
            elementHeader = new ElementHeader((ElementControlHeader)relatedElement.getElement());
            elementHeader.setGUID(relatedElement.getElement().getElementGUID());
            elementHeader.setClassifications(this.getElementClassifications(relatedElement.getElement().getClassifications()));
            elementSummary.setElementHeader(elementHeader);
            if (relatedElement.getElement().getElementProperties() != null) {
                elementSummary.setProperties(relatedElement.getElement().getElementProperties().getPropertiesAsStrings());
            }
            relatedElementSummary.setRelatedElement(elementSummary);
            return relatedElementSummary;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, OpenMetadataElement element, String methodName) throws PropertyServerException {
        if (element != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, element, methodName);
            ElementStub elementStub = new ElementStub(elementHeader);
            elementStub.setUniqueName(this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, element.getElementProperties(), methodName));
            return elementStub;
        }
        this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
        return null;
    }

    public ElementStub getElementStub(Class<B> beanClass, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        if (relationship != null) {
            ElementHeader elementHeader = this.getMetadataElementHeader(beanClass, relationship, relationship.getRelationshipGUID(), null, methodName);
            return new ElementStub(elementHeader);
        }
        this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataRelationship.class.getName(), methodName);
        return null;
    }

    List<ElementClassification> getEntityClassifications(OpenMetadataElement element) {
        if (element != null) {
            return this.getElementClassifications(element.getClassifications());
        }
        return null;
    }

    public List<ElementClassification> getElementClassifications(List<AttachedClassification> attachedClassifications) {
        ArrayList<ElementClassification> beanClassifications = null;
        if (attachedClassifications != null) {
            beanClassifications = new ArrayList<ElementClassification>();
            for (AttachedClassification attachedClassification : attachedClassifications) {
                if (attachedClassification == null) continue;
                ElementClassification beanClassification = new ElementClassification((ElementClassificationHeader)attachedClassification);
                beanClassification.setClassificationName(attachedClassification.getClassificationName());
                beanClassification.setClassificationProperties(this.propertyHelper.getElementPropertiesAsMap(attachedClassification.getClassificationProperties()));
                beanClassifications.add(beanClassification);
            }
        }
        return beanClassifications;
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, OpenMetadataElement element, OpenMetadataRelationship relationship, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, relationship, relationship.getRelationshipGUID(), null, methodName));
        if (relationship != null) {
            ElementProperties instanceProperties = new ElementProperties(relationship.getRelationshipProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(relationship.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(relationship.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataRelationship.class.getName(), methodName);
        }
        if (element != null) {
            ElementStub elementStub = this.getElementStub(beanClass, element, methodName);
            relatedElement.setRelatedElement(elementStub);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataElement.class.getName(), methodName);
        }
        return relatedElement;
    }

    public RelatedElement getRelatedElement(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        RelatedElement relatedElement = new RelatedElement();
        relatedElement.setRelationshipHeader(this.getMetadataElementHeader(beanClass, relatedMetadataElement, relatedMetadataElement.getRelationshipGUID(), null, methodName));
        if (relatedMetadataElement != null) {
            ElementProperties instanceProperties = new ElementProperties(relatedMetadataElement.getRelationshipProperties());
            RelationshipProperties relationshipProperties = new RelationshipProperties();
            relationshipProperties.setEffectiveFrom(relatedMetadataElement.getEffectiveFromTime());
            relationshipProperties.setEffectiveTo(relatedMetadataElement.getEffectiveToTime());
            relationshipProperties.setExtendedProperties(this.getRemainingExtendedProperties(instanceProperties));
            relatedElement.setRelationshipProperties(relationshipProperties);
        } else {
            this.handleMissingMetadataInstance(beanClass.getName(), OpenMetadataRelationship.class.getName(), methodName);
        }
        return relatedElement;
    }

    protected ToDoStatus removeToDoStatus(ElementProperties elementProperties) {
        String methodName = "removeToDoStatus";
        if (elementProperties != null) {
            String retrievedProperty = this.propertyHelper.removeEnumProperty(this.serviceName, OpenMetadataProperty.TO_DO_STATUS.name, elementProperties, "removeToDoStatus");
            for (ToDoStatus status : ToDoStatus.values()) {
                if (!status.getName().equals(retrievedProperty)) continue;
                return status;
            }
        }
        return null;
    }

    protected String getQualifiedName(ElementProperties elementProperties) {
        String methodName = "getQualifiedName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, elementProperties, "getQualifiedName");
        }
        return null;
    }

    protected String removeQualifiedName(ElementProperties elementProperties) {
        String methodName = "removeQualifiedName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.QUALIFIED_NAME.name, elementProperties, "removeQualifiedName");
        }
        return null;
    }

    protected Map<String, String> removeAdditionalProperties(ElementProperties elementProperties) {
        String methodName = "removeAdditionalProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ADDITIONAL_PROPERTIES.name, elementProperties, "removeAdditionalProperties");
        }
        return null;
    }

    protected Map<String, Object> getRemainingExtendedProperties(ElementProperties elementProperties) {
        if (elementProperties != null) {
            return this.propertyHelper.getElementPropertiesAsMap(elementProperties);
        }
        return null;
    }

    protected String removeDisplayName(ElementProperties elementProperties) {
        String methodName = "removeDisplayName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, elementProperties, "removeDisplayName");
        }
        return null;
    }

    protected String getDisplayName(ElementProperties elementProperties) {
        String methodName = "getDisplayName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DISPLAY_NAME.name, elementProperties, "getDisplayName");
        }
        return null;
    }

    protected String removeName(ElementProperties elementProperties) {
        String methodName = "removeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NAME.name, elementProperties, "removeName");
        }
        return null;
    }

    protected String removeVersionIdentifier(ElementProperties elementProperties) {
        String methodName = "removeVersionIdentifier";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VERSION_IDENTIFIER.name, elementProperties, "removeVersionIdentifier");
        }
        return null;
    }

    protected String getDescription(ElementProperties elementProperties) {
        String methodName = "getDescription";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, elementProperties, "getDescription");
        }
        return null;
    }

    protected String removeDescription(ElementProperties elementProperties) {
        String methodName = "removeDescription";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DESCRIPTION.name, elementProperties, "removeDescription");
        }
        return null;
    }

    protected String removeToDoType(ElementProperties elementProperties) {
        String methodName = "removeToDoType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TO_DO_TYPE.name, elementProperties, "removeToDoType");
        }
        return null;
    }

    protected String removeCollectionType(ElementProperties elementProperties) {
        String methodName = "removeCollectionType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COLLECTION_TYPE.name, elementProperties, "removeCollectionType");
        }
        return null;
    }

    protected String removeKeyword(ElementProperties elementProperties) {
        String methodName = "removeKeyword";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.KEYWORD.name, elementProperties, "removeKeyword");
        }
        return null;
    }

    protected String removeTopicType(ElementProperties elementProperties) {
        String methodName = "removeTopicType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TOPIC_TYPE.name, elementProperties, "removeTopicType");
        }
        return null;
    }

    protected String removeTopicName(ElementProperties elementProperties) {
        String methodName = "removeTopicName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TOPIC_NAME.name, elementProperties, "removeTopicName");
        }
        return null;
    }

    protected String removeOperatingSystem(ElementProperties elementProperties) {
        String methodName = "removeOperatingSystem";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.OPERATING_SYSTEM.name, elementProperties, "removeOperatingSystem");
        }
        return null;
    }

    protected String removeOperatingSystemPatchLevel(ElementProperties elementProperties) {
        String methodName = "removeOperatingSystemPatchLevel";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.OPERATING_SYSTEM_PATCH_LEVEL.name, elementProperties, "removeOperatingSystemPatchLevel");
        }
        return null;
    }

    protected int removeMinimumInstances(ElementProperties elementProperties) {
        String methodName = "removeMinimumInstances";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.MINIMUM_INSTANCES.name, elementProperties, "removeMinimumInstances");
        }
        return 0;
    }

    protected int removeMaximumInstances(ElementProperties elementProperties) {
        String methodName = "removeMaximumInstances";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.MAXIMUM_INSTANCES.name, elementProperties, "removeMaximumInstances");
        }
        return 0;
    }

    protected String removeInitials(ElementProperties elementProperties) {
        String methodName = "removeInitials";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INITIALS.name, elementProperties, "removeInitials");
        }
        return null;
    }

    protected String removeGivenNames(ElementProperties elementProperties) {
        String methodName = "removeGivenNames";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.GIVEN_NAMES.name, elementProperties, "removeGivenNames");
        }
        return null;
    }

    protected String removeSurname(ElementProperties elementProperties) {
        String methodName = "removeSurname";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SURNAME.name, elementProperties, "removeSurname");
        }
        return null;
    }

    protected String removeFullName(ElementProperties elementProperties) {
        String methodName = "removeFullName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FULL_NAME.name, elementProperties, "removeFullName");
        }
        return null;
    }

    protected String removePreferredLanguage(ElementProperties elementProperties) {
        String methodName = "removePreferredLanguage";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PREFERRED_LANGUAGE.name, elementProperties, "removePreferredLanguage");
        }
        return null;
    }

    protected String removeJobTitle(ElementProperties elementProperties) {
        String methodName = "removeJobTitle";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.JOB_TITLE.name, elementProperties, "removeJobTitle");
        }
        return null;
    }

    protected String removeEmployeeNumber(ElementProperties elementProperties) {
        String methodName = "removeEmployeeNumber";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EMPLOYEE_NUMBER.name, elementProperties, "removeEmployeeNumber");
        }
        return null;
    }

    protected String removeEmployeeType(ElementProperties elementProperties) {
        String methodName = "removeEmployeeType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EMPLOYEE_TYPE.name, elementProperties, "removeEmployeeType");
        }
        return null;
    }

    protected String removeContactType(ElementProperties elementProperties) {
        String methodName = "removeContactType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_TYPE.name, elementProperties, "removeContactType");
        }
        return null;
    }

    protected String removeContactMethodService(ElementProperties elementProperties) {
        String methodName = "removeContactMethodService";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_SERVICE.name, elementProperties, "removeContactMethodService");
        }
        return null;
    }

    protected String removeContactMethodValue(ElementProperties elementProperties) {
        String methodName = "removeContactMethodValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONTACT_METHOD_VALUE.name, elementProperties, "removeContactMethodValue");
        }
        return null;
    }

    protected String removeMission(ElementProperties elementProperties) {
        String methodName = "removeMission";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.MISSION.name, elementProperties, "removeMission");
        }
        return null;
    }

    protected String removeAssociationType(ElementProperties elementProperties) {
        String methodName = "removeAssociationType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ASSOCIATION_TYPE.name, elementProperties, "removeAssociationType");
        }
        return null;
    }

    protected String removeIdentifier(ElementProperties elementProperties) {
        String methodName = "removeIdentifier";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IDENTIFIER.name, elementProperties, "removeIdentifier");
        }
        return null;
    }

    protected String removeExternalInstanceCreatedBy(ElementProperties elementProperties) {
        String methodName = "removeExternalInstanceCreatedBy";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_CREATED_BY.name, elementProperties, "removeExternalInstanceCreatedBy");
        }
        return null;
    }

    protected Date removeExternalInstanceCreationTime(ElementProperties elementProperties) {
        String methodName = "removeExternalInstanceCreationTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_CREATION_TIME.name, elementProperties, "removeExternalInstanceCreationTime");
        }
        return null;
    }

    protected String removeExternalInstanceLastUpdatedBy(ElementProperties elementProperties) {
        String methodName = "removeExternalInstanceLastUpdatedBy";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATED_BY.name, elementProperties, "removeExternalInstanceLastUpdatedBy");
        }
        return null;
    }

    protected Date removeExternalInstanceLastUpdateTime(ElementProperties elementProperties) {
        String methodName = "removeExternalInstanceCreationTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_LAST_UPDATE_TIME.name, elementProperties, "removeExternalInstanceCreationTime");
        }
        return null;
    }

    protected long removeExternalInstanceVersion(ElementProperties elementProperties) {
        String methodName = "removeExternalInstanceVersion";
        if (elementProperties != null) {
            return this.propertyHelper.removeLongProperty(this.serviceName, OpenMetadataProperty.EXT_INSTANCE_VERSION.name, elementProperties, "removeExternalInstanceVersion");
        }
        return 0L;
    }

    protected String removeURL(ElementProperties elementProperties) {
        String methodName = "removeURL";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.URL.name, elementProperties, "removeURL");
        }
        return null;
    }

    protected String removeOrganization(ElementProperties elementProperties) {
        String methodName = "removeOrganization";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "organization", elementProperties, "removeOrganization");
        }
        return null;
    }

    protected String removeOwningOrganization(ElementProperties elementProperties) {
        String methodName = "removeOwningOrganization";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SOURCE_ORGANIZATION.name, elementProperties, "removeOwningOrganization");
        }
        return null;
    }

    protected String removeReferenceVersion(ElementProperties elementProperties) {
        String methodName = "removeReferenceVersion";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_VERSION.name, elementProperties, "removeReferenceVersion");
        }
        return null;
    }

    protected String removeReferenceId(ElementProperties elementProperties) {
        String methodName = "removeReferenceId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_ID.name, elementProperties, "removeReferenceId");
        }
        return null;
    }

    protected String getReferenceId(ElementProperties elementProperties) {
        String methodName = "getReferenceId";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.REFERENCE_ID.name, elementProperties, "getReferenceId");
        }
        return null;
    }

    protected String removeOrderPropertyName(ElementProperties elementProperties) {
        String methodName = "removeOrderPropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ORDER_BY_PROPERTY_NAME.name, elementProperties, "removeOrderPropertyName");
        }
        return null;
    }

    protected String removeMembershipRationale(ElementProperties elementProperties) {
        String methodName = "removeMembershipRationale";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.MEMBERSHIP_RATIONALE.name, elementProperties, "removeMembershipRationale");
        }
        return null;
    }

    protected String removeTeamRole(ElementProperties elementProperties) {
        String methodName = "removeTeamRole";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TEAM_ROLE.name, elementProperties, "removeTeamRole");
        }
        return null;
    }

    protected String removeCreatedBy(ElementProperties elementProperties) {
        String methodName = "removeCreatedBy";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "createdBy", elementProperties, "removeCreatedBy");
        }
        return null;
    }

    protected Map<String, String> removeMappingProperties(ElementProperties elementProperties) {
        String methodName = "removeMappingProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.MAPPING_PROPERTIES.name, elementProperties, "removeMappingProperties");
        }
        return null;
    }

    protected Date removeLastSynchronized(ElementProperties elementProperties) {
        String methodName = "removeLastSynchronized";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.LAST_SYNCHRONIZED.name, elementProperties, "removeLastSynchronized");
        }
        return null;
    }

    protected String removeNetworkAddress(ElementProperties elementProperties) {
        String methodName = "removeNetworkAddress";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NETWORK_ADDRESS.name, elementProperties, "removeNetworkAddress");
        }
        return null;
    }

    protected String removePostalAddress(ElementProperties elementProperties) {
        String methodName = "removePostalAddress";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.POSTAL_ADDRESS.name, elementProperties, "removePostalAddress");
        }
        return null;
    }

    protected String removeCoordinates(ElementProperties elementProperties) {
        String methodName = "removeCoordinates";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COORDINATES.name, elementProperties, "removeCoordinates");
        }
        return null;
    }

    protected String removeMapProjection(ElementProperties elementProperties) {
        String methodName = "removeMapProjection";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.MAP_PROJECTION.name, elementProperties, "removeMapProjection");
        }
        return null;
    }

    protected String removeTimeZone(ElementProperties elementProperties) {
        String methodName = "removeTimeZone";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TIME_ZONE.name, elementProperties, "removeTimeZone");
        }
        return null;
    }

    protected String removeLevel(ElementProperties elementProperties) {
        String methodName = "removeLevel";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.LEVEL.name, elementProperties, "removeLevel");
        }
        return null;
    }

    protected String removeProtocol(ElementProperties elementProperties) {
        String methodName = "removeProtocol";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROTOCOL.name, elementProperties, "removeProtocol");
        }
        return null;
    }

    protected String removeEncryptionMethod(ElementProperties elementProperties) {
        String methodName = "removeEncryptionMethod";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCRYPTION_METHOD.name, elementProperties, "removeEncryptionMethod");
        }
        return null;
    }

    protected String removeConnectorProviderClassName(ElementProperties elementProperties) {
        String methodName = "removeConnectorProviderClassName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CONNECTOR_PROVIDER_CLASS_NAME.name, elementProperties, "removeConnectorProviderClassName");
        }
        return null;
    }

    protected String removeSupportedAssetTypeName(ElementProperties elementProperties) {
        String methodName = "removeSupportedAssetTypeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "supportedAssetTypeName", elementProperties, "removeSupportedAssetTypeName");
        }
        return null;
    }

    protected String removeExpectedDataFormat(ElementProperties elementProperties) {
        String methodName = "removeExpectedDataFormat";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "expectedDataFormat", elementProperties, "removeExpectedDataFormat");
        }
        return null;
    }

    protected String removeConnectorFrameworkName(ElementProperties elementProperties) {
        String connectorFrameworkName;
        String methodName = "removeConnectorFrameworkName";
        if (elementProperties != null && (connectorFrameworkName = this.propertyHelper.removeStringProperty(this.serviceName, "connectorFrameworkName", elementProperties, "removeConnectorFrameworkName")) != null) {
            return connectorFrameworkName;
        }
        return "Open Connector Framework (OCF)";
    }

    protected String removeConnectorInterfaceLanguage(ElementProperties elementProperties) {
        String connectorInterfaceLanguage;
        String methodName = "removeConnectorInterfaceLanguage";
        if (elementProperties != null && (connectorInterfaceLanguage = this.propertyHelper.removeStringProperty(this.serviceName, "connectorInterfaceLanguage", elementProperties, "removeConnectorInterfaceLanguage")) != null) {
            return connectorInterfaceLanguage;
        }
        return "Java";
    }

    protected List<String> removeConnectorInterfaces(ElementProperties elementProperties) {
        String methodName = "removeConnectorInterfaces";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "connectorInterfaces", elementProperties, "removeConnectorInterfaces");
        }
        return null;
    }

    protected String removeTargetTechnologySource(ElementProperties elementProperties) {
        String methodName = "removeTargetTechnologySource";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "targetTechnologySource", elementProperties, "removeTargetTechnologySource");
        }
        return null;
    }

    protected String removeTargetTechnologyName(ElementProperties elementProperties) {
        String methodName = "removeTargetTechnologyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "targetTechnologyName", elementProperties, "removeTargetTechnologyName");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyInterfaces(ElementProperties elementProperties) {
        String methodName = "removeTargetTechnologyInterfaces";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "targetTechnologyInterfaces", elementProperties, "removeTargetTechnologyInterfaces");
        }
        return null;
    }

    protected List<String> removeTargetTechnologyVersions(ElementProperties elementProperties) {
        String methodName = "removeTargetTechnologyVersions";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "targetTechnologyVersions", elementProperties, "removeTargetTechnologyVersions");
        }
        return null;
    }

    protected List<String> removeRecognizedAdditionalProperties(ElementProperties elementProperties) {
        String methodName = "removeRecognizedAdditionalProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_ADDITIONAL_PROPERTIES.name, elementProperties, "removeRecognizedAdditionalProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedSecuredProperties(ElementProperties elementProperties) {
        String methodName = "removeRecognizedSecuredProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_SECURED_PROPERTIES.name, elementProperties, "removeRecognizedSecuredProperties");
        }
        return null;
    }

    protected List<String> removeRecognizedConfigurationProperties(ElementProperties elementProperties) {
        String methodName = "removeRecognizedConfigurationProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.RECOGNIZED_CONFIGURATION_PROPERTIES.name, elementProperties, "removeRecognizedConfigurationProperties");
        }
        return null;
    }

    protected Map<String, String> removeSecuredProperties(ElementProperties elementProperties) {
        String methodName = "removeSecuredProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.SECURED_PROPERTIES.name, elementProperties, "removeSecuredProperties");
        }
        return null;
    }

    protected Map<String, Object> removeConfigurationProperties(ElementProperties elementProperties) {
        String methodName = "removeConfigurationProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeMapFromProperty(this.serviceName, OpenMetadataProperty.CONFIGURATION_PROPERTIES.name, elementProperties, "removeConfigurationProperties");
        }
        return null;
    }

    protected String removeUserId(ElementProperties elementProperties) {
        String methodName = "removeUserId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.USER_ID.name, elementProperties, "removeUserId");
        }
        return null;
    }

    protected String removeUser(ElementProperties elementProperties) {
        String methodName = "removeUser";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.USER.name, elementProperties, "removeUser");
        }
        return null;
    }

    protected String removePurpose(ElementProperties elementProperties) {
        String methodName = "removePurpose";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PURPOSE.name, elementProperties, "removePurpose");
        }
        return null;
    }

    protected String removeClearPassword(ElementProperties elementProperties) {
        String methodName = "removeClearPassword";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CLEAR_PASSWORD.name, elementProperties, "removeClearPassword");
        }
        return null;
    }

    protected String removeEncryptedPassword(ElementProperties elementProperties) {
        String methodName = "removeEncryptedPassword";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCRYPTED_PASSWORD.name, elementProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected String getAssetSummary(ElementProperties elementProperties) {
        String methodName = "removeEncryptedPassword";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ASSET_SUMMARY.name, elementProperties, "removeEncryptedPassword");
        }
        return null;
    }

    protected Map<String, Object> getArguments(ElementProperties elementProperties) {
        String methodName = "getArguments";
        if (elementProperties != null) {
            return this.propertyHelper.getMapFromProperty(this.serviceName, OpenMetadataProperty.ARGUMENTS.name, elementProperties, "getArguments");
        }
        return null;
    }

    protected List<String> removeZoneMembership(ElementProperties elementProperties) {
        String methodName = "removeZoneMembership";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.ZONE_MEMBERSHIP.name, elementProperties, "removeZoneMembership");
        }
        return null;
    }

    protected String removeZoneName(ElementProperties elementProperties) {
        String methodName = "removeZoneName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "zoneName", elementProperties, "removeZoneName");
        }
        return null;
    }

    protected String removeSubjectAreaName(ElementProperties elementProperties) {
        String methodName = "removeSubjectAreaName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "subjectAreaName", elementProperties, "removeSubjectAreaName");
        }
        return null;
    }

    protected List<String> getZoneMembership(ElementProperties elementProperties) {
        String methodName = "getZoneMembership";
        if (elementProperties != null) {
            return this.propertyHelper.getStringArrayProperty(this.serviceName, OpenMetadataProperty.ZONE_MEMBERSHIP.name, elementProperties, "getZoneMembership");
        }
        return null;
    }

    protected String removeOwner(ElementProperties elementProperties) {
        String methodName = "removeOwner";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.OWNER.name, elementProperties, "removeOwner");
        }
        return null;
    }

    protected String getOwner(ElementProperties elementProperties) {
        String methodName = "getOwner";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.OWNER.name, elementProperties, "getOwner");
        }
        return null;
    }

    protected String removeOwnerPropertyName(ElementProperties elementProperties) {
        String methodName = "removeClassificationPropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.OWNER_PROPERTY_NAME.name, elementProperties, "removeClassificationPropertyName");
        }
        return null;
    }

    protected String removeOwnerTypeName(ElementProperties elementProperties) {
        String methodName = "removeTypePropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.OWNER_TYPE_NAME.name, elementProperties, "removeTypePropertyName");
        }
        return null;
    }

    protected String removeRoleTypeName(ElementProperties elementProperties) {
        String methodName = "removeRoleTypeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ROLE_TYPE_NAME.name, elementProperties, "removeRoleTypeName");
        }
        return null;
    }

    protected String removeDistinguishedName(ElementProperties elementProperties) {
        String methodName = "removeDistinguishedName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DISTINGUISHED_NAME.name, elementProperties, "removeDistinguishedName");
        }
        return null;
    }

    protected List<String> getGroups(ElementProperties elementProperties) {
        String methodName = "getGroups";
        if (elementProperties != null) {
            return this.propertyHelper.getStringArrayProperty(this.serviceName, "groups", elementProperties, "getGroups");
        }
        return null;
    }

    protected List<String> getSecurityLabels(ElementProperties elementProperties) {
        String methodName = "getSecurityLabels";
        if (elementProperties != null) {
            return this.propertyHelper.getStringArrayProperty(this.serviceName, "securityLabels", elementProperties, "getSecurityLabels");
        }
        return null;
    }

    protected Map<String, String> getSecurityProperties(ElementProperties elementProperties) {
        String methodName = "getSecurityProperties";
        if (elementProperties != null) {
            return this.propertyHelper.getStringMapFromProperty(this.serviceName, "securityProperties", elementProperties, "getSecurityProperties");
        }
        return null;
    }

    protected int removeKarmaPoints(ElementProperties elementProperties) {
        String methodName = "removeKarmaPoints";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.KARMA_POINTS.name, elementProperties, "removeKarmaPoints");
        }
        return 0;
    }

    protected String getOriginOrganizationGUID(ElementProperties elementProperties) {
        String methodName = "getOriginOrganizationGUID";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "organization", elementProperties, "getOriginOrganizationGUID");
        }
        return null;
    }

    protected String getOriginBusinessCapabilityGUID(ElementProperties elementProperties) {
        String methodName = "getOriginBusinessCapabilityGUID";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "businessCapability", elementProperties, "getOriginBusinessCapabilityGUID");
        }
        return null;
    }

    protected Map<String, String> getOtherOriginValues(ElementProperties elementProperties) {
        String methodName = "getOtherOriginValues";
        if (elementProperties != null) {
            return this.propertyHelper.getStringMapFromProperty(this.serviceName, "otherOriginValues", elementProperties, "getOtherOriginValues");
        }
        return null;
    }

    protected Date removeResourceCreateTime(ElementProperties elementProperties) {
        String methodName = "removeResourceCreateTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_CREATE_TIME.name, elementProperties, "removeResourceCreateTime");
        }
        return null;
    }

    protected Date removeResourceUpdateTime(ElementProperties elementProperties) {
        String methodName = "removeResourceUpdateTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_UPDATE_TIME.name, elementProperties, "removeResourceUpdateTime");
        }
        return null;
    }

    protected Date removeResourceLastAccessedTime(ElementProperties elementProperties) {
        String methodName = "removeResourceLastAccessedTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.RESOURCE_LAST_ACCESSED_TIME.name, elementProperties, "removeResourceLastAccessedTime");
        }
        return null;
    }

    protected String removePathName(ElementProperties elementProperties) {
        String methodName = "removePathName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.PATH_NAME.name, elementProperties, "removePathName");
        }
        return null;
    }

    protected Date removeStoreCreateTime(ElementProperties elementProperties) {
        String methodName = "removeStoreCreateTime";
        if (elementProperties != null) {
            Date createTime1 = this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.STORE_CREATE_TIME.name, elementProperties, "removeStoreCreateTime");
            Date createTime2 = this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.CREATE_TIME.name, elementProperties, "removeStoreCreateTime");
            return createTime1 == null ? createTime2 : createTime1;
        }
        return null;
    }

    protected Date removeStoreUpdateTime(ElementProperties elementProperties) {
        String methodName = "removeStoreUpdateTime";
        if (elementProperties != null) {
            Date modifiedTime1 = this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.STORE_UPDATE_TIME.name, elementProperties, "removeStoreUpdateTime");
            Date modifiedTime2 = this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.UPDATE_TIME.name, elementProperties, "removeStoreUpdateTime");
            return modifiedTime1 == null ? modifiedTime2 : modifiedTime1;
        }
        return null;
    }

    protected String getDataStoreEncoding(ElementProperties elementProperties) {
        String methodName = "getDataStoreEncoding";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING.name, elementProperties, "getDataStoreEncoding");
        }
        return null;
    }

    protected String getDataStoreEncodingLanguage(ElementProperties elementProperties) {
        String methodName = "getDataStoreEncodingLanguage";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING_LANGUAGE.name, elementProperties, "getDataStoreEncodingLanguage");
        }
        return null;
    }

    protected String getDataStoreEncodingDescription(ElementProperties elementProperties) {
        String methodName = "getDataStoreEncodingDescription";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ENCODING_DESCRIPTION.name, elementProperties, "getDataStoreEncodingDescription");
        }
        return null;
    }

    protected Map<String, String> getEncodingProperties(ElementProperties elementProperties) {
        String methodName = "getEncodingProperties";
        if (elementProperties != null) {
            return this.propertyHelper.getStringMapFromProperty(this.serviceName, OpenMetadataProperty.ENCODING_PROPERTIES.name, elementProperties, "getEncodingProperties");
        }
        return null;
    }

    protected String removeDatabaseInstance(ElementProperties elementProperties) {
        String methodName = "removeDatabaseInstance";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INSTANCE.name, elementProperties, "removeDatabaseInstance");
        }
        return null;
    }

    protected String removeDatabaseImportedFrom(ElementProperties elementProperties) {
        String methodName = "removeDatabaseImportedFrom";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPORTED_FROM.name, elementProperties, "removeDatabaseImportedFrom");
        }
        return null;
    }

    protected String removeFileType(ElementProperties elementProperties) {
        String methodName = "removeFileType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FILE_TYPE.name, elementProperties, "removeFileType");
        }
        return null;
    }

    protected String getFormat(ElementProperties elementProperties) {
        String methodName = "getFormat";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "format", elementProperties, "getFormat");
        }
        return null;
    }

    protected String getEncryption(ElementProperties elementProperties) {
        String methodName = "getEncryption";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "encryption", elementProperties, "getEncryption");
        }
        return null;
    }

    protected String removeDeployedImplementationType(ElementProperties elementProperties) {
        String methodName = "removeDeployedImplementationType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, elementProperties, "removeDeployedImplementationType");
        }
        return null;
    }

    protected String removeCapabilityType(ElementProperties elementProperties) {
        String methodName = "removeCapabilityType";
        if (elementProperties != null) {
            String type = this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CAPABILITY_TYPE.name, elementProperties, "removeCapabilityType");
            if (type == null) {
                type = this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.DEPLOYED_IMPLEMENTATION_TYPE.name, elementProperties, "removeCapabilityType");
            }
            return type;
        }
        return null;
    }

    protected String removeCapabilityVersion(ElementProperties elementProperties) {
        String methodName = "removeCapabilityVersion";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CAPABILITY_VERSION.name, elementProperties, "removeCapabilityVersion");
        }
        return null;
    }

    protected String removePatchLevel(ElementProperties elementProperties) {
        String methodName = "removePatchLevel";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PATCH_LEVEL.name, elementProperties, "removePatchLevel");
        }
        return null;
    }

    protected boolean removeIsDeprecated(ElementProperties elementProperties) {
        String methodName = "removeIsDeprecated";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "isDeprecated", elementProperties, "removeIsDeprecated");
        }
        return false;
    }

    protected boolean removeIsDefaultValue(ElementProperties elementProperties) {
        String methodName = "removeIsDefaultValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "isDefaultValue", elementProperties, "removeIsDefaultValue");
        }
        return false;
    }

    protected String removeAnchorGUID(ElementProperties elementProperties) {
        String methodName = "removeAnchorGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, elementProperties, "removeAnchorGUID");
        }
        return null;
    }

    protected String getAnchorGUID(ElementProperties elementProperties) {
        String methodName = "getAnchorGUID";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ANCHOR_GUID.name, elementProperties, "getAnchorGUID");
        }
        return null;
    }

    protected String removeDataType(ElementProperties elementProperties) {
        String methodName = "removeDataType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "dataType", elementProperties, "removeDataType");
        }
        return null;
    }

    protected String removeDefaultValue(ElementProperties elementProperties) {
        String methodName = "removeDefaultValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "defaultValue", elementProperties, "removeDefaultValue");
        }
        return null;
    }

    protected String removeFixedValue(ElementProperties elementProperties) {
        String methodName = "removeFixedValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "fixedValue", elementProperties, "removeFixedValue");
        }
        return null;
    }

    protected String getQuery(ElementProperties elementProperties) {
        String methodName = "setQuery";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "query", elementProperties, "setQuery");
        }
        return null;
    }

    protected String getQueryId(ElementProperties elementProperties) {
        String methodName = "setQueryId";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "queryId", elementProperties, "setQueryId");
        }
        return null;
    }

    protected String removeVersionNumber(ElementProperties elementProperties) {
        String methodName = "removeVersionNumber";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "versionNumber", elementProperties, "removeVersionNumber");
        }
        return null;
    }

    protected String removeId(ElementProperties elementProperties) {
        String methodName = "removeId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "id", elementProperties, "removeId");
        }
        return null;
    }

    protected Date removeCreatedTime(ElementProperties elementProperties) {
        String methodName = "removeCreatedTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, "createdTime", elementProperties, "removeCreatedTime");
        }
        return null;
    }

    protected Date removeLastModifiedTime(ElementProperties elementProperties) {
        String methodName = "removeLastModifiedTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, "lastModifiedTime", elementProperties, "removeLastModifiedTime");
        }
        return null;
    }

    protected String removeLastModifier(ElementProperties elementProperties) {
        String methodName = "removeId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "lastModifier", elementProperties, "removeId");
        }
        return null;
    }

    protected String removeAuthor(ElementProperties elementProperties) {
        String methodName = "removeAuthor";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "author", elementProperties, "removeAuthor");
        }
        return null;
    }

    protected String removeEncodingStandard(ElementProperties elementProperties) {
        String methodName = "removeEncodingStandard";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "encodingStandard", elementProperties, "removeEncodingStandard");
        }
        return null;
    }

    protected String removeNamespace(ElementProperties elementProperties) {
        String methodName = "removeNamespace";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "namespace", elementProperties, "removeNamespace");
        }
        return null;
    }

    protected int removePosition(ElementProperties elementProperties) {
        String methodName = "removePosition";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.POSITION.name, elementProperties, "removePosition");
        }
        return 0;
    }

    protected int getPosition(ElementProperties elementProperties) {
        String methodName = "getPosition";
        if (elementProperties != null) {
            return this.propertyHelper.getIntProperty(this.serviceName, OpenMetadataProperty.POSITION.name, elementProperties, "getPosition");
        }
        return 0;
    }

    protected int removeMinCardinality(ElementProperties elementProperties) {
        String methodName = "removeMinCardinality";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "minCardinality", elementProperties, "removeMinCardinality");
        }
        return 0;
    }

    protected int removeMaxCardinality(ElementProperties elementProperties) {
        String methodName = "removeMaxCardinality";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "maxCardinality", elementProperties, "removeMaxCardinality");
        }
        return -1;
    }

    protected boolean removeAllowsDuplicateValues(ElementProperties elementProperties) {
        String methodName = "removeAllowsDuplicateValues";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "allowsDuplicateValues", elementProperties, "removeAllowsDuplicateValues");
        }
        return true;
    }

    protected boolean removeOrderedValues(ElementProperties elementProperties) {
        String methodName = "removeOrderedValues";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "orderedValues", elementProperties, "removeOrderedValues");
        }
        return false;
    }

    protected String removeDefaultValueOverride(ElementProperties elementProperties) {
        String methodName = "removeDefaultValueOverride";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "defaultValueOverride", elementProperties, "removeDefaultValueOverride");
        }
        return null;
    }

    protected int removeMinimumLength(ElementProperties elementProperties) {
        String methodName = "removeMinimumLength";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "minimumLength", elementProperties, "removeMinimumLength");
        }
        return 0;
    }

    protected int removeLength(ElementProperties elementProperties) {
        String methodName = "removeLength";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "length", elementProperties, "removeLength");
        }
        return 0;
    }

    protected int removePrecision(ElementProperties elementProperties) {
        String methodName = "removePrecision";
        if (elementProperties != null) {
            int retrievedValue = this.propertyHelper.removeIntProperty(this.serviceName, "precision", elementProperties, "removePrecision");
            if (retrievedValue == 0) {
                retrievedValue = this.propertyHelper.removeIntProperty(this.serviceName, "significantDigits", elementProperties, "removePrecision");
            }
            return retrievedValue;
        }
        return 0;
    }

    protected boolean removeIsNullable(ElementProperties elementProperties) {
        String methodName = "removeIsNullable";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "isNullable", elementProperties, "removeIsNullable");
        }
        return false;
    }

    protected boolean removeRequired(ElementProperties elementProperties) {
        String methodName = "removeRequired";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "required", elementProperties, "removeRequired");
        }
        return false;
    }

    protected String removeNativeClass(ElementProperties elementProperties) {
        String methodName = "removeNativeClass";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "nativeClass", elementProperties, "removeNativeClass");
        }
        return null;
    }

    protected List<String> removeAliases(ElementProperties elementProperties) {
        String methodName = "removeAliases";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "aliases", elementProperties, "removeAliases");
        }
        return null;
    }

    protected String getGuard(ElementProperties elementProperties) {
        String methodName = "getGuard";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "guard", elementProperties, "getGuard");
        }
        return null;
    }

    protected String getFormula(ElementProperties elementProperties) {
        String methodName = "getFormula";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.FORMULA.name, elementProperties, "getFormula");
        }
        return null;
    }

    protected String getFormulaType(ElementProperties elementProperties) {
        String methodName = "getFormulaType";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.FORMULA_TYPE.name, elementProperties, "getFormulaType");
        }
        return null;
    }

    protected String removeFormula(ElementProperties elementProperties) {
        String methodName = "removeFormula";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FORMULA.name, elementProperties, "removeFormula");
        }
        return null;
    }

    protected String removeFormulaType(ElementProperties elementProperties) {
        String methodName = "removeFormulaType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.FORMULA_TYPE.name, elementProperties, "removeFormulaType");
        }
        return null;
    }

    protected String getImplementationLanguage(ElementProperties elementProperties) {
        String methodName = "getImplementationLanguage";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.IMPLEMENTATION_LANGUAGE.name, elementProperties, "getImplementationLanguage");
        }
        return null;
    }

    protected String removeImplementationLanguage(ElementProperties elementProperties) {
        String methodName = "removeImplementationLanguage";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPLEMENTATION_LANGUAGE.name, elementProperties, "removeImplementationLanguage");
        }
        return null;
    }

    protected boolean removeUsesBlockingCalls(ElementProperties elementProperties) {
        String methodName = "removeUsesBlockingCalls";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "usesBlockingCalls", elementProperties, "removeUsesBlockingCalls");
        }
        return false;
    }

    protected String removeSource(ElementProperties elementProperties) {
        String methodName = "removeSource";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SOURCE.name, elementProperties, "removeSource");
        }
        return null;
    }

    protected String getUsage(ElementProperties elementProperties) {
        String methodName = "getUsage";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.USAGE.name, elementProperties, "getUsage");
        }
        return null;
    }

    protected String removeUsage(ElementProperties elementProperties) {
        String methodName = "removeUsage";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.USAGE.name, elementProperties, "removeUsage");
        }
        return null;
    }

    protected String removeLanguage(ElementProperties elementProperties) {
        String methodName = "removeLanguage";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "language", elementProperties, "removeLanguage");
        }
        return null;
    }

    protected String getSummary(ElementProperties elementProperties) {
        String methodName = "getSummary";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.SUMMARY.name, elementProperties, "getSummary");
        }
        return null;
    }

    protected String removeSummary(ElementProperties elementProperties) {
        String methodName = "removeSummary";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SUMMARY.name, elementProperties, "removeSummary");
        }
        return null;
    }

    protected String removePublishVersionIdentifier(ElementProperties elementProperties) {
        String methodName = "removePublishVersionIdentifier";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PUBLISH_VERSION_ID.name, elementProperties, "removePublishVersionIdentifier");
        }
        return null;
    }

    protected String getAbbreviation(ElementProperties elementProperties) {
        String methodName = "getAbbreviation";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.ABBREVIATION.name, elementProperties, "getAbbreviation");
        }
        return null;
    }

    protected String removeAbbreviation(ElementProperties elementProperties) {
        String methodName = "removeAbbreviation";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ABBREVIATION.name, elementProperties, "removeAbbreviation");
        }
        return null;
    }

    protected String removeExamples(ElementProperties elementProperties) {
        String methodName = "removeExamples";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXAMPLES.name, elementProperties, "removeExamples");
        }
        return null;
    }

    protected String removeTitle(ElementProperties elementProperties) {
        String methodName = "removeTitle";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TITLE.name, elementProperties, "removeTitle");
        }
        return null;
    }

    protected String removePronouns(ElementProperties elementProperties) {
        String methodName = "removePronouns";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PRONOUNS.name, elementProperties, "removePronouns");
        }
        return null;
    }

    protected String removeText(ElementProperties elementProperties) {
        String methodName = "removeText";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TEXT.name, elementProperties, "removeText");
        }
        return null;
    }

    protected String removeImportance(ElementProperties elementProperties) {
        String methodName = "removeImportance";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.IMPORTANCE.name, elementProperties, "removeImportance");
        }
        return null;
    }

    protected int removeIntPriority(ElementProperties elementProperties) {
        String methodName = "removeIntPriority";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.PRIORITY.name, elementProperties, "removeIntPriority");
        }
        return 0;
    }

    protected int removeHeadCount(ElementProperties elementProperties) {
        String methodName = "removeHeadCount";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.HEAD_COUNT.name, elementProperties, "removeHeadCount");
        }
        return 0;
    }

    protected String removeScope(ElementProperties elementProperties) {
        String methodName = "removeScope";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCOPE.name, elementProperties, "removeScope");
        }
        return null;
    }

    protected List<String> removeImplications(ElementProperties elementProperties) {
        String methodName = "removeImplications";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "implications", elementProperties, "removeImplications");
        }
        return null;
    }

    protected List<String> removeOutcomes(ElementProperties elementProperties) {
        String methodName = "removeOutcomes";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "outcomes", elementProperties, "removeOutcomes");
        }
        return null;
    }

    protected List<String> removeResults(ElementProperties elementProperties) {
        String methodName = "removeResults";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "results", elementProperties, "removeResults");
        }
        return null;
    }

    protected List<String> removeBusinessImperatives(ElementProperties elementProperties) {
        String methodName = "removeBusinessImperatives";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "businessImperatives", elementProperties, "removeBusinessImperatives");
        }
        return null;
    }

    protected String removeJurisdiction(ElementProperties elementProperties) {
        String methodName = "removeJurisdiction";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "jurisdiction", elementProperties, "removeJurisdiction");
        }
        return null;
    }

    protected String removeDetails(ElementProperties elementProperties) {
        String methodName = "removeDetails";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "details", elementProperties, "removeDetails");
        }
        return null;
    }

    protected String getRationale(ElementProperties elementProperties) {
        String methodName = "removeRationale";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "rationale", elementProperties, "removeRationale");
        }
        return null;
    }

    protected String removeImplementationDescription(ElementProperties elementProperties) {
        String methodName = "removeImplementationDescription";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "implementationDescription", elementProperties, "removeImplementationDescription");
        }
        return null;
    }

    protected String removeCriteria(ElementProperties elementProperties) {
        String methodName = "removeCriteria";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "criteria", elementProperties, "removeCriteria");
        }
        return null;
    }

    protected int removeDomainIdentifier(ElementProperties elementProperties) {
        String methodName = "removeDomainIdentifier";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "domainIdentifier", elementProperties, "removeDomainIdentifier");
        }
        return 0;
    }

    protected int removeLevelIdentifier(ElementProperties elementProperties) {
        String methodName = "removeLevelIdentifier";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "levelIdentifier", elementProperties, "removeLevelIdentifier");
        }
        return 0;
    }

    protected String removeMeasurement(ElementProperties elementProperties) {
        String methodName = "removeMeasurement";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "measurement", elementProperties, "removeMeasurement");
        }
        return null;
    }

    protected String removeTarget(ElementProperties elementProperties) {
        String methodName = "removeTarget";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "target", elementProperties, "removeTarget");
        }
        return null;
    }

    protected String removeClassificationName(ElementProperties elementProperties) {
        String methodName = "removeClassificationName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CLASSIFICATION_NAME.name, elementProperties, "removeClassificationName");
        }
        return null;
    }

    protected String removeClassificationPropertyName(ElementProperties elementProperties) {
        String methodName = "removeClassificationPropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.CLASSIFICATION_PROPERTY_NAME.name, elementProperties, "removeClassificationPropertyName");
        }
        return null;
    }

    protected String removeProcessingEngineUserId(ElementProperties elementProperties) {
        String methodName = "removeProcessingEngineUserId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUESTER_USER_ID.name, elementProperties, "removeProcessingEngineUserId");
        }
        return null;
    }

    protected String removeRequesterUserId(ElementProperties elementProperties) {
        String methodName = "removeRequesterUserId";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUESTER_USER_ID.name, elementProperties, "removeRequesterUserId");
        }
        return null;
    }

    protected String removeRequestType(ElementProperties elementProperties) {
        String methodName = "removeRequestType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REQUEST_TYPE.name, elementProperties, "removeRequestType");
        }
        return null;
    }

    protected String removeServiceRequestType(ElementProperties elementProperties) {
        String methodName = "removeServiceRequestType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SERVICE_REQUEST_TYPE.name, elementProperties, "removeServiceRequestType");
        }
        return null;
    }

    protected Map<String, String> removeRequestParameters(ElementProperties elementProperties) {
        String methodName = "removeRequestParameters";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, elementProperties, "removeRequestParameters");
        }
        return null;
    }

    protected String removeExecutorEngineGUID(ElementProperties elementProperties) {
        String methodName = "removeExecutorEngineGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "executorEngineGUID", elementProperties, "removeExecutorEngineGUID");
        }
        return null;
    }

    protected String removeEngineActionGUID(ElementProperties elementProperties) {
        String methodName = "removeEngineActionGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENGINE_ACTION_GUID.name, elementProperties, "removeEngineActionGUID");
        }
        return null;
    }

    protected String removeAssetGUID(ElementProperties elementProperties) {
        String methodName = "removeAssetGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ASSET_GUID.name, elementProperties, "removeAssetGUID");
        }
        return null;
    }

    protected String removeExecutorEngineName(ElementProperties elementProperties) {
        String methodName = "removeExecutorEngineName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "executorEngineName", elementProperties, "removeExecutorEngineName");
        }
        return null;
    }

    protected String removeProcessName(ElementProperties elementProperties) {
        String methodName = "removeProcessName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROCESS_NAME.name, elementProperties, "removeProcessName");
        }
        return null;
    }

    protected Map<String, String> removeRequiredRequestParameters(ElementProperties elementProperties) {
        String methodName = "removeRequiredRequestParameters";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, "requiredRequestParameters", elementProperties, "removeRequiredRequestParameters");
        }
        return null;
    }

    protected Map<String, String> removeRequiredActionTargets(ElementProperties elementProperties) {
        String methodName = "removeRequiredActionTargets";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, "requiredActionTargets", elementProperties, "removeRequiredActionTargets");
        }
        return null;
    }

    protected Map<String, String> removeProducedRequestParameters(ElementProperties elementProperties) {
        String methodName = "removeProducedRequestParameters";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, "producedRequestParameters", elementProperties, "removeProducedRequestParameters");
        }
        return null;
    }

    protected Map<String, String> removeProducedActionTargets(ElementProperties elementProperties) {
        String methodName = "removeProducedActionTargets";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, "producedActionTargets", elementProperties, "removeProducedActionTargets");
        }
        return null;
    }

    protected Map<String, String> removeProducedGuards(ElementProperties elementProperties) {
        String methodName = "removeProducedGuards";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, "producedGuards", elementProperties, "removeProducedGuards");
        }
        return null;
    }

    protected String removeGuard(ElementProperties elementProperties) {
        String methodName = "removeGuard";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "guard", elementProperties, "removeGuard");
        }
        return null;
    }

    protected List<String> removeMandatoryGuards(ElementProperties elementProperties) {
        String methodName = "removeMandatoryGuards";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "mandatoryGuards", elementProperties, "removeMandatoryGuards");
        }
        return null;
    }

    protected boolean removeMandatoryGuard(ElementProperties elementProperties) {
        String methodName = "removeMandatoryGuard";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "mandatoryGuard", elementProperties, "removeMandatoryGuard");
        }
        return false;
    }

    protected boolean removeIgnoreMultipleTriggers(ElementProperties elementProperties) {
        String methodName = "removeIgnoreMultipleTriggers";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "ignoreMultipleTriggers", elementProperties, "removeIgnoreMultipleTriggers");
        }
        return false;
    }

    protected int removeWaitTime(ElementProperties elementProperties) {
        String methodName = "removeWaitTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, "waitTime", elementProperties, "removeWaitTime");
        }
        return 0;
    }

    protected List<String> removeReceivedGuards(ElementProperties elementProperties) {
        String methodName = "removeReceivedGuards";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "receivedGuards", elementProperties, "removeReceivedGuards");
        }
        return null;
    }

    protected List<String> removeCompletionGuards(ElementProperties elementProperties) {
        String methodName = "removeCompletionGuards";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "completionGuards", elementProperties, "removeCompletionGuards");
        }
        return null;
    }

    protected String removeCompletionMessage(ElementProperties elementProperties) {
        String methodName = "removeCompletionMessage";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "completionMessage", elementProperties, "removeCompletionMessage");
        }
        return null;
    }

    protected Date removeStartDate(ElementProperties elementProperties) {
        String methodName = "removeStartDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, "startDate", elementProperties, "removeStartDate");
        }
        return null;
    }

    protected Date removePlannedEndDate(ElementProperties elementProperties) {
        String methodName = "removePlannedEndDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, "plannedEndDate", elementProperties, "removePlannedEndDate");
        }
        return null;
    }

    protected Date removeCreationTime(ElementProperties elementProperties) {
        String methodName = "removeCreationTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.CREATION_TIME.name, elementProperties, "removeCreationTime");
        }
        return null;
    }

    protected Date removeLastReviewTime(ElementProperties elementProperties) {
        String methodName = "removeLastReviewTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.LAST_REVIEW_TIME.name, elementProperties, "removeLastReviewTime");
        }
        return null;
    }

    protected Date removeDueTime(ElementProperties elementProperties) {
        String methodName = "removeDueTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.DUE_TIME.name, elementProperties, "removeDueTime");
        }
        return null;
    }

    protected Date removeCompletionTime(ElementProperties elementProperties) {
        String methodName = "removeCompletionTime";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.COMPLETION_TIME.name, elementProperties, "removeCompletionTime");
        }
        return null;
    }

    protected Date removeCompletionDate(ElementProperties elementProperties) {
        String methodName = "removeCompletionDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.COMPLETION_DATE.name, elementProperties, "removeCompletionDate");
        }
        return null;
    }

    protected String removeProjectStatus(ElementProperties elementProperties) {
        String methodName = "removeProjectStatus";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_STATUS.name, elementProperties, "removeProjectStatus");
        }
        return null;
    }

    protected String removeProjectHealth(ElementProperties elementProperties) {
        String methodName = "removeProjectHealth";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_HEALTH.name, elementProperties, "removeProjectHealth");
        }
        return null;
    }

    protected String removeProjectPhase(ElementProperties elementProperties) {
        String methodName = "removeProjectPhase";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.PROJECT_PHASE.name, elementProperties, "removeProjectPhase");
        }
        return null;
    }

    protected String removeRequestSourceName(ElementProperties elementProperties) {
        String methodName = "removeRequestSourceName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "requestSourceName", elementProperties, "removeRequestSourceName");
        }
        return null;
    }

    protected String removeActionTargetName(ElementProperties elementProperties) {
        String methodName = "removeActionTargetName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "actionTargetName", elementProperties, "removeActionTargetName");
        }
        return null;
    }

    protected String removeOriginGovernanceService(ElementProperties elementProperties) {
        String methodName = "removeOriginGovernanceService";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "originGovernanceService", elementProperties, "removeOriginGovernanceService");
        }
        return null;
    }

    protected String removeOriginGovernanceEngine(ElementProperties elementProperties) {
        String methodName = "removeOriginGovernanceEngine";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "originGovernanceEngine", elementProperties, "removeOriginGovernanceEngine");
        }
        return null;
    }

    protected String getLicenseGUID(ElementProperties elementProperties) {
        String methodName = "getLicenseGUID";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "licenseGUID", elementProperties, "getLicenseGUID");
        }
        return null;
    }

    protected String getCertificationGUID(ElementProperties elementProperties) {
        String methodName = "getCertificationGUID";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "certificateGUID", elementProperties, "getCertificationGUID");
        }
        return null;
    }

    protected Date getStart(ElementProperties elementProperties) {
        String methodName = "getStart";
        if (elementProperties != null) {
            return this.propertyHelper.getDateProperty(this.serviceName, "start", elementProperties, "getStart");
        }
        return null;
    }

    protected Date getEnd(ElementProperties elementProperties) {
        String methodName = "getEnd";
        if (elementProperties != null) {
            return this.propertyHelper.getDateProperty(this.serviceName, "end", elementProperties, "getEnd");
        }
        return null;
    }

    protected String getConditions(ElementProperties elementProperties) {
        String methodName = "getConditions";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "conditions", elementProperties, "getConditions");
        }
        return null;
    }

    protected String getCustodian(ElementProperties elementProperties) {
        String methodName = "getCustodian";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "custodian", elementProperties, "getCustodian");
        }
        return null;
    }

    protected String getCertifiedBy(ElementProperties elementProperties) {
        String methodName = "getCertifiedBy";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "certifiedBy", elementProperties, "getCertifiedBy");
        }
        return null;
    }

    protected String getRecipient(ElementProperties elementProperties) {
        String methodName = "getRecipient";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "recipient", elementProperties, "getRecipient");
        }
        return null;
    }

    protected String getLicensedBy(ElementProperties elementProperties) {
        String methodName = "getLicensedBy";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "licensedBy", elementProperties, "getLicensedBy");
        }
        return null;
    }

    protected String getLicensee(ElementProperties elementProperties) {
        String methodName = "getLicensee";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "licensee", elementProperties, "getLicensee");
        }
        return null;
    }

    protected String removePreferredValue(ElementProperties elementProperties) {
        String methodName = "removePreferredValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "preferredValue", elementProperties, "removePreferredValue");
        }
        return null;
    }

    protected String removeCategory(ElementProperties elementProperties) {
        String methodName = "removeCategory";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "category", elementProperties, "removeCategory");
        }
        return null;
    }

    protected boolean removeIsCaseSensitive(ElementProperties elementProperties) {
        String methodName = "getStrictRequirement";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, "isCaseSensitive", elementProperties, "getStrictRequirement");
        }
        return false;
    }

    protected boolean getStrictRequirement(ElementProperties elementProperties) {
        String methodName = "getStrictRequirement";
        if (elementProperties != null) {
            return this.propertyHelper.getBooleanProperty(this.serviceName, "strictRequirement", elementProperties, "getStrictRequirement");
        }
        return false;
    }

    protected int getConfidence(ElementProperties elementProperties) {
        String methodName = "getConfidence";
        if (elementProperties != null) {
            return this.propertyHelper.getIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE.name, elementProperties, "getConfidence");
        }
        return 0;
    }

    protected String getSteward(ElementProperties elementProperties) {
        String methodName = "getSteward";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD.name, elementProperties, "getSteward");
        }
        return null;
    }

    protected String getStewardTypeName(ElementProperties elementProperties) {
        String methodName = "getStewardTypeName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_TYPE_NAME.name, elementProperties, "getStewardTypeName");
        }
        return null;
    }

    protected String getStewardPropertyName(ElementProperties elementProperties) {
        String methodName = "getStewardPropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, elementProperties, "getStewardPropertyName");
        }
        return null;
    }

    protected String getNotes(ElementProperties elementProperties) {
        String methodName = "getNotes";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, OpenMetadataProperty.NOTES.name, elementProperties, "getNotes");
        }
        return null;
    }

    protected String getAttributeName(ElementProperties elementProperties) {
        String methodName = "getAttributeName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "attributeName", elementProperties, "getAttributeName");
        }
        return null;
    }

    protected String getPointType(ElementProperties elementProperties) {
        String methodName = "getPointType";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "pointType", elementProperties, "getPointType");
        }
        return null;
    }

    protected String getAssociationDescription(ElementProperties elementProperties) {
        String methodName = "getAssociationDescription";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "associationDescription", elementProperties, "getAssociationDescription");
        }
        return null;
    }

    protected String getSymbolicName(ElementProperties elementProperties) {
        String methodName = "getSymbolicName";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "symbolicName", elementProperties, "getSymbolicName");
        }
        return null;
    }

    protected String getImplementationValue(ElementProperties elementProperties) {
        String methodName = "getImplementationValue";
        if (elementProperties != null) {
            return this.propertyHelper.getStringProperty(this.serviceName, "implementationValue", elementProperties, "getImplementationValue");
        }
        return null;
    }

    protected Map<String, String> getAdditionalValues(ElementProperties elementProperties) {
        String methodName = "getAdditionalValues";
        if (elementProperties != null) {
            return this.propertyHelper.getStringMapFromProperty(this.serviceName, "additionalValues", elementProperties, "getAdditionalValues");
        }
        return null;
    }

    protected String removeCommentText(ElementProperties elementProperties) {
        String methodName = "removeCommentText";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TEXT.name, elementProperties, "removeCommentText");
        }
        return null;
    }

    protected boolean getIsPublic(ElementProperties elementProperties) {
        String methodName = "getIsPublic";
        if (elementProperties != null) {
            return this.propertyHelper.getBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, elementProperties, "getIsPublic");
        }
        return false;
    }

    protected boolean removeIsPublic(ElementProperties elementProperties) {
        String methodName = "removeIsPublic";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanProperty(this.serviceName, OpenMetadataProperty.IS_PUBLIC.name, elementProperties, "removeIsPublic");
        }
        return false;
    }

    protected String removeReview(ElementProperties elementProperties) {
        String methodName = "removeReview";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.REVIEW.name, elementProperties, "removeReview");
        }
        return null;
    }

    protected String removeTagName(ElementProperties elementProperties) {
        String methodName = "removeTagName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TAG_NAME.name, elementProperties, "removeTagName");
        }
        return null;
    }

    protected String removeTagDescription(ElementProperties elementProperties) {
        String methodName = "removeTagDescription";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.TAG_DESCRIPTION.name, elementProperties, "removeTagDescription");
        }
        return null;
    }

    protected Date removeExecutionDate(ElementProperties elementProperties) {
        String methodName = "removeExecutionDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, "executionDate", elementProperties, "removeExecutionDate");
        }
        return null;
    }

    protected Map<String, String> removeAnalysisParameters(ElementProperties elementProperties) {
        String methodName = "removeAnalysisParameters";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ANALYSIS_PARAMETERS.name, elementProperties, "removeAnalysisParameters");
        }
        return null;
    }

    protected String removeAnalysisStep(ElementProperties elementProperties) {
        String methodName = "removeAnalysisStep";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ANALYSIS_STEP.name, elementProperties, "removeAnalysisStep");
        }
        return null;
    }

    protected String removeAnnotationType(ElementProperties elementProperties) {
        String methodName = "removeAnnotationType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ANNOTATION_TYPE.name, elementProperties, "removeAnnotationType");
        }
        return null;
    }

    protected int removeConfidenceLevel(ElementProperties elementProperties) {
        String methodName = "removeConfidenceLevel";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE_LEVEL.name, elementProperties, "removeConfidenceLevel");
        }
        return 0;
    }

    protected int removeConfidence(ElementProperties elementProperties) {
        String methodName = "removeConfidence";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.CONFIDENCE.name, elementProperties, "removeConfidence");
        }
        return 0;
    }

    protected String removeExpression(ElementProperties elementProperties) {
        String methodName = "removeExpression";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXPRESSION.name, elementProperties, "removeExpression");
        }
        return null;
    }

    protected String removeAttributeName(ElementProperties elementProperties) {
        String methodName = "removeAttributeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "attributeName", elementProperties, "removeAttributeName");
        }
        return null;
    }

    protected String removeExplanation(ElementProperties elementProperties) {
        String methodName = "removeExplanation";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.EXPLANATION.name, elementProperties, "removeExplanation");
        }
        return null;
    }

    protected String removeJsonProperties(ElementProperties elementProperties) {
        String methodName = "removeJsonProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.JSON_PROPERTIES.name, elementProperties, "removeJsonProperties");
        }
        return null;
    }

    protected Date removeReviewDate(ElementProperties elementProperties) {
        String methodName = "removeReviewDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.REVIEW_DATE.name, elementProperties, "removeReviewDate");
        }
        return null;
    }

    protected String removeSteward(ElementProperties elementProperties) {
        String methodName = "removeSteward";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.STEWARD.name, elementProperties, "removeSteward");
        }
        return null;
    }

    protected String removeStewardTypeName(ElementProperties elementProperties) {
        String methodName = "removeStewardTypeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_TYPE_NAME.name, elementProperties, "removeStewardTypeName");
        }
        return null;
    }

    protected String removeStewardPropertyName(ElementProperties elementProperties) {
        String methodName = "removeStewardPropertyName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.STEWARD_PROPERTY_NAME.name, elementProperties, "removeStewardPropertyName");
        }
        return null;
    }

    protected String removeNotes(ElementProperties elementProperties) {
        String methodName = "removeNotes";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.NOTES.name, elementProperties, "removeNotes");
        }
        return null;
    }

    protected String removeComment(ElementProperties elementProperties) {
        String methodName = "removeComment";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.COMMENT.name, elementProperties, "removeComment");
        }
        return null;
    }

    protected String removeSchemaName(ElementProperties elementProperties) {
        String methodName = "removeSchemaName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCHEMA_NAME.name, elementProperties, "removeSchemaName");
        }
        return null;
    }

    protected String removeSchemaType(ElementProperties elementProperties) {
        String methodName = "removeSchemaType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.SCHEMA_TYPE.name, elementProperties, "removeSchemaType");
        }
        return null;
    }

    protected Map<String, String> removeCandidateClassifications(ElementProperties elementProperties) {
        String methodName = "removeCandidateClassifications";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_CLASSIFICATIONS.name, elementProperties, "removeCandidateClassifications");
        }
        return null;
    }

    protected List<String> removeCandidateDataClassGUIDs(ElementProperties elementProperties) {
        String methodName = "removeCandidateDataClassGUIDs";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_DATA_CLASS_GUIDS.name, elementProperties, "removeCandidateDataClassGUIDs");
        }
        return null;
    }

    protected String removeInferredDataType(ElementProperties elementProperties) {
        String methodName = "removeInferredDataType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFERRED_DATA_TYPE.name, elementProperties, "removeInferredDataType");
        }
        return null;
    }

    protected String removeInferredFormat(ElementProperties elementProperties) {
        String methodName = "removeInferredFormat";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFERRED_FORMAT.name, elementProperties, "removeInferredFormat");
        }
        return null;
    }

    protected int removeInferredLength(ElementProperties elementProperties) {
        String methodName = "removeInferredLength";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_LENGTH.name, elementProperties, "removeInferredLength");
        }
        return 0;
    }

    protected int removeInferredPrecision(ElementProperties elementProperties) {
        String methodName = "removeInferredPrecision";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_PRECISION.name, elementProperties, "removeInferredPrecision");
        }
        return 0;
    }

    protected int removeInferredScale(ElementProperties elementProperties) {
        String methodName = "removeInferredScale";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.INFERRED_SCALE.name, elementProperties, "removeInferredScale");
        }
        return 0;
    }

    protected List<String> removeProfilePropertyNames(ElementProperties elementProperties) {
        String methodName = "removeProfilePropertyNames";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.PROFILE_PROPERTY_NAMES.name, elementProperties, "removeProfilePropertyNames");
        }
        return null;
    }

    protected Date removeProfileStartDate(ElementProperties elementProperties) {
        String methodName = "removeProfileStartDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROFILE_START_DATE.name, elementProperties, "removeProfileStartDate");
        }
        return null;
    }

    protected Date removeProfileEndDate(ElementProperties elementProperties) {
        String methodName = "removeProfileEndDate";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateProperty(this.serviceName, OpenMetadataProperty.PROFILE_END_DATE.name, elementProperties, "removeProfileEndDate");
        }
        return null;
    }

    protected Map<String, String> removeProfileProperties(ElementProperties elementProperties) {
        String methodName = "removeProfileProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_PROPERTIES.name, elementProperties, "removeProfileProperties");
        }
        return null;
    }

    protected Map<String, Boolean> removeProfileFlags(ElementProperties elementProperties) {
        String methodName = "removeProfileFlags";
        if (elementProperties != null) {
            return this.propertyHelper.removeBooleanMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_FLAGS.name, elementProperties, "removeProfileFlags");
        }
        return null;
    }

    protected Map<String, Date> removeProfileDates(ElementProperties elementProperties) {
        String methodName = "removeProfileDates";
        if (elementProperties != null) {
            return this.propertyHelper.removeDateMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_DATES.name, elementProperties, "removeProfileDates");
        }
        return null;
    }

    protected Map<String, Long> removeProfileCounts(ElementProperties elementProperties) {
        String methodName = "removeProfileCounts";
        if (elementProperties != null) {
            return this.propertyHelper.removeLongMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_COUNTS.name, elementProperties, "removeProfileCounts");
        }
        return null;
    }

    protected Map<String, Double> removeProfileDoubles(ElementProperties elementProperties) {
        String methodName = "removeProfileDoubles";
        if (elementProperties != null) {
            return this.propertyHelper.removeDoubleMapFromProperty(this.serviceName, OpenMetadataProperty.PROFILE_DOUBLES.name, elementProperties, "removeProfileDoubles");
        }
        return null;
    }

    protected List<String> removeValueList(ElementProperties elementProperties) {
        String methodName = "removeValueList";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.VALUE_LIST.name, elementProperties, "removeValueList");
        }
        return null;
    }

    protected Map<String, Integer> removeValueCount(ElementProperties elementProperties) {
        String methodName = "removeValueCount";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntegerMapFromProperty(this.serviceName, OpenMetadataProperty.VALUE_COUNT.name, elementProperties, "removeValueCount");
        }
        return null;
    }

    protected String removeValueRangeFrom(ElementProperties elementProperties) {
        String methodName = "removeValueRangeFrom";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VALUE_RANGE_FROM.name, elementProperties, "removeValueRangeFrom");
        }
        return null;
    }

    protected String removeValueRangeTo(ElementProperties elementProperties) {
        String methodName = "removeValueRangeTo";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.VALUE_RANGE_TO.name, elementProperties, "removeValueRangeTo");
        }
        return null;
    }

    protected String removeAverageValue(ElementProperties elementProperties) {
        String methodName = "removeAverageValue";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.AVERAGE_VALUE.name, elementProperties, "removeAverageValue");
        }
        return null;
    }

    protected Map<String, String> removeResourceProperties(ElementProperties elementProperties) {
        String methodName = "removeResourceProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.RESOURCE_PROPERTIES.name, elementProperties, "removeResourceProperties");
        }
        return null;
    }

    protected long removeSize(ElementProperties elementProperties) {
        String methodName = "removeSize";
        if (elementProperties != null) {
            return this.propertyHelper.removeLongProperty(this.serviceName, OpenMetadataProperty.SIZE.name, elementProperties, "removeSize");
        }
        return 0L;
    }

    protected String removeEncoding(ElementProperties elementProperties) {
        String methodName = "removeEncoding";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ENCODING.name, elementProperties, "removeEncoding");
        }
        return null;
    }

    protected String removeParameterType(ElementProperties elementProperties) {
        String methodName = "removeParameterType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "parameterType", elementProperties, "removeParameterType");
        }
        return null;
    }

    protected String removeQualityDimension(ElementProperties elementProperties) {
        String methodName = "removeQualityDimension";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.QUALITY_DIMENSION.name, elementProperties, "removeQualityDimension");
        }
        return null;
    }

    protected int removeQualityScore(ElementProperties elementProperties) {
        String methodName = "removeQualityScore";
        if (elementProperties != null) {
            return this.propertyHelper.removeIntProperty(this.serviceName, OpenMetadataProperty.QUALITY_SCORE.name, elementProperties, "removeQualityScore");
        }
        return 0;
    }

    protected String removeAttachmentGUID(ElementProperties elementProperties) {
        String methodName = "removeAttachmentGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ATTACHMENT_GUID.name, elementProperties, "removeAttachmentGUID");
        }
        return null;
    }

    protected String removeRelatedEntityGUID(ElementProperties elementProperties) {
        String methodName = "removeRelatedEntityGUID";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.RELATED_ENTITY_GUID.name, elementProperties, "removeRelatedEntityGUID");
        }
        return null;
    }

    protected String removeRelationshipTypeName(ElementProperties elementProperties) {
        String methodName = "removeRelationshipTypeName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.RELATIONSHIP_TYPE_NAME.name, elementProperties, "removeRelationshipTypeName");
        }
        return null;
    }

    protected Map<String, String> removeRelationshipProperties(ElementProperties elementProperties) {
        String methodName = "removeRelationshipProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.RELATIONSHIP_PROPERTIES.name, elementProperties, "removeRelationshipProperties");
        }
        return null;
    }

    protected String removeActionSourceName(ElementProperties elementProperties) {
        String methodName = "removeActionSourceName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ACTION_SOURCE_NAME.name, elementProperties, "removeActionSourceName");
        }
        return null;
    }

    protected String removeActionRequested(ElementProperties elementProperties) {
        String methodName = "removeActionRequested";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.ACTION_REQUESTED.name, elementProperties, "removeActionRequested");
        }
        return null;
    }

    protected Map<String, String> removeActionProperties(ElementProperties elementProperties) {
        String methodName = "removeActionProperties";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringMapFromProperty(this.serviceName, OpenMetadataProperty.ACTION_PROPERTIES.name, elementProperties, "removeActionProperties");
        }
        return null;
    }

    protected String removeInformalTerm(ElementProperties elementProperties) {
        String methodName = "removeInformalTerm";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFORMAL_TERM.name, elementProperties, "removeInformalTerm");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryTermGUIDs(ElementProperties elementProperties) {
        String methodName = "removeCandidateGlossaryTermGUIDs";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_GLOSSARY_TERM_GUIDS.name, elementProperties, "removeCandidateGlossaryTermGUIDs");
        }
        return null;
    }

    protected String removeInformalTopic(ElementProperties elementProperties) {
        String methodName = "removeInformalTopic";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, OpenMetadataProperty.INFORMAL_CATEGORY.name, elementProperties, "removeInformalTopic");
        }
        return null;
    }

    protected List<String> removeCandidateGlossaryCategoryGUIDs(ElementProperties elementProperties) {
        String methodName = "removeCandidateGlossaryCategoryGUIDs";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, OpenMetadataProperty.CANDIDATE_GLOSSARY_CATEGORY_GUIDS.name, elementProperties, "removeCandidateGlossaryCategoryGUIDs");
        }
        return null;
    }

    protected String removeDataFieldName(ElementProperties elementProperties) {
        String methodName = "removeDataFieldName";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "dataFieldName", elementProperties, "removeDataFieldName");
        }
        return null;
    }

    protected String removeDataFieldType(ElementProperties elementProperties) {
        String methodName = "removeDataFieldType";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "dataFieldType", elementProperties, "removeDataFieldType");
        }
        return null;
    }

    protected String removeDataFieldDescription(ElementProperties elementProperties) {
        String methodName = "removeDataFieldDescription";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringProperty(this.serviceName, "dataFieldDescription", elementProperties, "removeDataFieldDescription");
        }
        return null;
    }

    protected List<String> removeDataFieldAliases(ElementProperties elementProperties) {
        String methodName = "removeDataFieldAliases";
        if (elementProperties != null) {
            return this.propertyHelper.removeStringArrayProperty(this.serviceName, "dataFieldAliases", elementProperties, "removeDataFieldAliases");
        }
        return null;
    }
}

