/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class StructTypePropertyValue
extends PropertyValue {
    private ElementProperties attributes = null;

    public StructTypePropertyValue() {
    }

    public StructTypePropertyValue(StructTypePropertyValue template) {
        super(template);
        if (template != null) {
            this.attributes = template.getAttributes();
        }
    }

    @Override
    public PropertyValue cloneFromSubclass() {
        return new StructTypePropertyValue(this);
    }

    @Override
    public String valueAsString() {
        if (this.attributes != null) {
            return this.mapValuesAsString(this.attributes.getPropertyValueMap()).toString();
        }
        return null;
    }

    @Override
    public Object valueAsObject() {
        if (this.attributes != null) {
            return this.mapValuesAsObject(this.attributes.getPropertyValueMap());
        }
        return null;
    }

    public ElementProperties getAttributes() {
        if (this.attributes == null) {
            return null;
        }
        return new ElementProperties(this.attributes);
    }

    public void setAttributes(ElementProperties attributes) {
        this.attributes = attributes;
    }

    @Override
    public String toString() {
        return "StructTypePropertyValue{attributes=" + this.attributes + ", typeName='" + this.getTypeName() + "'}";
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        StructTypePropertyValue that = (StructTypePropertyValue)objectToCompare;
        return Objects.equals(this.attributes, that.attributes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attributes);
    }
}

