/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.controls;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;

public enum Guard {
    SERVICE_COMPLETED("service-completed", CompletionStatus.ACTIONED, "The service completed successfully."),
    SERVICE_FAILED("service-failed", CompletionStatus.FAILED, "An unexpected error occurred while the governance service was running.  Messages are logged to the audit log explaining the source of the error."),
    INVALID_ACTION_TARGET_TYPE("invalid-action-target-type", CompletionStatus.INVALID, "One or all of the action targets passed to this service are not of the correct type and so the service has failed to start."),
    NO_TARGETS_DETECTED("no-targets-detected", CompletionStatus.INVALID, "There is no supplied action target and so the governance service does not know which asset to work on."),
    TARGET_NOT_ASSET("target-not-asset", CompletionStatus.INVALID, "The action target is not an asset."),
    MULTIPLE_TARGETS_DETECTED("multiple-targets-detected", CompletionStatus.INVALID, "Multiple action targets supplied.  This governance service does not support multiple action targets because the result of the origin search could be different for each action target making it difficult to automate the response.");

    public final String name;
    public final CompletionStatus completionStatus;
    public final String description;

    private Guard(String name, CompletionStatus completionStatus, String description) {
        this.name = name;
        this.completionStatus = completionStatus;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public CompletionStatus getCompletionStatus() {
        return this.completionStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<GuardType> getGuardTypes() {
        ArrayList<GuardType> guardTypes = new ArrayList<GuardType>();
        for (Guard guard : Guard.values()) {
            GuardType guardType = new GuardType();
            guardType.setGuard(guard.getName());
            guardType.setDescription(guard.getDescription());
            guardType.setCompletionStatus(guard.getCompletionStatus());
            guardTypes.add(guardType);
        }
        return guardTypes;
    }

    public GuardType getGuardType() {
        GuardType guardType = new GuardType();
        guardType.setGuard(this.name);
        guardType.setDescription(this.description);
        guardType.setCompletionStatus(this.completionStatus);
        return guardType;
    }

    public String toString() {
        return "Guard{ name='" + this.name + "}";
    }
}

