/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;

public class MetadataElementSummaryConverter<B>
extends OpenMetadataConverterBase<B> {
    public MetadataElementSummaryConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, OpenMetadataElement openMetadataElement, String methodName) throws PropertyServerException {
        if (openMetadataElement != null) {
            try {
                B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (returnBean instanceof MetadataElementSummary) {
                    MetadataElementSummary elementSummary = (MetadataElementSummary)returnBean;
                    ElementHeader elementHeader = new ElementHeader((ElementControlHeader)openMetadataElement);
                    elementHeader.setGUID(openMetadataElement.getElementGUID());
                    elementHeader.setClassifications(this.getElementClassifications(openMetadataElement.getClassifications()));
                    elementSummary.setElementHeader(elementHeader);
                    if (openMetadataElement.getElementProperties() != null) {
                        elementSummary.setProperties(openMetadataElement.getElementProperties().getPropertiesAsStrings());
                    }
                }
                return returnBean;
            }
            catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
                super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            }
        }
        return null;
    }

    public List<B> getNewBeans(Class<B> beanClass, List<OpenMetadataElement> openMetadataElements, String methodName) throws PropertyServerException {
        ArrayList<B> results = null;
        if (openMetadataElements != null) {
            results = new ArrayList<B>();
            for (OpenMetadataElement openMetadataElement : openMetadataElements) {
                if (openMetadataElement == null) continue;
                results.add(this.getNewBean(beanClass, openMetadataElement, methodName));
            }
        }
        return results;
    }
}

