/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.search;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFErrorCode;
import org.odpi.openmetadata.frameworks.governanceaction.ffdc.GAFRuntimeException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.AttachedClassification;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.search.ArrayTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.governanceaction.search.EnumTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MapTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.MatchCriteria;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypeCategory;
import org.odpi.openmetadata.frameworks.governanceaction.search.PrimitiveTypePropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyComparisonOperator;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyCondition;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyValue;
import org.odpi.openmetadata.frameworks.governanceaction.search.SearchProperties;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementClassification;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public class PropertyHelper {
    public void validateGUID(String guid, String guidParameter, String methodName) throws InvalidParameterException {
        if (guid == null || guid.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_GUID.getMessageDefinition(guidParameter, methodName), this.getClass().getName(), methodName, guidParameter);
        }
    }

    public void validateMandatoryName(String name, String nameParameter, String methodName) throws InvalidParameterException {
        if (name == null || name.isEmpty()) {
            throw new InvalidParameterException(GAFErrorCode.NULL_NAME.getMessageDefinition(nameParameter, methodName), this.getClass().getName(), methodName, nameParameter);
        }
    }

    public boolean isTypeOf(ElementControlHeader elementControlHeader, String expectedType) {
        if (expectedType == null) {
            return true;
        }
        if (elementControlHeader != null && elementControlHeader.getType() != null) {
            ArrayList<String> typeList = elementControlHeader.getType().getSuperTypeNames();
            if (typeList == null) {
                typeList = new ArrayList<String>();
            }
            typeList.add(elementControlHeader.getType().getTypeName());
            return typeList.contains(expectedType);
        }
        return false;
    }

    public String getDomainName(ElementControlHeader elementControlHeader) {
        String domainName = elementControlHeader.getType().getTypeName();
        if (elementControlHeader.getType().getSuperTypeNames() != null) {
            for (String superTypeName : elementControlHeader.getType().getSuperTypeNames()) {
                if (superTypeName.equals(OpenMetadataType.OPEN_METADATA_ROOT.typeName) || superTypeName.equals(OpenMetadataType.REFERENCEABLE.typeName)) continue;
                domainName = superTypeName;
            }
        }
        return domainName;
    }

    public String getAnchorGUID(ElementHeader elementHeader) {
        List classifications = elementHeader.getClassifications();
        if (classifications != null) {
            for (ElementClassification classification : classifications) {
                if (classification == null || !OpenMetadataType.ANCHORS_CLASSIFICATION.typeName.equals(classification.getClassificationName()) || classification.getClassificationProperties() == null) continue;
                return classification.getClassificationProperties().get(OpenMetadataProperty.ANCHOR_GUID.name).toString();
            }
        }
        return null;
    }

    public SearchProperties getSearchPropertiesByName(List<String> propertyNames, String value, PropertyComparisonOperator propertyComparisonOperator) {
        if (propertyNames != null && !propertyNames.isEmpty()) {
            SearchProperties searchProperties = new SearchProperties();
            PrimitiveTypePropertyValue propertyValue = new PrimitiveTypePropertyValue();
            propertyValue.setTypeName("string");
            propertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
            if (PropertyComparisonOperator.LIKE.equals((Object)propertyComparisonOperator)) {
                propertyValue.setPrimitiveValue(".*" + Pattern.quote(value) + ".*");
            } else {
                propertyValue.setPrimitiveValue(value);
            }
            ArrayList<PropertyCondition> propertyConditions = new ArrayList<PropertyCondition>();
            for (String propertyName : propertyNames) {
                PropertyCondition propertyCondition = new PropertyCondition();
                propertyCondition.setValue(propertyValue);
                propertyCondition.setProperty(propertyName);
                if (propertyComparisonOperator == null) {
                    propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                } else {
                    propertyCondition.setOperator(propertyComparisonOperator);
                }
                propertyConditions.add(propertyCondition);
            }
            searchProperties.setConditions(propertyConditions);
            searchProperties.setMatchCriteria(MatchCriteria.ANY);
            return searchProperties;
        }
        return null;
    }

    private ElementProperties addPrimitivePropertyToInstance(ElementProperties properties, String propertyName, Object propertyValue, PrimitiveTypeCategory propertyCategory) {
        if (propertyValue != null) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
            primitiveTypePropertyValue.setPrimitiveTypeCategory(propertyCategory);
            primitiveTypePropertyValue.setPrimitiveValue(propertyValue);
            primitiveTypePropertyValue.setTypeName(propertyCategory.getName());
            resultingProperties.setProperty(propertyName, primitiveTypePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addStringProperty(ElementProperties properties, String propertyName, String propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
    }

    public ElementProperties addIntProperty(ElementProperties properties, String propertyName, int propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
    }

    public ElementProperties addLongProperty(ElementProperties properties, String propertyName, long propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG);
    }

    public ElementProperties addFloatProperty(ElementProperties properties, String propertyName, float propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, Float.valueOf(propertyValue), PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT);
    }

    public ElementProperties addDateProperty(ElementProperties properties, String propertyName, Date propertyValue) {
        if (propertyValue != null) {
            Long longValue = propertyValue.getTime();
            return this.addPrimitivePropertyToInstance(properties, propertyName, longValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE);
        }
        return properties;
    }

    public ElementProperties addBooleanProperty(ElementProperties properties, String propertyName, boolean propertyValue) {
        return this.addPrimitivePropertyToInstance(properties, propertyName, propertyValue, PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
    }

    public ElementProperties addEnumProperty(ElementProperties properties, String propertyName, String propertyType, String symbolicName) {
        ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
        EnumTypePropertyValue enumTypePropertyValue = new EnumTypePropertyValue();
        enumTypePropertyValue.setSymbolicName(symbolicName);
        enumTypePropertyValue.setTypeName(propertyType);
        resultingProperties.setProperty(propertyName, enumTypePropertyValue);
        return resultingProperties;
    }

    public ElementProperties addStringArrayProperty(ElementProperties properties, String propertyName, List<String> arrayValues) {
        if (arrayValues != null && !arrayValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ArrayTypePropertyValue arrayTypePropertyValue = new ArrayTypePropertyValue();
            arrayTypePropertyValue.setTypeName("array<string>");
            arrayTypePropertyValue.setArrayCount(arrayValues.size());
            int index = 0;
            for (String arrayValue : arrayValues) {
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                primitiveTypePropertyValue.setPrimitiveValue(arrayValue);
                arrayTypePropertyValue.setArrayValue(index, primitiveTypePropertyValue);
                ++index;
            }
            resultingProperties.setProperty(propertyName, arrayTypePropertyValue);
            return resultingProperties;
        }
        return properties;
    }

    public ElementProperties addMapProperty(ElementProperties properties, String propertyName, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setTypeName("map<string,object>");
                mapTypePropertyValue.setMapValues(mapElementProperties);
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addPropertyMap(ElementProperties properties, Map<String, Object> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                Object mapPropertyValue = mapValues.get(mapPropertyName);
                if (mapPropertyValue instanceof String) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Integer) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Long) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Short) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_SHORT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Date) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                    Long timestamp = ((Date)mapPropertyValue).getTime();
                    primitiveTypePropertyValue.setPrimitiveValue(timestamp);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Character) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_CHAR.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Byte) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BYTE.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Boolean) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Float) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_FLOAT.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigDecimal) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGDECIMAL.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof BigInteger) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BIGINTEGER.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Double) {
                    primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                    primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                    primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                    primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                    resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof List) {
                    List propertyAsList = (List)mapPropertyValue;
                    ArrayTypePropertyValue arrayTypePropertyValue = new ArrayTypePropertyValue();
                    if (!propertyAsList.isEmpty()) {
                        int index = 0;
                        HashMap<String, Object> arrayPropertyAsMap = new HashMap<String, Object>();
                        for (Object arrayValueObject : propertyAsList) {
                            arrayPropertyAsMap.put(Integer.toString(index), arrayValueObject);
                            ++index;
                        }
                        arrayTypePropertyValue.setArrayValues(this.addPropertyMap(null, arrayPropertyAsMap));
                        arrayTypePropertyValue.setArrayCount(index);
                    }
                    arrayTypePropertyValue.setTypeName("array");
                    resultingProperties.setProperty(mapPropertyName, arrayTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue instanceof Map) {
                    Map propertyAsMap = (Map)mapPropertyValue;
                    MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                    mapTypePropertyValue.setMapValues(this.addPropertyMap(null, propertyAsMap));
                    mapTypePropertyValue.setTypeName("map");
                    resultingProperties.setProperty(mapPropertyName, mapTypePropertyValue);
                    ++propertyCount;
                    continue;
                }
                if (mapPropertyValue == null) continue;
                primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_UNKNOWN.getName());
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringMapProperty(ElementProperties properties, String propertyName, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addStringPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,string>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addBooleanMapProperty(ElementProperties properties, String propertyName, Map<String, Boolean> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addBooleanPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,boolean>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addIntMapProperty(ElementProperties properties, String propertyName, Map<String, Integer> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addIntPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,int>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addLongMapProperty(ElementProperties properties, String propertyName, Map<String, Long> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addLongPropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,long>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addDateMapProperty(ElementProperties properties, String propertyName, Map<String, Date> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addDatePropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,date>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addDoubleMapProperty(ElementProperties properties, String propertyName, Map<String, Double> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            ElementProperties mapElementProperties = this.addDoublePropertyMap(null, mapValues);
            if (mapElementProperties != null) {
                MapTypePropertyValue mapTypePropertyValue = new MapTypePropertyValue();
                mapTypePropertyValue.setMapValues(mapElementProperties);
                mapTypePropertyValue.setTypeName("map<string,double>");
                resultingProperties.setProperty(propertyName, mapTypePropertyValue);
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addStringPropertyMap(ElementProperties properties, Map<String, String> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                String mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addIntPropertyMap(ElementProperties properties, Map<String, Integer> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Integer mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addLongPropertyMap(ElementProperties properties, Map<String, Long> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Long mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addDatePropertyMap(ElementProperties properties, Map<String, Date> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Date mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addDoublePropertyMap(ElementProperties properties, Map<String, Double> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Double mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DOUBLE.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public ElementProperties addBooleanPropertyMap(ElementProperties properties, Map<String, Boolean> mapValues) {
        if (mapValues != null && !mapValues.isEmpty()) {
            ElementProperties resultingProperties = properties == null ? new ElementProperties() : properties;
            int propertyCount = 0;
            for (String mapPropertyName : mapValues.keySet()) {
                Boolean mapPropertyValue = mapValues.get(mapPropertyName);
                PrimitiveTypePropertyValue primitiveTypePropertyValue = new PrimitiveTypePropertyValue();
                primitiveTypePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN);
                primitiveTypePropertyValue.setPrimitiveValue(mapPropertyValue);
                primitiveTypePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN.getName());
                resultingProperties.setProperty(mapPropertyName, primitiveTypePropertyValue);
                ++propertyCount;
            }
            if (propertyCount > 0) {
                return resultingProperties;
            }
        }
        return properties;
    }

    public String removeStringProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        String retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public String removeEnumProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        String retrievedProperty = null;
        if (properties != null) {
            retrievedProperty = this.getEnumPropertySymbolicName(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, String> removeStringMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public int removeIntProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        int retrievedProperty = 0;
        if (properties != null) {
            retrievedProperty = this.getIntProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Date removeDateProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Date retrievedProperty = null;
        if (properties != null) {
            retrievedProperty = this.getDateProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public boolean removeBooleanProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        boolean retrievedProperty = false;
        if (properties != null) {
            retrievedProperty = this.getBooleanProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public long removeLongProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        long retrievedProperty = 0L;
        if (properties != null) {
            retrievedProperty = this.getLongProperty(sourceName, propertyName, properties, methodName);
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public List<String> removeStringArrayProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        List<String> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getStringArrayProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Object> removeMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Long> removeLongMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Long> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getLongMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Double> removeDoubleMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Double> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getDoubleMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Integer> removeIntegerMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Integer> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getIntegerMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Boolean> removeBooleanMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Boolean> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getBooleanMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    public Map<String, Date> removeDateMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Date> retrievedProperty = null;
        if (properties != null && (retrievedProperty = this.getDateMapFromProperty(sourceName, propertyName, properties, methodName)) != null) {
            this.removeProperty(propertyName, properties);
        }
        return retrievedProperty;
    }

    protected void removeProperty(String propertyName, ElementProperties properties) {
        Map<String, PropertyValue> instancePropertyValueMap;
        if (properties != null && (instancePropertyValueMap = properties.getPropertyValueMap()) != null) {
            instancePropertyValueMap.remove(propertyName);
            properties.setPropertyValueMap(instancePropertyValueMap);
        }
    }

    public Map<String, String> getStringMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, String> stringMapFromProperty = new HashMap<String, String>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                stringMapFromProperty.put(mapPropertyName, actualPropertyValue.toString());
            }
            if (!stringMapFromProperty.isEmpty()) {
                return stringMapFromProperty;
            }
        }
        return null;
    }

    public Map<String, Boolean> getBooleanMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Boolean> booleanMap = new HashMap<String, Boolean>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                booleanMap.put(mapPropertyName, (Boolean)actualPropertyValue);
            }
            if (!booleanMap.isEmpty()) {
                return booleanMap;
            }
        }
        return null;
    }

    public Map<String, Date> getDateMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Date> dateMap = new HashMap<String, Date>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                dateMap.put(mapPropertyName, (Date)actualPropertyValue);
            }
            if (!dateMap.isEmpty()) {
                return dateMap;
            }
        }
        return null;
    }

    public Map<String, Long> getLongMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Long> longMap = new HashMap<String, Long>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                longMap.put(mapPropertyName, Long.parseLong(actualPropertyValue.toString()));
            }
            if (!longMap.isEmpty()) {
                return longMap;
            }
        }
        return null;
    }

    public Map<String, Double> getDoubleMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Double> doubleMap = new HashMap<String, Double>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                doubleMap.put(mapPropertyName, Double.parseDouble(actualPropertyValue.toString()));
            }
            if (!doubleMap.isEmpty()) {
                return doubleMap;
            }
        }
        return null;
    }

    public Map<String, Integer> getIntegerMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        Map<String, Object> mapFromProperty = this.getMapFromProperty(sourceName, propertyName, properties, methodName);
        if (mapFromProperty != null) {
            HashMap<String, Integer> integerMap = new HashMap<String, Integer>();
            for (String mapPropertyName : mapFromProperty.keySet()) {
                Object actualPropertyValue = mapFromProperty.get(mapPropertyName);
                if (actualPropertyValue == null) continue;
                integerMap.put(mapPropertyName, (Integer)actualPropertyValue);
            }
            if (!integerMap.isEmpty()) {
                return integerMap;
            }
        }
        return null;
    }

    public Map<String, Object> getMapFromProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getMapFromProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                if (propertyValue instanceof MapTypePropertyValue) {
                    MapTypePropertyValue mapTypePropertyValue = (MapTypePropertyValue)propertyValue;
                    return this.getElementPropertiesAsMap(mapTypePropertyValue.getMapValues());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getMapFromProperty");
            }
        }
        return null;
    }

    public String getEnumPropertySymbolicName(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue instancePropertyValue = properties.getPropertyValue(propertyName);
        if (instancePropertyValue instanceof EnumTypePropertyValue) {
            EnumTypePropertyValue enumTypePropertyValue = (EnumTypePropertyValue)instancePropertyValue;
            return enumTypePropertyValue.getSymbolicName();
        }
        return null;
    }

    public Map<String, Object> getElementPropertiesAsMap(ElementProperties properties) {
        if (properties != null) {
            Map<String, PropertyValue> propertyValues = properties.getPropertyValueMap();
            HashMap<String, Object> resultingMap = new HashMap<String, Object>();
            if (propertyValues != null) {
                for (String mapPropertyName : propertyValues.keySet()) {
                    PropertyValue actualPropertyValue = properties.getPropertyValue(mapPropertyName);
                    if (actualPropertyValue == null) continue;
                    if (actualPropertyValue instanceof PrimitiveTypePropertyValue) {
                        PrimitiveTypePropertyValue primitiveTypePropertyValue = (PrimitiveTypePropertyValue)actualPropertyValue;
                        resultingMap.put(mapPropertyName, primitiveTypePropertyValue.getPrimitiveValue());
                        continue;
                    }
                    resultingMap.put(mapPropertyName, actualPropertyValue);
                }
            }
            return resultingMap;
        }
        return null;
    }

    public String replacePrimitiveStringWithPlaceholders(String propertyValue, Map<String, String> placeholderProperties) {
        if (propertyValue == null || !((String)propertyValue).contains("{{")) {
            return propertyValue;
        }
        if (placeholderProperties != null && !placeholderProperties.isEmpty()) {
            for (String placeholderName : placeholderProperties.keySet()) {
                String placeholderMatchString = "{{" + placeholderName + "}}";
                if (((String)propertyValue).equals(placeholderMatchString)) {
                    propertyValue = placeholderProperties.get(placeholderName);
                    continue;
                }
                String regExMatchString = Pattern.quote(placeholderMatchString);
                String[] configBits = ((String)propertyValue).split(regExMatchString);
                if (configBits.length == 1) {
                    if (((String)propertyValue).equals(configBits[0])) continue;
                    propertyValue = configBits[0] + placeholderProperties.get(placeholderName);
                    continue;
                }
                if (configBits.length <= 1) continue;
                StringBuilder newConfigString = new StringBuilder();
                boolean firstPart = true;
                for (String configBit : configBits) {
                    if (!firstPart) {
                        newConfigString.append(placeholderProperties.get(placeholderName));
                    }
                    firstPart = false;
                    if (configBit == null) continue;
                    newConfigString.append(configBit);
                }
                if (((String)propertyValue).endsWith(placeholderMatchString)) {
                    newConfigString.append(placeholderProperties.get(placeholderName));
                }
                propertyValue = newConfigString.toString();
            }
        }
        return propertyValue;
    }

    public String getResolvedStringPropertyFromTemplate(String sourceName, OpenMetadataElement templateElement, String propertyName, Map<String, String> placeholderProperties) {
        String methodName = "";
        if (templateElement != null) {
            String propertyValue = this.getStringProperty(sourceName, propertyName, templateElement.getElementProperties(), "");
            return this.replacePrimitiveStringWithPlaceholders(propertyValue, placeholderProperties);
        }
        return null;
    }

    public String getStringProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getStringProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return primitiveTypePropertyValue.getPrimitiveValue().toString();
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getStringProperty");
            }
        }
        return null;
    }

    public List<String> getStringArrayProperty(String sourceName, String propertyName, ElementProperties properties, String callingMethodName) {
        PropertyValue instancePropertyValue;
        String thisMethodName = "getStringArrayProperty";
        if (properties != null && (instancePropertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                ArrayTypePropertyValue arrayPropertyValue;
                if (instancePropertyValue instanceof ArrayTypePropertyValue && (arrayPropertyValue = (ArrayTypePropertyValue)instancePropertyValue).getArrayCount() > 0) {
                    return this.getPropertiesAsArray(arrayPropertyValue.getArrayValues());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, callingMethodName, "getStringArrayProperty");
            }
        }
        return null;
    }

    private List<String> getPropertiesAsArray(ElementProperties elementProperties) {
        if (elementProperties != null) {
            Map<String, PropertyValue> instancePropertyValues = elementProperties.getPropertyValueMap();
            ArrayList<String> resultingArray = new ArrayList<String>();
            for (String arrayOrdinalName : instancePropertyValues.keySet()) {
                if (arrayOrdinalName == null) continue;
                int arrayOrdinalNumber = Integer.decode(arrayOrdinalName);
                PropertyValue actualPropertyValue = elementProperties.getPropertyValue(arrayOrdinalName);
                if (!(actualPropertyValue instanceof PrimitiveTypePropertyValue)) continue;
                PrimitiveTypePropertyValue primitiveTypePropertyValue = (PrimitiveTypePropertyValue)actualPropertyValue;
                resultingArray.add(arrayOrdinalNumber, primitiveTypePropertyValue.getPrimitiveValue().toString());
            }
            return resultingArray;
        }
        return null;
    }

    public int getIntProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getIntProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_INT && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Integer.parseInt(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getIntProperty");
            }
        }
        return 0;
    }

    public long getLongProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getLongProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_LONG && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Long.parseLong(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getLongProperty");
            }
        }
        return 0L;
    }

    public Date getDateProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getDateProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_DATE && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    Long timestamp = (Long)primitiveTypePropertyValue.getPrimitiveValue();
                    return new Date(timestamp);
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getDateProperty");
            }
        }
        return null;
    }

    public boolean getBooleanProperty(String sourceName, String propertyName, ElementProperties properties, String methodName) {
        PropertyValue propertyValue;
        String thisMethodName = "getBooleanProperty";
        if (properties != null && (propertyValue = properties.getPropertyValue(propertyName)) != null) {
            try {
                PrimitiveTypePropertyValue primitiveTypePropertyValue;
                if (propertyValue instanceof PrimitiveTypePropertyValue && (primitiveTypePropertyValue = (PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory() == PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_BOOLEAN && primitiveTypePropertyValue.getPrimitiveValue() != null) {
                    return Boolean.parseBoolean(primitiveTypePropertyValue.getPrimitiveValue().toString());
                }
            }
            catch (Exception error) {
                this.throwHelperLogicError(sourceName, methodName, "getBooleanProperty");
            }
        }
        return false;
    }

    public SearchProperties getSearchPropertiesForMetadataCollectionName(String metadataCollectionQualifiedName) {
        SearchProperties searchProperties = new SearchProperties();
        ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
        PropertyCondition condition = new PropertyCondition();
        PrimitiveTypePropertyValue primitivePropertyValue = new PrimitiveTypePropertyValue();
        primitivePropertyValue.setPrimitiveTypeCategory(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING);
        primitivePropertyValue.setPrimitiveValue(metadataCollectionQualifiedName);
        primitivePropertyValue.setTypeName(PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING.getName());
        condition.setProperty(OpenMetadataProperty.METADATA_COLLECTION_NAME.name);
        condition.setOperator(PropertyComparisonOperator.EQ);
        condition.setValue(primitivePropertyValue);
        conditions.add(condition);
        searchProperties.setConditions(conditions);
        searchProperties.setMatchCriteria(MatchCriteria.ALL);
        return searchProperties;
    }

    public SearchProperties getSearchProperties(ElementProperties properties, MatchCriteria matchCriteria) {
        SearchProperties matchProperties = null;
        if (properties != null) {
            matchProperties = new SearchProperties();
            ArrayList<PropertyCondition> conditions = new ArrayList<PropertyCondition>();
            Iterator<String> propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = propertyNames.next();
                PropertyCondition propertyCondition = new PropertyCondition();
                propertyCondition.setProperty(propertyName);
                PropertyValue propertyValue = properties.getPropertyValue(propertyName);
                if (propertyValue instanceof PrimitiveTypePropertyValue && ((PrimitiveTypePropertyValue)propertyValue).getPrimitiveTypeCategory().equals((Object)PrimitiveTypeCategory.OM_PRIMITIVE_TYPE_STRING)) {
                    propertyCondition.setOperator(PropertyComparisonOperator.LIKE);
                } else {
                    propertyCondition.setOperator(PropertyComparisonOperator.EQ);
                }
                propertyCondition.setValue(propertyValue);
                conditions.add(propertyCondition);
            }
            matchProperties.setConditions(conditions);
            matchProperties.setMatchCriteria(matchCriteria);
        }
        return matchProperties;
    }

    public AttachedClassification getClassification(OpenMetadataElement openMetadataElement, String classificationName) {
        List<AttachedClassification> classifications;
        if (openMetadataElement != null && classificationName != null && (classifications = openMetadataElement.getClassifications()) != null) {
            for (AttachedClassification classification : classifications) {
                if (!classificationName.equals(classification.getClassificationName())) continue;
                return classification;
            }
        }
        return null;
    }

    public boolean isClassified(ElementHeader elementHeader, String classificationName) {
        if (elementHeader == null || elementHeader.getClassifications() == null) {
            return false;
        }
        for (ElementClassification classification : elementHeader.getClassifications()) {
            if (classification == null || !classificationName.equals(classification.getClassificationName())) continue;
            return true;
        }
        return false;
    }

    public String getStringPropertyFromClassification(OpenMetadataElement openMetadataElement, String classificationName, String propertyName, String methodName) {
        AttachedClassification classification = this.getClassification(openMetadataElement, classificationName);
        if (classification != null) {
            return this.getStringProperty(classificationName, propertyName, classification.getClassificationProperties(), methodName);
        }
        return null;
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_ERROR.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName);
    }

    private void throwHelperLogicError(String sourceName, String originatingMethodName, String localMethodName, Exception unexpectedException) {
        throw new GAFRuntimeException(GAFErrorCode.HELPER_LOGIC_EXCEPTION.getMessageDefinition(sourceName, localMethodName, originatingMethodName), this.getClass().getName(), localMethodName, unexpectedException);
    }
}

