/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.converters;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.governanceaction.converters.OpenMetadataConverterBase;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.PropertyHelper;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementControlHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.MetadataElementSummary;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.RelatedMetadataElementSummary;

public class RelatedMetadataElementSummaryConverter<B>
extends OpenMetadataConverterBase<B> {
    public RelatedMetadataElementSummaryConverter(PropertyHelper propertyHelper, String serviceName, String serverName) {
        super(propertyHelper, serviceName, serverName);
    }

    @Override
    public B getNewBean(Class<B> beanClass, RelatedMetadataElement relatedMetadataElement, String methodName) throws PropertyServerException {
        try {
            B returnBean = beanClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (returnBean instanceof RelatedMetadataElementSummary) {
                RelatedMetadataElementSummary relatedElementSummary = (RelatedMetadataElementSummary)returnBean;
                MetadataElementSummary elementSummary = new MetadataElementSummary();
                ElementHeader elementHeader = new ElementHeader((ElementControlHeader)relatedMetadataElement);
                elementHeader.setGUID(relatedMetadataElement.getRelationshipGUID());
                relatedElementSummary.setRelationshipHeader(elementHeader);
                if (relatedMetadataElement.getRelationshipProperties() != null) {
                    relatedElementSummary.setRelationshipProperties(relatedMetadataElement.getRelationshipProperties().getPropertiesAsStrings());
                }
                elementHeader = new ElementHeader((ElementControlHeader)relatedMetadataElement.getElement());
                elementHeader.setGUID(relatedMetadataElement.getElement().getElementGUID());
                elementHeader.setClassifications(this.getElementClassifications(relatedMetadataElement.getElement().getClassifications()));
                elementSummary.setElementHeader(elementHeader);
                if (relatedMetadataElement.getElement().getElementProperties() != null) {
                    elementSummary.setProperties(relatedMetadataElement.getElement().getElementProperties().getPropertiesAsStrings());
                }
                relatedElementSummary.setRelatedElement(elementSummary);
            }
            return returnBean;
        }
        catch (ClassCastException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException error) {
            super.handleInvalidBeanClass(beanClass.getName(), error, methodName);
            return null;
        }
    }

    public List<B> getNewBeans(Class<B> beanClass, RelatedMetadataElementList relatedMetadataElements, String methodName) throws PropertyServerException {
        ArrayList<B> results = null;
        if (relatedMetadataElements != null && relatedMetadataElements.getElementList() != null) {
            results = new ArrayList<B>();
            for (RelatedMetadataElement relatedMetadataElement : relatedMetadataElements.getElementList()) {
                if (relatedMetadataElement == null) continue;
                results.add(this.getNewBean(beanClass, relatedMetadataElement, methodName));
            }
        }
        return results;
    }
}

