/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.properties.EngineActionElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.GovernanceActionProcessStepExecution;
import org.odpi.openmetadata.frameworks.openmetadata.metadataelements.ElementHeader;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionProcessStepExecutionElement {
    private ElementHeader elementHeader = null;
    private GovernanceActionProcessStepExecution processStepProperties = null;
    private Map<String, List<Map<String, String>>> specification = null;
    private String mermaidSpecification = null;

    public GovernanceActionProcessStepExecutionElement() {
    }

    public GovernanceActionProcessStepExecutionElement(GovernanceActionProcessStepExecutionElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = template.getProcessStepProperties();
            this.specification = template.getSpecification();
            this.mermaidSpecification = template.getMermaidSpecification();
        }
    }

    public GovernanceActionProcessStepExecutionElement(GovernanceActionProcessStepElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = new GovernanceActionProcessStepExecution(template.getProcessStepProperties());
            this.specification = template.getSpecification();
            this.mermaidSpecification = template.getMermaidSpecification();
        }
    }

    public GovernanceActionProcessStepExecutionElement(EngineActionElement template) {
        if (template != null) {
            this.elementHeader = template.getElementHeader();
            this.processStepProperties = new GovernanceActionProcessStepExecution(template);
            this.specification = null;
            this.mermaidSpecification = null;
        }
    }

    public ElementHeader getElementHeader() {
        return this.elementHeader;
    }

    public void setElementHeader(ElementHeader elementHeader) {
        this.elementHeader = elementHeader;
    }

    public GovernanceActionProcessStepExecution getProcessStepProperties() {
        return this.processStepProperties;
    }

    public void setProcessStepProperties(GovernanceActionProcessStepExecution processStepProperties) {
        this.processStepProperties = processStepProperties;
    }

    public Map<String, List<Map<String, String>>> getSpecification() {
        return this.specification;
    }

    public void setSpecification(Map<String, List<Map<String, String>>> specification) {
        this.specification = specification;
    }

    public String getMermaidSpecification() {
        return this.mermaidSpecification;
    }

    public void setMermaidSpecification(String mermaidSpecification) {
        this.mermaidSpecification = mermaidSpecification;
    }

    public String toString() {
        return "GovernanceActionProcessStepExecutionElement{elementHeader=" + String.valueOf(this.elementHeader) + ", processStepProperties=" + String.valueOf((Object)this.processStepProperties) + ", specification=" + String.valueOf(this.specification) + ", mermaidSpecification='" + this.mermaidSpecification + "'}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || this.getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionProcessStepExecutionElement that = (GovernanceActionProcessStepExecutionElement)objectToCompare;
        return Objects.equals(this.elementHeader, that.elementHeader) && Objects.equals((Object)this.processStepProperties, (Object)that.processStepProperties) && Objects.equals(this.specification, that.specification) && Objects.equals(this.mermaidSpecification, that.mermaidSpecification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.elementHeader, this.processStepProperties, this.specification, this.mermaidSpecification});
    }
}

