/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.frameworks.governanceaction.properties;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.GuardType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;
import org.odpi.openmetadata.frameworks.openmetadata.properties.ReferenceableProperties;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class GovernanceActionTypeProperties
extends ReferenceableProperties {
    private int domainIdentifier = 0;
    private String displayName = null;
    private String description = null;
    private List<RequestParameterType> supportedRequestParameters = null;
    private List<ActionTargetType> supportedActionTargetTypes = null;
    private List<RequestParameterType> producedRequestParameters = null;
    private List<ActionTargetType> producedActionTargetTypes = null;
    private List<GuardType> producedGuards = null;
    private String governanceEngineGUID = null;
    private String requestType = null;
    private Map<String, String> fixedRequestParameters = null;
    private int waitTime = 0;

    public GovernanceActionTypeProperties() {
    }

    public GovernanceActionTypeProperties(GovernanceActionTypeProperties template) {
        super((ReferenceableProperties)template);
        if (template != null) {
            this.domainIdentifier = template.getDomainIdentifier();
            this.displayName = template.getDisplayName();
            this.description = template.getDescription();
            this.supportedRequestParameters = template.getSupportedRequestParameters();
            this.supportedActionTargetTypes = template.getSupportedActionTargetTypes();
            this.producedRequestParameters = template.getProducedRequestParameters();
            this.producedActionTargetTypes = template.getProducedActionTargetTypes();
            this.producedGuards = template.getProducedGuards();
            this.governanceEngineGUID = template.getGovernanceEngineGUID();
            this.requestType = template.getRequestType();
            this.fixedRequestParameters = template.getFixedRequestParameters();
            this.waitTime = template.getWaitTime();
        }
    }

    public int getDomainIdentifier() {
        return this.domainIdentifier;
    }

    public void setDomainIdentifier(int domainIdentifier) {
        this.domainIdentifier = domainIdentifier;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<RequestParameterType> getSupportedRequestParameters() {
        return this.supportedRequestParameters;
    }

    public void setSupportedRequestParameters(List<RequestParameterType> supportedRequestParameters) {
        this.supportedRequestParameters = supportedRequestParameters;
    }

    public List<ActionTargetType> getSupportedActionTargetTypes() {
        return this.supportedActionTargetTypes;
    }

    public void setSupportedActionTargetTypes(List<ActionTargetType> supportedActionTargetTypes) {
        this.supportedActionTargetTypes = supportedActionTargetTypes;
    }

    public List<RequestParameterType> getProducedRequestParameters() {
        return this.producedRequestParameters;
    }

    public void setProducedRequestParameters(List<RequestParameterType> producedRequestParameters) {
        this.producedRequestParameters = producedRequestParameters;
    }

    public List<ActionTargetType> getProducedActionTargetTypes() {
        return this.producedActionTargetTypes;
    }

    public void setProducedActionTargetTypes(List<ActionTargetType> producedActionTargetTypes) {
        this.producedActionTargetTypes = producedActionTargetTypes;
    }

    public List<GuardType> getProducedGuards() {
        return this.producedGuards;
    }

    public void setProducedGuards(List<GuardType> producedGuards) {
        this.producedGuards = producedGuards;
    }

    public String getGovernanceEngineGUID() {
        return this.governanceEngineGUID;
    }

    public void setGovernanceEngineGUID(String governanceEngineGUID) {
        this.governanceEngineGUID = governanceEngineGUID;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public Map<String, String> getFixedRequestParameters() {
        return this.fixedRequestParameters;
    }

    public void setFixedRequestParameters(Map<String, String> fixedRequestParameters) {
        this.fixedRequestParameters = fixedRequestParameters;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public String toString() {
        return "GovernanceActionTypeProperties{domainIdentifier=" + this.domainIdentifier + ", displayName='" + this.displayName + "', description='" + this.description + "', requiredRequestParameters=" + String.valueOf(this.supportedRequestParameters) + ", requiredActionTargets=" + String.valueOf(this.supportedActionTargetTypes) + ", producedRequestParameters=" + String.valueOf(this.producedRequestParameters) + ", producedActionTargets=" + String.valueOf(this.producedActionTargetTypes) + ", producedGuards=" + String.valueOf(this.producedGuards) + ", governanceEngineGUID='" + this.governanceEngineGUID + "', requestType='" + this.requestType + "', requestParameters=" + String.valueOf(this.fixedRequestParameters) + ", waitTime=" + this.waitTime + ", qualifiedName='" + this.getQualifiedName() + "', additionalProperties=" + String.valueOf(this.getAdditionalProperties()) + "}";
    }

    public boolean equals(Object objectToCompare) {
        if (this == objectToCompare) {
            return true;
        }
        if (objectToCompare == null || ((Object)((Object)this)).getClass() != objectToCompare.getClass()) {
            return false;
        }
        if (!super.equals(objectToCompare)) {
            return false;
        }
        GovernanceActionTypeProperties that = (GovernanceActionTypeProperties)((Object)objectToCompare);
        return this.domainIdentifier == that.domainIdentifier && Objects.equals(this.displayName, that.displayName) && Objects.equals(this.description, that.description) && this.waitTime == that.waitTime && Objects.equals(this.supportedRequestParameters, that.supportedRequestParameters) && Objects.equals(this.supportedActionTargetTypes, that.supportedActionTargetTypes) && Objects.equals(this.producedRequestParameters, that.producedRequestParameters) && Objects.equals(this.producedActionTargetTypes, that.producedActionTargetTypes) && Objects.equals(this.producedGuards, that.producedGuards) && Objects.equals(this.governanceEngineGUID, that.governanceEngineGUID) && Objects.equals(this.requestType, that.requestType) && Objects.equals(this.fixedRequestParameters, that.fixedRequestParameters);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.domainIdentifier, this.displayName, this.description, this.supportedRequestParameters, this.supportedActionTargetTypes, this.producedRequestParameters, this.producedActionTargetTypes, this.producedGuards, this.governanceEngineGUID, this.requestType, this.fixedRequestParameters, this.waitTime);
    }
}

