/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTargetType;
import org.odpi.openmetadata.frameworks.openmetadata.refdata.DeployedImplementationType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;

public enum CocoClinicalTrialActionTarget {
    PROJECT("clinicalTrialProject", "Project used to control the clinical trial.", OpenMetadataType.PROJECT.typeName, null, true),
    HOSPITAL("hospital", "Hospital that will be supplying data for the clinical trial.", "Organization", null, true),
    CONTACT_PERSON("hospitalContactPerson", "The person who can be contacted if there are problems with the data from this hospital.", OpenMetadataType.PERSON.typeName, null, true),
    PROCESS_OWNER("processOwner", "The person who is accountable for the correct management of the data.", OpenMetadataType.PERSON.typeName, null, true),
    CUSTODIAN("custodian", "The person who is responsible for the correct management of data and can be contacted inside of Coco pharmaceuticals.", OpenMetadataType.PERSON.typeName, null, true),
    STEWARD(ActionTarget.STEWARD.getName(), "The person, or team in Coco Pharmaceuticals that sets up metadata for data.", OpenMetadataType.ACTOR.typeName, null, true),
    CATALOG("dataLakeCatalog", "Schema where the weekly measurements volume is to reside.", UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getAssociatedTypeName(), UnityCatalogDeployedImplementationType.OSS_UC_CATALOG.getDeployedImplementationType(), true),
    LAST_UPDATE_CONNECTOR("lastUpdateConnector", "Integration connector that maintains the last update date for the volume.", DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.INTEGRATION_CONNECTOR.getDeployedImplementationType(), false),
    LANDING_AREA_CONNECTOR("landingAreaConnector", "Integration connector that maintains the last update date for the volume.", DeployedImplementationType.INTEGRATION_CONNECTOR.getAssociatedTypeName(), DeployedImplementationType.INTEGRATION_CONNECTOR.getDeployedImplementationType(), true),
    HOSPITAL_DATA_LICENSE_TYPE("hospitalDataLicenseType", "The type of licences granted by the hospital for data that originates from them for this clinical trial.", "LicenseType", null, true),
    APPROVED_PURPOSES("approvedPurpose", "A data processing purpose that has been approved for data from this hospital.  It is a combination of permitted purposes from the license, and Coco Pharmaceutical's own governance practices.", OpenMetadataType.DATA_PROCESSING_PURPOSE.typeName, null, false),
    HOSPITAL_CERTIFICATION_TYPE("hospitalCertificationType", "The certification type that should be used to certify the hospital.", "CertificationType", null, true),
    DATA_QUALITY_CERTIFICATION_TYPE("dataQualityCertificationType", "The certification type that should be used to certify that data from the hospital conforms to specification.", "CertificationType", null, true),
    GENERIC_ONBOARDING_PIPELINE("onboardingPipeline", "The standard onboarding pipeline that brings data from the landing area to the data lake that is not customized for a project or hospital.", "GovernanceActionProcess", null, true),
    GENERIC_HOSPITAL_NOMINATION_GAT("hospitalNominationGovernanceActionType", "The Governance Action Type that tentatively adds a hospital to a clinical trial.", "GovernanceActionType", null, true),
    GENERIC_HOSPITAL_CERTIFICATION_GAT("hospitalCertificationGovernanceActionType", "The Governance Action Type that implements the hospital certification process.", "GovernanceActionType", null, true),
    GENERIC_HOSPITAL_ONBOARDING_GAT("hospitalOnboardingGovernanceActionType", "The Governance Action Type that implements the hospital certification process.", "GovernanceActionType", null, true),
    GENERIC_SET_UP_DATA_LAKE_GAT("setUpDataLakeGovernanceActionType", "The Governance Action Type that sets up the volume in the data lake catalog.", "GovernanceActionType", null, true),
    ONBOARD_HOSPITAL_PROCESS("onboardHospitalProcess", "The Governance Action Process that sets up the onboarding pipeline.  SetUpDataLake needs to pass the destination directory onto this process.", "GovernanceActionProcess", null, true);

    public final String name;
    public final String description;
    public final String typeName;
    private final String deployedImplementationType;
    private final boolean required;

    private CocoClinicalTrialActionTarget(String name, String description, String typeName, String deployedImplementationType, boolean required) {
        this.name = name;
        this.description = description;
        this.typeName = typeName;
        this.deployedImplementationType = deployedImplementationType;
        this.required = required;
    }

    public static List<ActionTargetType> getClinicalTrialSetupActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(PROJECT.getActionTargetType());
        actionTargetTypes.add(HOSPITAL_CERTIFICATION_TYPE.getActionTargetType());
        actionTargetTypes.add(PROCESS_OWNER.getActionTargetType());
        actionTargetTypes.add(CUSTODIAN.getActionTargetType());
        actionTargetTypes.add(STEWARD.getActionTargetType());
        actionTargetTypes.add(LANDING_AREA_CONNECTOR.getActionTargetType());
        actionTargetTypes.add(LAST_UPDATE_CONNECTOR.getActionTargetType());
        actionTargetTypes.add(GENERIC_ONBOARDING_PIPELINE.getActionTargetType());
        actionTargetTypes.add(GENERIC_HOSPITAL_ONBOARDING_GAT.getActionTargetType());
        actionTargetTypes.add(GENERIC_HOSPITAL_NOMINATION_GAT.getActionTargetType());
        actionTargetTypes.add(GENERIC_HOSPITAL_CERTIFICATION_GAT.getActionTargetType());
        actionTargetTypes.add(GENERIC_SET_UP_DATA_LAKE_GAT.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getNominateHospitalActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(PROJECT.getActionTargetType());
        actionTargetTypes.add(CUSTODIAN.getActionTargetType());
        actionTargetTypes.add(PROCESS_OWNER.getActionTargetType());
        actionTargetTypes.add(HOSPITAL_CERTIFICATION_TYPE.getActionTargetType());
        actionTargetTypes.add(HOSPITAL.getActionTargetType());
        actionTargetTypes.add(CONTACT_PERSON.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getCertifyHospitalActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(PROJECT.getActionTargetType());
        actionTargetTypes.add(HOSPITAL_CERTIFICATION_TYPE.getActionTargetType());
        actionTargetTypes.add(CUSTODIAN.getActionTargetType());
        actionTargetTypes.add(HOSPITAL.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getSetUpDataLakeActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(PROJECT.getActionTargetType());
        actionTargetTypes.add(STEWARD.getActionTargetType());
        actionTargetTypes.add(LAST_UPDATE_CONNECTOR.getActionTargetType());
        actionTargetTypes.add(ONBOARD_HOSPITAL_PROCESS.getActionTargetType());
        actionTargetTypes.add(CATALOG.getActionTargetType());
        return actionTargetTypes;
    }

    public static List<ActionTargetType> getHospitalOnboardingActionTargetTypes() {
        HashMap<String, ActionTargetType> actionTargetTypes = new HashMap<String, ActionTargetType>();
        for (ActionTargetType actionTargetType : CocoClinicalTrialActionTarget.getCertifyWeeklyMeasurementsActionTargetTypes()) {
            actionTargetTypes.put(actionTargetType.getName(), actionTargetType);
        }
        actionTargetTypes.put(PROJECT.getActionTargetType().getName(), PROJECT.getActionTargetType());
        actionTargetTypes.put(HOSPITAL_CERTIFICATION_TYPE.getActionTargetType().getName(), HOSPITAL_CERTIFICATION_TYPE.getActionTargetType());
        actionTargetTypes.put(LANDING_AREA_CONNECTOR.getActionTargetType().getName(), LANDING_AREA_CONNECTOR.getActionTargetType());
        actionTargetTypes.put(GENERIC_ONBOARDING_PIPELINE.getActionTargetType().getName(), GENERIC_ONBOARDING_PIPELINE.getActionTargetType());
        actionTargetTypes.put(STEWARD.getActionTargetType().getName(), STEWARD.getActionTargetType());
        actionTargetTypes.put(HOSPITAL.getActionTargetType().getName(), HOSPITAL.getActionTargetType());
        return new ArrayList<ActionTargetType>(actionTargetTypes.values());
    }

    public static List<ActionTargetType> getCertifyWeeklyMeasurementsActionTargetTypes() {
        ArrayList<ActionTargetType> actionTargetTypes = new ArrayList<ActionTargetType>();
        actionTargetTypes.add(DATA_QUALITY_CERTIFICATION_TYPE.getActionTargetType());
        actionTargetTypes.add(HOSPITAL.getActionTargetType());
        return actionTargetTypes;
    }

    public ActionTargetType getActionTargetType() {
        ActionTargetType actionTargetType = new ActionTargetType();
        actionTargetType.setName(this.name);
        actionTargetType.setDescription(this.description);
        actionTargetType.setTypeName(this.typeName);
        actionTargetType.setDeployedImplementationType(this.deployedImplementationType);
        actionTargetType.setRequired(this.required);
        return actionTargetType;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDeployedImplementationType() {
        return this.deployedImplementationType;
    }

    public String toString() {
        return "ActionTarget{name='" + this.name + "}";
    }
}

