/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialBaseService
extends GeneralGovernanceActionService {
    protected PersonContactDetails getContactDetailsForPersonGUID(String personGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "getEmailForPersonGUID";
        PersonContactDetails personContactDetails = new PersonContactDetails();
        personContactDetails.personGUID = personGUID;
        OpenMetadataElement person = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(personGUID);
        personContactDetails.contactQName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.QUALIFIED_NAME.name, person.getElementProperties(), "getEmailForPersonGUID");
        personContactDetails.contactName = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.NAME.name, person.getElementProperties(), "getEmailForPersonGUID");
        RelatedMetadataElementList contactDetails = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(personGUID, 1, OpenMetadataType.CONTACT_THROUGH_RELATIONSHIP.typeName, 0, 0);
        if (contactDetails != null && contactDetails.getElementList() != null) {
            for (RelatedMetadataElement contactDetail : contactDetails.getElementList()) {
                if (contactDetail == null) continue;
                personContactDetails.contactEmail = this.propertyHelper.getStringProperty(this.governanceServiceName, OpenMetadataProperty.CONTACT_METHOD_VALUE.name, contactDetail.getElement().getElementProperties(), "getEmailForPersonGUID");
            }
        }
        return personContactDetails;
    }

    protected void checkCertificationValidForProject(String projectGUID, String certificationTypeGUID) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "checkCertificationValidForProject";
        int projectStartFrom = 0;
        RelatedMetadataElementList projects = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(certificationTypeGUID, 1, "GovernedBy", projectStartFrom, this.governanceContext.getMaxPageSize());
        while (projects != null && projects.getElementList() != null) {
            for (RelatedMetadataElement project : projects.getElementList()) {
                if (project == null || !projectGUID.equals(project.getElement().getElementGUID())) continue;
                return;
            }
            projects = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(certificationTypeGUID, 1, "GovernedBy", projectStartFrom += this.governanceContext.getMaxPageSize(), this.governanceContext.getMaxPageSize());
        }
        throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.WRONG_CERTIFICATION_TYPE_FOR_TRIAL.getMessageDefinition(this.governanceServiceName, certificationTypeGUID, projectGUID), ((Object)((Object)this)).getClass().getName(), "checkCertificationValidForProject");
    }

    protected String createGovernanceActionProcess(String processQualifiedName, String processName, String processDescription) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        ElementProperties processProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.QUALIFIED_NAME.name, processQualifiedName);
        processProperties = this.propertyHelper.addStringProperty(processProperties, OpenMetadataProperty.NAME.name, processName);
        processProperties = this.propertyHelper.addStringProperty(processProperties, OpenMetadataProperty.DESCRIPTION.name, processDescription);
        return this.governanceContext.getOpenMetadataStore().createMetadataElementInStore("GovernanceActionProcess", ElementStatus.ACTIVE, null, null, true, null, null, processProperties, null, null, null, false);
    }

    protected static class PersonContactDetails {
        String personGUID = null;
        String contactQName = null;
        String contactName = null;
        String contactEmail = null;

        protected PersonContactDetails() {
        }
    }
}

