/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.odpi.openmetadata.adapters.connectors.datastore.csvfile.CSVFileStoreConnector;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.properties.AssetUniverse;
import org.odpi.openmetadata.frameworks.connectors.properties.NestedSchemaType;
import org.odpi.openmetadata.frameworks.connectors.properties.SchemaAttributes;
import org.odpi.openmetadata.frameworks.connectors.properties.beans.SchemaAttribute;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.AnnotationStore;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyActionServiceConnector;
import org.odpi.openmetadata.frameworks.surveyaction.SurveyAssetStore;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.SurveyActionGuard;
import org.odpi.openmetadata.frameworks.surveyaction.properties.Annotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.QualityAnnotation;
import org.odpi.openmetadata.frameworks.surveyaction.properties.RequestForActionAnnotation;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialQualityDimension;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialsAnnotationType;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;

public class CocoClinicalTrialCertifyWeeklyMeasurementsService
extends SurveyActionServiceConnector {
    private static final String schemaType = "TabularSchemaType";
    private Connector connector = null;

    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        try {
            CompletionStatus completionStatus;
            ArrayList<String> outputGuards = new ArrayList<String>();
            AuditLogMessageDefinition messageDefinition = null;
            String certificationTypeGUID = null;
            String stewardGUID = null;
            AnnotationStore annotationStore = this.surveyContext.getAnnotationStore();
            annotationStore.setAnalysisStep(AnalysisStep.CHECK_ACTION_TARGETS.getName());
            if (this.surveyContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.surveyContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        certificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.STEWARD.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    stewardGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            if (certificationTypeGUID == null) {
                messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.surveyActionServiceName, CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName());
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else if (stewardGUID == null) {
                messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.surveyActionServiceName, CocoClinicalTrialActionTarget.STEWARD.getName());
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                SurveyAssetStore assetStore = this.surveyContext.getAssetStore();
                this.connector = super.performCheckAssetAnalysisStep(CSVFileStoreConnector.class, OpenMetadataType.CSV_FILE.typeName);
                AssetUniverse assetUniverse = assetStore.getAssetProperties();
                CSVFileStoreConnector assetConnector = (CSVFileStoreConnector)this.connector;
                long recordCount = assetConnector.getRecordCount();
                QualityAnnotation columnCountAnnotation = new QualityAnnotation();
                QualityAnnotation columnNamesAnnotation = new QualityAnnotation();
                QualityAnnotation patientIdAnnotation = new QualityAnnotation();
                QualityAnnotation dateAnnotation = new QualityAnnotation();
                QualityAnnotation angleLeftAnnotation = new QualityAnnotation();
                QualityAnnotation angleRightAnnotation = new QualityAnnotation();
                super.setUpAnnotation((Annotation)columnCountAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.SCHEMA_VALIDATION);
                super.setUpAnnotation((Annotation)columnNamesAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.SCHEMA_VALIDATION);
                super.setUpAnnotation((Annotation)patientIdAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.PATIENT_ID_VALIDATION);
                super.setUpAnnotation((Annotation)dateAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.PATIENT_ID_VALIDATION);
                super.setUpAnnotation((Annotation)angleLeftAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.ANGLE_VALIDATION);
                super.setUpAnnotation((Annotation)angleRightAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.ANGLE_VALIDATION);
                String columnCountAnnotationGUID = null;
                String columnNamesAnnotationGUID = null;
                String patientIdAnnotationGUID = null;
                String dateAnnotationGUID = null;
                String angleLeftAnnotationGUID = null;
                String angleRightAnnotationGUID = null;
                annotationStore.setAnalysisStep(AnalysisStep.SCHEMA_VALIDATION.getName());
                NestedSchemaType nestedSchemaType = this.getNestedSchemaType(assetUniverse, schemaType);
                if (nestedSchemaType == null) {
                    super.throwMissingSchemaType(assetUniverse.getGUID());
                    return;
                }
                String schemaTypeGUID = nestedSchemaType.getGUID();
                SchemaAttributes schemaAttributes = nestedSchemaType.getSchemaAttributes();
                HashMap<String, String> expectedColumns = new HashMap<String, String>();
                HashMap<Integer, String> expectedColumnNames = new HashMap<Integer, String>();
                while (schemaAttributes.hasNext()) {
                    SchemaAttribute schemaAttribute = schemaAttributes.next();
                    expectedColumns.put(schemaAttribute.getDisplayName(), schemaAttribute.getGUID());
                    expectedColumnNames.put(schemaAttribute.getElementPosition(), schemaAttribute.getDisplayName());
                }
                List actualColumnNames = assetConnector.getColumnNames();
                columnCountAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.NO_OF_COLUMNS_MATCH.getDisplayName());
                columnNamesAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.NAMES_OF_COLUMNS_MATCH.getDisplayName());
                if (actualColumnNames == null) {
                    columnCountAnnotation.setQualityScore(-expectedColumns.size());
                } else {
                    columnCountAnnotation.setQualityScore(actualColumnNames.size() - expectedColumns.size());
                    if (columnCountAnnotation.getQualityScore() == 0) {
                        int errorCount = 0;
                        for (int i = 0; i < expectedColumnNames.size(); ++i) {
                            if (expectedColumnNames.get(i) != null && actualColumnNames.get(i) != null && ((String)actualColumnNames.get(i)).contains((CharSequence)expectedColumnNames.get(i))) continue;
                            --errorCount;
                        }
                        columnNamesAnnotation.setQualityScore(errorCount);
                    } else if (columnCountAnnotation.getQualityScore() > 0) {
                        columnNamesAnnotation.setQualityScore(-columnCountAnnotation.getQualityScore());
                    } else {
                        columnNamesAnnotation.setQualityScore(columnCountAnnotation.getQualityScore());
                    }
                }
                columnCountAnnotationGUID = annotationStore.addAnnotation((Annotation)columnCountAnnotation, schemaTypeGUID);
                columnNamesAnnotationGUID = annotationStore.addAnnotation((Annotation)columnNamesAnnotation, schemaTypeGUID);
                if (columnNamesAnnotation.getQualityScore() == 0) {
                    annotationStore.setAnalysisStep(AnalysisStep.DATA_VALIDATION.getName());
                    int patientIdQualityScore = 0;
                    int dateQualityScore = 0;
                    int angleLeftQualityScore = 0;
                    int angleRightQualityScore = 0;
                    for (long recordNumber = 0L; recordNumber < recordCount; ++recordNumber) {
                        List recordValues = assetConnector.readRecord(recordNumber);
                        if (recordValues == null || recordValues.isEmpty()) continue;
                        try {
                            int patientId = Integer.parseInt((String)recordValues.get(0));
                            if (patientId < 1 || patientId > 32) {
                                --patientIdQualityScore;
                            }
                        }
                        catch (NumberFormatException notInt) {
                            --patientIdQualityScore;
                        }
                        List<String> validMonths = Arrays.asList("05", "06", "07");
                        try {
                            String[] dateParts = ((String)recordValues.get(1)).split("-");
                            if (dateParts.length != 3 || !"2024".equals(dateParts[0]) || !validMonths.contains(dateParts[1])) {
                                --dateQualityScore;
                            }
                        }
                        catch (PatternSyntaxException notDate) {
                            --dateQualityScore;
                        }
                        try {
                            int angle = Integer.parseInt((String)recordValues.get(2));
                            if (angle < -90 || angle > 90) {
                                --angleLeftQualityScore;
                            }
                        }
                        catch (NumberFormatException notInt) {
                            --angleLeftQualityScore;
                        }
                        try {
                            int angle = Integer.parseInt((String)recordValues.get(3));
                            if (angle >= -90 && angle <= 90) continue;
                            --angleRightQualityScore;
                            continue;
                        }
                        catch (NumberFormatException notInt) {
                            --angleRightQualityScore;
                        }
                    }
                    patientIdAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.VALID_PATIENT_ID.getDisplayName());
                    dateAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.VALID_DATE.getDisplayName());
                    angleLeftAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.VALID_LEFT_ANGLE.getDisplayName());
                    angleRightAnnotation.setQualityDimension(CocoClinicalTrialQualityDimension.VALID_RIGHT_ANGLE.getDisplayName());
                    patientIdAnnotation.setQualityScore(patientIdQualityScore);
                    dateAnnotation.setQualityScore(dateQualityScore);
                    angleLeftAnnotation.setQualityScore(angleLeftQualityScore);
                    angleRightAnnotation.setQualityScore(angleRightQualityScore);
                    patientIdAnnotationGUID = annotationStore.addAnnotation((Annotation)patientIdAnnotation, (String)expectedColumns.get("PatientId"));
                    dateAnnotationGUID = annotationStore.addAnnotation((Annotation)dateAnnotation, (String)expectedColumns.get("Date"));
                    angleLeftAnnotationGUID = annotationStore.addAnnotation((Annotation)angleLeftAnnotation, (String)expectedColumns.get("AngleLeft"));
                    angleRightAnnotationGUID = annotationStore.addAnnotation((Annotation)angleRightAnnotation, (String)expectedColumns.get("AngleRight"));
                }
                annotationStore.setAnalysisStep(AnalysisStep.PRODUCE_ACTIONS.getName());
                if (columnCountAnnotation.getQualityScore() == 0 && columnNamesAnnotation.getQualityScore() == 0 && patientIdAnnotation.getQualityScore() == 0 && dateAnnotation.getQualityScore() == 0 && angleLeftAnnotation.getQualityScore() == 0 && angleRightAnnotation.getQualityScore() == 0) {
                    ElementProperties elementProperties = this.propertyHelper.addDateProperty(null, "start", new Date());
                    elementProperties = this.propertyHelper.addStringProperty(elementProperties, "certificateGUID", annotationStore.getSurveyReportGUID());
                    this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore("Certification", assetUniverse.getGUID(), certificationTypeGUID, null, null, elementProperties);
                    outputGuards.add(SurveyActionGuard.DATA_CERTIFIED.getName());
                } else {
                    RequestForActionAnnotation requestForActionAnnotation = new RequestForActionAnnotation();
                    super.setUpAnnotation((Annotation)requestForActionAnnotation, (AnnotationType)CocoClinicalTrialsAnnotationType.FAILED_TO_PASS_QUALITY_GATE);
                    ArrayList<String> requestForActionTargetGUIDs = new ArrayList<String>();
                    requestForActionTargetGUIDs.add(stewardGUID);
                    requestForActionAnnotation.setActionTargetGUIDs(requestForActionTargetGUIDs);
                    String annotationGUID = annotationStore.addAnnotation((Annotation)requestForActionAnnotation, null);
                    if (columnCountAnnotation.getQualityScore() != 0 && columnCountAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, columnCountAnnotationGUID, annotationGUID, null, null, null);
                    }
                    if (columnNamesAnnotation.getQualityScore() != 0 && columnNamesAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, columnNamesAnnotationGUID, annotationGUID, null, null, null);
                    }
                    if (patientIdAnnotation.getQualityScore() != 0 && patientIdAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, patientIdAnnotationGUID, annotationGUID, null, null, null);
                    }
                    if (dateAnnotation.getQualityScore() != 0 && dateAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, dateAnnotationGUID, annotationGUID, null, null, null);
                    }
                    if (angleLeftAnnotation.getQualityScore() != 0 && angleLeftAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, angleLeftAnnotationGUID, annotationGUID, null, null, null);
                    }
                    if (angleRightAnnotation.getQualityScore() != 0 && angleRightAnnotationGUID != null) {
                        this.surveyContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.ASSOCIATED_ANNOTATION_RELATIONSHIP.typeName, angleRightAnnotationGUID, annotationGUID, null, null, null);
                        outputGuards.add(SurveyActionGuard.DATA_NOT_CERTIFIED.getName());
                    }
                }
                completionStatus = SurveyActionGuard.SURVEY_COMPLETED.getCompletionStatus();
                outputGuards.add(SurveyActionGuard.SURVEY_COMPLETED.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.surveyContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (Exception error) {
            super.handleUnexpectedException("start", error);
        }
    }

    public synchronized void disconnect() throws ConnectorCheckedException {
        if (this.connector != null) {
            this.connector.disconnect();
        }
        super.disconnect();
    }
}

