/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileRequestParameter;
import org.odpi.openmetadata.frameworks.governanceaction.controls.RequestParameterType;

public enum CocoClinicalTrialRequestParameter {
    DATA_LAKE_SCHEMA_TEMPLATE("dataLakeSchemaTemplateGUID", "Unique identifier of the template to use when cataloguing the unity catalog schema where the clinical trial results are to be stored.  Also add the placeholders used by this template as request parameters.", "string", "5bf92b0f-3970-41ea-b0a3-aacfbf6fd92e"),
    DATA_LAKE_SCHEMA_NAME("dataLakeSchemaName", "Name of the schema to use in the data lake for the clinical trial.", "string", "teddy_bear_drop_foot"),
    DATA_LAKE_SCHEMA_DESCRIPTION("dataLakeSchemaDescription", "Description of the schema to use in the data lake for the clinical trial.", "string", "Example clinical trial used for education and testing of governance procedures."),
    DATA_LAKE_VOLUME_TEMPLATE("dataLakeVolumeTemplateGUID", "Unique identifier of the template to use when cataloguing the directory where the weekly measurements results are to be stored.  Also add the placeholders used by this template as request parameters.", "string", "92d2d2dc-0798-41f0-9512-b10548d312b7"),
    DATA_LAKE_VOLUME_PATH_NAME("dataLakeVolumeDirectoryPathName", "Path name to store the files for the volume.", "string", "/deployments/data/coco-data-lake/research/clinical-trials/drop-foot/weekly-measurements"),
    DATA_LAKE_VOLUME_NAME("dataLakeVolumeName", "Name of the volume in Unity Catalog (UC).", "string", "weekly-measurements"),
    DATA_LAKE_VOLUME_DESCRIPTION("dataLakeVolumeDescription", "Short description of the volume in Unity Catalog (UC).", "string", "Weekly measurements for clinical trial"),
    LANDING_AREA_DIRECTORY_PATH_NAME("landingAreaDirectoryPathName", "Path name of the hospital's landing area directory.", "string", "landing-area/hospitals/oak-dene/clinical-trials/drop-foot"),
    LANDING_AREA_DIRECTORY_TEMPLATE("landingAreaDirectoryTemplateGUID", "Unique identifier of the template to use when creating the FileFolder for hospital's landing area files.", "string", "fbdd8efd-1b69-474c-bb6d-0a304b394146"),
    LANDING_AREA_FILE_TEMPLATE("landingAreaFileTemplateGUID", "Unique identifier of the template to use in the landing area when onboarding a file from a hospital.  A new, partially filled out template will be created for the hospital.  This template is of type CSVFile.", "string", "5e5ffc97-237d-46c6-95c3-49405035dedc"),
    DATA_LAKE_FILE_TEMPLATE("dataLakeFileTemplateGUID", "Unique identifier of the template to use in the data lake when onboarding a file from a hospital.  A new, partially filled out template will be created for the hospital.  This template is of type CSVFile.", "string", "b2ec7c9d-3462-488a-897d-8e873658dded");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private CocoClinicalTrialRequestParameter(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<RequestParameterType> getClinicalTrialSetUpRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(DATA_LAKE_VOLUME_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_SCHEMA_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(LANDING_AREA_DIRECTORY_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(LANDING_AREA_FILE_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_FILE_TEMPLATE.getRequestParameterType());
        return requestParameterTypes;
    }

    public static List<RequestParameterType> getNominateHospitalRequestParameterTypes() {
        return null;
    }

    public static List<RequestParameterType> getCertifyHospitalRequestParameterTypes() {
        return null;
    }

    public static List<RequestParameterType> getSetUpDataLakeRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(DATA_LAKE_SCHEMA_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_VOLUME_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_SCHEMA_NAME.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_VOLUME_PATH_NAME.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_SCHEMA_DESCRIPTION.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_VOLUME_NAME.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_VOLUME_DESCRIPTION.getRequestParameterType());
        return requestParameterTypes;
    }

    public static List<RequestParameterType> getHospitalOnboardingRequestParameterTypes() {
        ArrayList<RequestParameterType> requestParameterTypes = new ArrayList<RequestParameterType>();
        requestParameterTypes.add(LANDING_AREA_DIRECTORY_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(LANDING_AREA_FILE_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(DATA_LAKE_FILE_TEMPLATE.getRequestParameterType());
        requestParameterTypes.add(MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.getRequestParameterType());
        requestParameterTypes.add(LANDING_AREA_DIRECTORY_PATH_NAME.getRequestParameterType());
        return requestParameterTypes;
    }

    public RequestParameterType getRequestParameterType() {
        RequestParameterType requestParameterType = new RequestParameterType();
        requestParameterType.setName(this.name);
        requestParameterType.setDescription(this.description);
        requestParameterType.setDataType(this.dataType);
        requestParameterType.setExample(this.example);
        return requestParameterType;
    }

    public String toString() {
        return "RequestParameter{ name=" + this.name + "}";
    }
}

