/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileRequestParameter;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogDeployedImplementationType;
import org.odpi.openmetadata.adapters.connectors.unitycatalog.controls.UnityCatalogPlaceholderProperty;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.GeneralGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.MetadataCorrelationHeader;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ServerAssetUseType;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialPlaceholderProperty;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialRequestParameter;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialSetUpDataLakeService
extends GeneralGovernanceActionService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        String clinicalTrialId = null;
        String clinicalTrialName = null;
        String dataLakeCatalogQualifiedName = null;
        String dataLakeCatalogQualifiedGUID = null;
        String dataLakeCatalogName = null;
        String dataLakeSchemaName = null;
        String dataLakeSchemaDescription = "Example clinical trial used for education and testing of governance procedures.";
        String serverNetworkAddress = null;
        String dataLakeVolumePathName = null;
        String dataLakeVolumeName = "weekly_measurements";
        String dataLakeVolumeDescription = "Weekly measurements for clinical trial";
        String schemaTemplateGUID = "5bf92b0f-3970-41ea-b0a3-aacfbf6fd92e";
        String volumeTemplateGUID = "92d2d2dc-0798-41f0-9512-b10548d312b7";
        String lastUpdateConnectorGUID = null;
        String hospitalOnboardingProcessGUID = null;
        super.start();
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getRequestParameters() != null) {
                if (this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_TEMPLATE.getName()) != null) {
                    volumeTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_TEMPLATE.getName());
                }
                if (this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_TEMPLATE.getName()) != null) {
                    schemaTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_TEMPLATE.getName());
                }
            }
            if (this.governanceContext.getActionTargetElements() != null) {
                block3: for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.PROJECT.getName().equals(actionTargetElement.getActionTargetName())) {
                        clinicalTrialId = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.IDENTIFIER.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        clinicalTrialName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.CATALOG.getName().equals(actionTargetElement.getActionTargetName())) {
                        dataLakeCatalogQualifiedGUID = actionTargetElement.getTargetElement().getElementGUID();
                        dataLakeCatalogQualifiedName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.QUALIFIED_NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        List externalIdentifiers = this.governanceContext.getOpenMetadataStore().getExternalIdentifiers(dataLakeCatalogQualifiedGUID, dataLakeCatalogQualifiedName, actionTargetElement.getTargetElement().getElementGUID(), actionTargetElement.getTargetElement().getType().getTypeName(), 0, 0);
                        if (externalIdentifiers == null) continue;
                        for (MetadataCorrelationHeader externalIdentifier : externalIdentifiers) {
                            if (externalIdentifier == null || externalIdentifier.getMappingProperties() == null) continue;
                            dataLakeCatalogName = (String)externalIdentifier.getMappingProperties().get(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName());
                            serverNetworkAddress = (String)externalIdentifier.getMappingProperties().get(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName());
                            continue block3;
                        }
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName().equals(actionTargetElement.getActionTargetName())) {
                        lastUpdateConnectorGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.ONBOARD_HOSPITAL_PROCESS.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    hospitalOnboardingProcessGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            if (this.governanceContext.getRequestParameters() != null) {
                schemaTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_TEMPLATE.getName());
                volumeTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_TEMPLATE.getName());
                dataLakeSchemaName = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_NAME.getName());
                dataLakeSchemaDescription = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_DESCRIPTION.getName());
                dataLakeVolumePathName = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_PATH_NAME.getName());
                dataLakeVolumeName = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_NAME.getName());
                dataLakeVolumeDescription = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_DESCRIPTION.getName());
            }
            ArrayList<String> outputGuards = new ArrayList<String>();
            AuditLogMessageDefinition messageDefinition = null;
            if (clinicalTrialId == null || clinicalTrialName == null || dataLakeCatalogQualifiedGUID == null || dataLakeCatalogName == null || serverNetworkAddress == null || lastUpdateConnectorGUID == null || hospitalOnboardingProcessGUID == null || dataLakeSchemaName == null || dataLakeVolumePathName == null || schemaTemplateGUID == null || schemaTemplateGUID.isBlank() || volumeTemplateGUID == null || volumeTemplateGUID.isBlank()) {
                if (dataLakeCatalogQualifiedGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_CATALOG.getMessageDefinition(this.governanceServiceName, dataLakeCatalogQualifiedName);
                }
                if (clinicalTrialId == null || clinicalTrialId.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getName());
                }
                if (clinicalTrialName == null || clinicalTrialName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getName());
                }
                if (dataLakeCatalogName == null || dataLakeCatalogName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, UnityCatalogPlaceholderProperty.CATALOG_NAME.getName());
                }
                if (dataLakeSchemaName == null || dataLakeSchemaName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_NAME.getName());
                }
                if (volumeTemplateGUID == null || volumeTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_TEMPLATE.getName());
                }
                if (schemaTemplateGUID == null || schemaTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_SCHEMA_TEMPLATE.getName());
                }
                if (dataLakeVolumePathName == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_VOLUME_PATH_NAME.getName());
                }
                if (lastUpdateConnectorGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName());
                }
                if (hospitalOnboardingProcessGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.ONBOARD_HOSPITAL_PROCESS.getName());
                }
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                String schemaGUID = this.createSchema(dataLakeCatalogQualifiedGUID, dataLakeCatalogQualifiedName, schemaTemplateGUID, serverNetworkAddress, dataLakeCatalogQualifiedGUID, dataLakeCatalogName, dataLakeSchemaName, dataLakeSchemaDescription);
                String volumeAssetGUID = this.createVolume(dataLakeCatalogQualifiedGUID, dataLakeCatalogQualifiedName, volumeTemplateGUID, serverNetworkAddress, dataLakeCatalogName, schemaGUID, dataLakeSchemaName, dataLakeVolumeName, dataLakeVolumeDescription + ": " + clinicalTrialId + " - " + clinicalTrialName, dataLakeVolumePathName);
                this.monitorVolumeAsset(lastUpdateConnectorGUID, volumeAssetGUID, dataLakeCatalogQualifiedName);
                this.passOnDestinationFolder(dataLakeVolumePathName, hospitalOnboardingProcessGUID);
                completionStatus = CocoClinicalTrialGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.SET_UP_COMPLETE.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private String createSchema(String externalSourceGUID, String externalSourceName, String templateGUID, String serverNetworkAddress, String catalogGUID, String catalogName, String schemaName, String description) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), serverNetworkAddress);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), catalogName);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), schemaName);
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), description);
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), "V1.0");
        this.governanceContext.getOpenMetadataStore().setExternalSourceIds(externalSourceGUID, externalSourceName);
        String schemaGUID = this.governanceContext.getOpenMetadataStore().createMetadataElementFromTemplate(UnityCatalogDeployedImplementationType.OSS_UC_SCHEMA.getAssociatedTypeName(), catalogGUID, false, null, null, templateGUID, null, placeholderProperties, catalogGUID, OpenMetadataType.SERVER_ASSET_USE_RELATIONSHIP.typeName, this.propertyHelper.addEnumProperty(null, OpenMetadataProperty.USE_TYPE.name, ServerAssetUseType.getOpenTypeName(), ServerAssetUseType.OWNS.getName()), true);
        this.governanceContext.getOpenMetadataStore().setExternalSourceIds(null, null);
        return schemaGUID;
    }

    private String createVolume(String externalSourceGUID, String externalSourceName, String templateGUID, String serverNetworkAddress, String catalogName, String schemaGUID, String schemaName, String volumeName, String description, String dataLakePathName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(PlaceholderProperty.SERVER_NETWORK_ADDRESS.getName(), serverNetworkAddress);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.CATALOG_NAME.getName(), catalogName);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.SCHEMA_NAME.getName(), schemaName);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.VOLUME_NAME.getName(), volumeName);
        placeholderProperties.put(PlaceholderProperty.DESCRIPTION.getName(), description);
        placeholderProperties.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), "V1.0");
        placeholderProperties.put(UnityCatalogPlaceholderProperty.STORAGE_LOCATION.getName(), dataLakePathName);
        placeholderProperties.put(UnityCatalogPlaceholderProperty.VOLUME_TYPE.getName(), "EXTERNAL");
        this.governanceContext.getOpenMetadataStore().setExternalSourceIds(externalSourceGUID, externalSourceName);
        String volumeGUID = this.governanceContext.getOpenMetadataStore().createMetadataElementFromTemplate(UnityCatalogDeployedImplementationType.OSS_UC_VOLUME.getAssociatedTypeName(), schemaGUID, false, null, null, templateGUID, null, placeholderProperties, schemaGUID, OpenMetadataType.DATA_CONTENT_FOR_DATA_SET_RELATIONSHIP.typeName, null, false);
        this.governanceContext.getOpenMetadataStore().setExternalSourceIds(null, null);
        this.provisionVolume(dataLakePathName, volumeGUID);
        return volumeGUID;
    }

    private void provisionVolume(String pathName, String volumeGUID) {
        String methodName = "provisionVolume";
        File volumeDirectory = new File(pathName);
        if (!volumeDirectory.exists()) {
            try {
                FileUtils.forceMkdir((File)volumeDirectory);
            }
            catch (IOException error) {
                this.auditLog.logMessage("provisionVolume", GovernanceActionSamplesAuditCode.NO_VOLUME_DIRECTORY.getMessageDefinition(this.governanceServiceName, pathName, volumeGUID));
            }
        }
    }

    private void monitorVolumeAsset(String integrationConnectorGUID, String volumeAssetGUID, String dataLakeCatalogQualifiedName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        if (integrationConnectorGUID != null) {
            CatalogTargetProperties catalogTargetProperties = new CatalogTargetProperties();
            catalogTargetProperties.setMetadataSourceQualifiedName(dataLakeCatalogQualifiedName);
            catalogTargetProperties.setCatalogTargetName("dataFolder");
            this.governanceContext.addCatalogTarget(integrationConnectorGUID, volumeAssetGUID, catalogTargetProperties);
        }
    }

    private void passOnDestinationFolder(String destinationDirectory, String hospitalOnboardingProcessGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "passOnDestinationFolder";
        RelatedMetadataElement processFlowRelationship = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElement(hospitalOnboardingProcessGUID, 1, "GovernanceActionProcessFlow", new Date());
        if (processFlowRelationship != null) {
            HashMap<String, String> requestParameters = this.propertyHelper.getStringMapFromProperty(this.governanceServiceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, processFlowRelationship.getRelationshipProperties(), "passOnDestinationFolder");
            if (requestParameters == null) {
                requestParameters = new HashMap<String, String>();
            }
            requestParameters.put(MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.getName(), destinationDirectory);
            this.governanceContext.getOpenMetadataStore().updateRelatedElementsInStore(processFlowRelationship.getRelationshipGUID(), false, this.propertyHelper.addStringMapProperty(null, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters));
        }
    }
}

