/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.enums.ElementStatus;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialBaseService;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialPlaceholderProperty;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialRequestParameter;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialSetUpService
extends CocoClinicalTrialBaseService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        String genericHospitalNominationGUID = null;
        String genericHospitalCertificationGUID = null;
        String genericSetUpDataLakeGUID = null;
        String genericHospitalOnboardingGUID = null;
        String hospitalCertificationTypeGUID = null;
        String dataQualityCertificationTypeGUID = null;
        String clinicalTrialProjectGUID = null;
        String clinicalTrialId = null;
        String clinicalTrialName = null;
        String processOwnerGUID = null;
        String custodianGUID = null;
        String stewardGUID = null;
        String genericOnboardingPipelineGUID = null;
        String lastUpdateConnectorGUID = null;
        String landingAreaConnectorGUID = null;
        String landingAreaDirectoryTemplateGUID = null;
        String landingAreaFileTemplateGUID = null;
        String dataLakeFileTemplateGUID = null;
        super.start();
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.PROJECT.getName().equals(actionTargetElement.getActionTargetName())) {
                        clinicalTrialProjectGUID = actionTargetElement.getActionTargetGUID();
                        clinicalTrialId = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.IDENTIFIER.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        clinicalTrialName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        hospitalCertificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        dataQualityCertificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.GENERIC_SET_UP_DATA_LAKE_GAT.getName().equals(actionTargetElement.getActionTargetName())) {
                        genericSetUpDataLakeGUID = actionTargetElement.getActionTargetGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_CERTIFICATION_GAT.getName().equals(actionTargetElement.getActionTargetName())) {
                        genericHospitalCertificationGUID = actionTargetElement.getActionTargetGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_NOMINATION_GAT.getName().equals(actionTargetElement.getActionTargetName())) {
                        genericHospitalNominationGUID = actionTargetElement.getActionTargetGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_ONBOARDING_GAT.getName().equals(actionTargetElement.getActionTargetName())) {
                        genericHospitalOnboardingGUID = actionTargetElement.getActionTargetGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName().equals(actionTargetElement.getActionTargetName())) {
                        lastUpdateConnectorGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName().equals(actionTargetElement.getActionTargetName())) {
                        landingAreaConnectorGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.PROCESS_OWNER.getName().equals(actionTargetElement.getActionTargetName())) {
                        processOwnerGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.CUSTODIAN.getName().equals(actionTargetElement.getActionTargetName())) {
                        custodianGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.STEWARD.getName().equals(actionTargetElement.getActionTargetName())) {
                        stewardGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.GENERIC_ONBOARDING_PIPELINE.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    genericOnboardingPipelineGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            if (this.governanceContext.getRequestParameters() != null) {
                landingAreaDirectoryTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_TEMPLATE.getName());
                landingAreaFileTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.LANDING_AREA_FILE_TEMPLATE.getName());
                dataLakeFileTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_FILE_TEMPLATE.getName());
            }
            ArrayList<String> outputGuards = new ArrayList<String>();
            AuditLogMessageDefinition messageDefinition = null;
            if (clinicalTrialProjectGUID == null || clinicalTrialId == null || clinicalTrialId.isBlank() || clinicalTrialName == null || clinicalTrialName.isBlank() || lastUpdateConnectorGUID == null || landingAreaConnectorGUID == null || hospitalCertificationTypeGUID == null || dataQualityCertificationTypeGUID == null || genericHospitalNominationGUID == null || genericHospitalCertificationGUID == null || genericSetUpDataLakeGUID == null || genericHospitalOnboardingGUID == null || processOwnerGUID == null || custodianGUID == null || stewardGUID == null || genericOnboardingPipelineGUID == null || landingAreaDirectoryTemplateGUID == null || landingAreaDirectoryTemplateGUID.isBlank() || landingAreaFileTemplateGUID == null || landingAreaFileTemplateGUID.isBlank() || dataLakeFileTemplateGUID == null || dataLakeFileTemplateGUID.isBlank()) {
                if (clinicalTrialProjectGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.PROJECT.getName());
                } else if (clinicalTrialId == null || clinicalTrialId.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getName());
                } else if (clinicalTrialName == null || clinicalTrialName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getName());
                } else if (lastUpdateConnectorGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName());
                } else if (landingAreaConnectorGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName());
                } else if (genericHospitalNominationGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_NOMINATION_GAT.getName());
                } else if (genericHospitalCertificationGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_CERTIFICATION_GAT.getName());
                } else if (genericSetUpDataLakeGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_SET_UP_DATA_LAKE_GAT.getName());
                } else if (genericHospitalOnboardingGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_HOSPITAL_ONBOARDING_GAT.getName());
                } else if (hospitalCertificationTypeGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName());
                } else if (dataQualityCertificationTypeGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName());
                } else if (genericOnboardingPipelineGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_ONBOARDING_PIPELINE.getName());
                } else if (processOwnerGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.PROCESS_OWNER.getName());
                } else if (custodianGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.CUSTODIAN.getName());
                } else if (stewardGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.STEWARD.getName());
                } else if (landingAreaDirectoryTemplateGUID == null || landingAreaDirectoryTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_TEMPLATE.getName());
                } else if (landingAreaFileTemplateGUID == null || landingAreaFileTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.LANDING_AREA_FILE_TEMPLATE.getName());
                } else if (dataLakeFileTemplateGUID == null || dataLakeFileTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_FILE_TEMPLATE.getName());
                }
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                this.setUpCertificationType(clinicalTrialProjectGUID, hospitalCertificationTypeGUID);
                String nominateHospitalGUID = this.createProcessFromGovernanceActionType("ClinicalTrials:" + clinicalTrialId + ":nominate-hospital", "Nominate Hospital", "Set up the certification, data processing types and license for a hospital so that it may contribute data to the clinical trial.", genericHospitalNominationGUID, this.governanceContext.getRequestParameters());
                this.addActionTargetToProcess(nominateHospitalGUID, CocoClinicalTrialActionTarget.PROJECT.getName(), clinicalTrialProjectGUID);
                this.addActionTargetToProcess(nominateHospitalGUID, CocoClinicalTrialActionTarget.CUSTODIAN.getName(), custodianGUID);
                this.addActionTargetToProcess(nominateHospitalGUID, CocoClinicalTrialActionTarget.PROCESS_OWNER.getName(), processOwnerGUID);
                this.addActionTargetToProcess(nominateHospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName(), hospitalCertificationTypeGUID);
                String certifyHospitalGUID = this.createProcessFromGovernanceActionType("ClinicalTrials:" + clinicalTrialId + ":certify-hospital", "Certify Hospital", "Confirms the certification for a hospital so that it may contribute data to the clinical trial.", genericHospitalCertificationGUID, this.governanceContext.getRequestParameters());
                this.addActionTargetToProcess(certifyHospitalGUID, CocoClinicalTrialActionTarget.PROJECT.getName(), clinicalTrialProjectGUID);
                this.addActionTargetToProcess(certifyHospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName(), hospitalCertificationTypeGUID);
                this.addActionTargetToProcess(certifyHospitalGUID, CocoClinicalTrialActionTarget.CUSTODIAN.getName(), custodianGUID);
                String onboardHospitalGUID = this.createProcessFromGovernanceActionType("ClinicalTrials:" + clinicalTrialId + ":onboard-hospital", "Onboard Hospital", "Set up the onboarding pipeline that take data from a particular hospital and adds it to the data lake.", genericHospitalOnboardingGUID, this.governanceContext.getRequestParameters());
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.PROJECT.getName(), clinicalTrialProjectGUID);
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName(), hospitalCertificationTypeGUID);
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName(), dataQualityCertificationTypeGUID);
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName(), landingAreaConnectorGUID);
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.GENERIC_ONBOARDING_PIPELINE.getName(), genericOnboardingPipelineGUID);
                this.addActionTargetToProcess(onboardHospitalGUID, CocoClinicalTrialActionTarget.STEWARD.getName(), stewardGUID);
                String setUpDataLakeProcessGUID = this.createProcessFromGovernanceActionType("ClinicalTrials:" + clinicalTrialId + ":set-up-data-lake", "Set Up Data Lake", "Create the schema and volume in Unity Catalog (UC) for the clinical trial", genericSetUpDataLakeGUID, this.governanceContext.getRequestParameters());
                this.addActionTargetToProcess(setUpDataLakeProcessGUID, CocoClinicalTrialActionTarget.PROJECT.getName(), clinicalTrialProjectGUID);
                this.addActionTargetToProcess(setUpDataLakeProcessGUID, CocoClinicalTrialActionTarget.STEWARD.getName(), stewardGUID);
                this.addActionTargetToProcess(setUpDataLakeProcessGUID, CocoClinicalTrialActionTarget.LAST_UPDATE_CONNECTOR.getName(), lastUpdateConnectorGUID);
                this.addActionTargetToProcess(setUpDataLakeProcessGUID, CocoClinicalTrialActionTarget.ONBOARD_HOSPITAL_PROCESS.getName(), onboardHospitalGUID);
                completionStatus = CocoClinicalTrialGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.SET_UP_COMPLETE.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private void setUpCertificationType(String projectGUID, String certificationTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore("GovernedBy", certificationTypeGUID, projectGUID, null, null, null);
    }

    private String createProcessFromGovernanceActionType(String processQualifiedName, String processName, String processDescription, String governanceActionTypeGUID, Map<String, String> additionalRequestParameters) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        RelatedMetadataElement governanceActionExecutorRelationship;
        String processGUID = this.createGovernanceActionProcess(processQualifiedName, processName, processDescription);
        OpenMetadataElement governanceActionType = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(governanceActionTypeGUID);
        if (governanceActionType != null && (governanceActionExecutorRelationship = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElement(governanceActionTypeGUID, 1, "GovernanceActionExecutor", new Date())) != null) {
            RelatedMetadataElementList specifications;
            String governanceEngineGUID = governanceActionExecutorRelationship.getElement().getElementGUID();
            ElementProperties processStepProperties = this.propertyHelper.addStringProperty(governanceActionType.getElementProperties(), OpenMetadataProperty.QUALIFIED_NAME.name, processQualifiedName + ":processStep1");
            ElementProperties processFlowProperties = this.propertyHelper.addStringMapProperty(null, OpenMetadataProperty.REQUEST_PARAMETERS.name, additionalRequestParameters);
            String processStep1GUID = this.governanceContext.getOpenMetadataStore().createMetadataElementInStore("GovernanceActionProcessStep", ElementStatus.ACTIVE, null, processGUID, false, null, null, processStepProperties, processGUID, "GovernanceActionProcessFlow", processFlowProperties, true);
            this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore("GovernanceActionExecutor", processStep1GUID, governanceEngineGUID, null, null, governanceActionExecutorRelationship.getRelationshipProperties());
            RelatedMetadataElementList actionTargets = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(governanceActionTypeGUID, 1, OpenMetadataType.TARGET_FOR_ACTION_TYPE.typeName, 0, 0);
            if (actionTargets != null && actionTargets.getElementList() != null) {
                for (RelatedMetadataElement actionTarget : actionTargets.getElementList()) {
                    if (actionTarget == null) continue;
                    this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.TARGET_FOR_ACTION_PROCESS.typeName, processGUID, actionTarget.getElement().getElementGUID(), null, null, actionTarget.getRelationshipProperties());
                }
            }
            if ((specifications = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(governanceActionTypeGUID, 1, OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, 0, 0)) != null && specifications.getElementList() != null) {
                for (RelatedMetadataElement specification : specifications.getElementList()) {
                    if (specification == null) continue;
                    this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.SPECIFICATION_PROPERTY_ASSIGNMENT_RELATIONSHIP.typeName, processGUID, specification.getElement().getElementGUID(), null, null, specification.getRelationshipProperties());
                }
            }
        }
        return processGUID;
    }

    private void addActionTargetToProcess(String processGUID, String actionTargetName, String actionTargetGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.TARGET_FOR_ACTION_PROCESS.typeName, processGUID, actionTargetGUID, null, null, this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, actionTargetName));
    }
}

