/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnalysisStep;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationType;
import org.odpi.openmetadata.frameworks.surveyaction.controls.AnnotationTypeType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialQualityDimension;

public enum CocoClinicalTrialsAnnotationType implements AnnotationType
{
    SCHEMA_VALIDATION("Schema Validation", OpenMetadataType.QUALITY_ANNOTATION.typeName, AnalysisStep.SCHEMA_VALIDATION, "Validate that the structure of the data in the resource matches the schema attached to the asset.", "The assumption is that the schema defines the specification for the data.  Any deviation from the schema is an error.", CocoClinicalTrialQualityDimension.getSchemaValidationQualityDimensions()),
    PATIENT_ID_VALIDATION("Patient Identifier Validation", OpenMetadataType.QUALITY_ANNOTATION.typeName, AnalysisStep.DATA_VALIDATION, "Validate that the patient identifier is between 1 and 32.", "The clinical trial has recruited 32 patients, each is given an identifier number to hide their identity. .", CocoClinicalTrialQualityDimension.getPatientIdValidationQualityDimensions()),
    DATE_VALIDATION("Date Validation", OpenMetadataType.QUALITY_ANNOTATION.typeName, AnalysisStep.DATA_VALIDATION, "Validate that the date of the measurement is within the allowed date range.", "The clinical trial runs for a specific period.  Therefore the measurements should be dated within this period.", CocoClinicalTrialQualityDimension.getDateValidationQualityDimensions()),
    ANGLE_VALIDATION("Angle Validation", OpenMetadataType.QUALITY_ANNOTATION.typeName, AnalysisStep.DATA_VALIDATION, "Validate that the angle measured for each leg is within the allowed -90 to +90 degree range.", "The measurements are taken on a flat surface so the angle cannot be outside the range shown above.  A negative value means that the hip rotates inwards.  A positive value means that the hip rotates outwards", CocoClinicalTrialQualityDimension.getAngleValidationQualityDimensions()),
    FAILED_TO_PASS_QUALITY_GATE("Failed To Pass Quality Gate", OpenMetadataType.REQUEST_FOR_ACTION_ANNOTATION.typeName, AnalysisStep.PRODUCE_ACTIONS, "Determine whether the quality checks passed.", "If all the quality checks passed, then the supplied certification is added to the asset.  If not, this request for action is created and is linked to the failing annotations and asset.", null);

    public final String name;
    public final String openMetadataTypeName;
    public final AnalysisStep analysisStep;
    public final String summary;
    public final String explanation;
    public final List<SurveyMetric> metrics;

    private CocoClinicalTrialsAnnotationType(String name, String openMetadataTypeName, AnalysisStep analysisStep, String summary, String explanation, List<SurveyMetric> metrics) {
        this.name = name;
        this.openMetadataTypeName = openMetadataTypeName;
        this.analysisStep = analysisStep;
        this.summary = summary;
        this.explanation = explanation;
        this.metrics = metrics;
    }

    public static List<AnnotationTypeType> getAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        for (CocoClinicalTrialsAnnotationType annotationType : CocoClinicalTrialsAnnotationType.values()) {
            annotationTypeTypes.add(annotationType.getAnnotationTypeType());
        }
        return annotationTypeTypes;
    }

    public static List<AnnotationTypeType> getCertifyWeeklyMeasurementsSurveyAnnotationTypeTypes() {
        ArrayList<AnnotationTypeType> annotationTypeTypes = new ArrayList<AnnotationTypeType>();
        annotationTypeTypes.add(SCHEMA_VALIDATION.getAnnotationTypeType());
        annotationTypeTypes.add(PATIENT_ID_VALIDATION.getAnnotationTypeType());
        annotationTypeTypes.add(DATE_VALIDATION.getAnnotationTypeType());
        annotationTypeTypes.add(ANGLE_VALIDATION.getAnnotationTypeType());
        annotationTypeTypes.add(FAILED_TO_PASS_QUALITY_GATE.getAnnotationTypeType());
        return annotationTypeTypes;
    }

    public String getName() {
        return this.name;
    }

    public String getAnalysisStep() {
        return this.analysisStep.getName();
    }

    public String getOpenMetadataTypeName() {
        return this.openMetadataTypeName;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getExpression() {
        return null;
    }

    public AnnotationTypeType getAnnotationTypeType() {
        AnnotationTypeType annotationTypeType = new AnnotationTypeType();
        annotationTypeType.setName(this.name);
        annotationTypeType.setOpenMetadataTypeName(this.openMetadataTypeName);
        annotationTypeType.setAnalysisStepName(AnalysisStep.PROFILING_ASSOCIATED_RESOURCES.getName());
        annotationTypeType.setSummary(this.summary);
        annotationTypeType.setExplanation(this.explanation);
        if (this.metrics != null) {
            HashMap<String, String> metricsMap = new HashMap<String, String>();
            for (SurveyMetric folderMetric : this.metrics) {
                metricsMap.put(folderMetric.getDisplayName(), folderMetric.getDescription());
            }
            annotationTypeType.setOtherPropertyValues(metricsMap);
        }
        return annotationTypeType;
    }

    public String toString() {
        return "AnnotationType{ name='" + this.name + "}";
    }
}

