/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.ExceptionMessageSet;

public enum GovernanceActionSamplesErrorCode implements ExceptionMessageSet
{
    HOSPITAL_NOT_NOMINATED(400, "GOVERNANCE-ACTION-SAMPLES-400-001", "The {0} governance action service has detected that hospital {1} ({2}) is not nominated to participate in project {3} ({4})", "The service stops processing for this hospital.", "Retry the request once the nomination is complete."),
    UNCERTIFIED_HOSPITAL(400, "GOVERNANCE-ACTION-SAMPLES-400-002", "The {0} governance action service has detected that hospital {1} ({2}) is not certified to supply data for project {3} ({4})", "The service stops setting up the onboarding pipeline for this hospital.", "Retry the request once the certification is complete."),
    WRONG_CERTIFICATION_TYPE_FOR_TRIAL(400, "GOVERNANCE-ACTION-SAMPLES-400-003", "The {0} governance action service has detected that certification type {1} is not linked to the clinical trial project {2}", "The service stops certifying this hospital.", "Retry the request and ensure that a valid certification type, that is linked to the clinical trial project using the GovernedBy relationship, is specified in the action targets."),
    UNEXPECTED_EXCEPTION(500, "GOVERNANCE-ACTION-CONNECTORS-500-004", "The {0} governance action service received an unexpected exception {1} during its processing; the error message was: {2}", "The governance action returns an exception to the Governance Action Engine.", "Use details from the error message to determine the cause of the error and retry the service call once it is resolved.");

    private final int httpErrorCode;
    private final String errorMessageId;
    private final String errorMessage;
    private final String systemAction;
    private final String userAction;

    private GovernanceActionSamplesErrorCode(int httpErrorCode, String errorMessageId, String errorMessage, String systemAction, String userAction) {
        this.httpErrorCode = httpErrorCode;
        this.errorMessageId = errorMessageId;
        this.errorMessage = errorMessage;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public ExceptionMessageDefinition getMessageDefinition() {
        return new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
    }

    public ExceptionMessageDefinition getMessageDefinition(String ... params) {
        ExceptionMessageDefinition messageDefinition = new ExceptionMessageDefinition(this.httpErrorCode, this.errorMessageId, this.errorMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "ErrorCode{httpErrorCode=" + this.httpErrorCode + ", errorMessageId='" + this.errorMessageId + "', errorMessage='" + this.errorMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

