/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.Date;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialBaseService;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialCertifyHospitalService
extends CocoClinicalTrialBaseService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        String projectGUID = null;
        String clinicalTrialName = null;
        String hospitalGUID = null;
        String hospitalName = null;
        String certificationTypeGUID = null;
        String custodianGUID = null;
        super.start();
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.PROJECT.getName().equals(actionTargetElement.getActionTargetName())) {
                        projectGUID = actionTargetElement.getTargetElement().getElementGUID();
                        clinicalTrialName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL.getName().equals(actionTargetElement.getActionTargetName())) {
                        hospitalGUID = actionTargetElement.getTargetElement().getElementGUID();
                        hospitalName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        certificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.CUSTODIAN.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    custodianGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            ArrayList<String> outputGuards = new ArrayList<String>();
            AuditLogMessageDefinition messageDefinition = null;
            if (projectGUID == null || hospitalGUID == null || certificationTypeGUID == null || custodianGUID == null) {
                messageDefinition = projectGUID == null ? GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.PROJECT.getName()) : (hospitalGUID == null ? GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL.getName()) : (certificationTypeGUID == null ? GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName()) : GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.CUSTODIAN.getName())));
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                super.checkCertificationValidForProject(projectGUID, certificationTypeGUID);
                this.updateCertificationToHospital(projectGUID, clinicalTrialName, hospitalGUID, hospitalName, custodianGUID, certificationTypeGUID);
                completionStatus = CocoClinicalTrialGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.SET_UP_COMPLETE.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private void updateCertificationToHospital(String projectGUID, String clinicalTrialName, String hospitalGUID, String hospitalName, String custodianGUID, String certificationTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException, ConnectorCheckedException {
        String methodName = "updateCertificationToHospital";
        int startFrom = 0;
        OpenMetadataRelationshipList existingCertifications = this.governanceContext.getOpenMetadataStore().getMetadataElementRelationships(hospitalGUID, certificationTypeGUID, "Certification", startFrom, this.governanceContext.getMaxPageSize());
        if (existingCertifications == null) {
            CocoClinicalTrialBaseService.PersonContactDetails custodianContactDetails = super.getContactDetailsForPersonGUID(custodianGUID);
            if (custodianContactDetails != null) {
                String title = "Set up of onboarding pipeline for hospital " + hospitalName + "(" + hospitalGUID + ") failed because this hospital is not nominated for project " + clinicalTrialName + "(" + projectGUID + ")";
                String instructions = "Check with the clinical records clerk if you think this hospital should be included in the clinical trial.  Otherwise ignore this message.";
                this.governanceContext.openToDo(this.governanceServiceName + ":" + this.connectorInstanceId, title, instructions, "Clinical Trial Action", 1, null, custodianGUID, hospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL.getName());
            }
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.HOSPITAL_NOT_NOMINATED.getMessageDefinition(this.governanceServiceName, hospitalName, hospitalGUID, clinicalTrialName, projectGUID), ((Object)((Object)this)).getClass().getName(), "updateCertificationToHospital");
        }
        ElementProperties updatedProperties = this.propertyHelper.addDateProperty(null, "start", new Date());
        for (OpenMetadataRelationship certification : existingCertifications.getElementList()) {
            if (certification == null) continue;
            Date startDate = this.propertyHelper.getDateProperty(this.governanceServiceName, "start", certification.getRelationshipProperties(), "updateCertificationToHospital");
            Date endDate = this.propertyHelper.getDateProperty(this.governanceServiceName, "end", certification.getRelationshipProperties(), "updateCertificationToHospital");
            if (endDate != null || startDate != null) continue;
            this.governanceContext.getOpenMetadataStore().updateRelatedElementsInStore(certification.getRelationshipGUID(), false, updatedProperties);
        }
    }
}

