/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.odpi.openmetadata.adapters.connectors.governanceactions.provisioning.MoveCopyFileRequestParameter;
import org.odpi.openmetadata.adapters.connectors.integration.basicfiles.BasicFilesMonitoringConfigurationProperty;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.controls.ActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CatalogTargetProperties;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.NewActionTarget;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RelatedMetadataElementList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataType;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialBaseService;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialPlaceholderProperty;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialRequestParameter;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialHospitalOnboardingService
extends CocoClinicalTrialBaseService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        super.start();
        String clinicalTrialId = null;
        String clinicalTrialName = null;
        String projectGUID = null;
        String hospitalGUID = null;
        String hospitalName = null;
        String landingAreaDirectoryTemplateGUID = null;
        String landingAreaFileTemplateGUID = null;
        String landingAreaPathName = null;
        String dataLakePathName = null;
        String dataLakeFileTemplateGUID = null;
        String newFileProcessName = null;
        String integrationConnectorGUID = null;
        String onboardingProcessGUID = null;
        String stewardGUID = null;
        String hospitalCertificationTypeGUID = null;
        String dataQualityCertificationTypeGUID = null;
        ArrayList<String> outputGuards = new ArrayList<String>();
        AuditLogMessageDefinition messageDefinition = null;
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.PROJECT.getName().equals(actionTargetElement.getActionTargetName())) {
                        clinicalTrialId = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.IDENTIFIER.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        clinicalTrialName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        projectGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL.getName().equals(actionTargetElement.getActionTargetName())) {
                        hospitalName = this.propertyHelper.getStringProperty(actionTargetElement.getActionTargetName(), OpenMetadataProperty.NAME.name, actionTargetElement.getTargetElement().getElementProperties(), "start");
                        hospitalGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName().equals(actionTargetElement.getActionTargetName())) {
                        integrationConnectorGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.GENERIC_ONBOARDING_PIPELINE.getName().equals(actionTargetElement.getActionTargetName())) {
                        onboardingProcessGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.STEWARD.getName().equals(actionTargetElement.getActionTargetName())) {
                        stewardGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        hospitalCertificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    dataQualityCertificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                }
            }
            if (this.governanceContext.getRequestParameters() != null) {
                landingAreaDirectoryTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_TEMPLATE.getName());
                landingAreaPathName = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_PATH_NAME.getName());
                landingAreaFileTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.LANDING_AREA_FILE_TEMPLATE.getName());
                dataLakeFileTemplateGUID = (String)this.governanceContext.getRequestParameters().get(CocoClinicalTrialRequestParameter.DATA_LAKE_FILE_TEMPLATE.getName());
                dataLakePathName = (String)this.governanceContext.getRequestParameters().get(MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.getName());
                newFileProcessName = (String)this.governanceContext.getRequestParameters().get(BasicFilesMonitoringConfigurationProperty.NEW_FILE_PROCESS_NAME.getName());
            }
            if (clinicalTrialId == null || clinicalTrialName == null || hospitalName == null || clinicalTrialId.isBlank() || clinicalTrialName.isBlank() || hospitalName.isBlank() || landingAreaFileTemplateGUID == null || landingAreaFileTemplateGUID.isBlank() || landingAreaDirectoryTemplateGUID == null || landingAreaDirectoryTemplateGUID.isBlank() || landingAreaPathName == null || landingAreaPathName.isBlank() || dataLakePathName == null || dataLakePathName.isBlank() || dataLakeFileTemplateGUID == null || dataLakeFileTemplateGUID.isBlank() || onboardingProcessGUID == null || stewardGUID == null || integrationConnectorGUID == null || hospitalCertificationTypeGUID == null || dataQualityCertificationTypeGUID == null) {
                if (clinicalTrialId == null || clinicalTrialId.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getName());
                } else if (clinicalTrialName == null || clinicalTrialName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getName());
                } else if (hospitalName == null || hospitalName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getName());
                } else if (landingAreaFileTemplateGUID == null || landingAreaFileTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.LANDING_AREA_FILE_TEMPLATE.getName());
                } else if (landingAreaDirectoryTemplateGUID == null || landingAreaDirectoryTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_TEMPLATE.getName());
                } else if (landingAreaPathName == null || landingAreaPathName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.LANDING_AREA_DIRECTORY_PATH_NAME.getName());
                } else if (dataLakeFileTemplateGUID == null || dataLakeFileTemplateGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialRequestParameter.DATA_LAKE_FILE_TEMPLATE.getName());
                } else if (dataLakePathName == null || dataLakePathName.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, MoveCopyFileRequestParameter.DESTINATION_DIRECTORY.getName());
                } else if (onboardingProcessGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.GENERIC_ONBOARDING_PIPELINE.getName());
                } else if (stewardGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.STEWARD.getName());
                } else if (integrationConnectorGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.LANDING_AREA_CONNECTOR.getName());
                } else if (hospitalCertificationTypeGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName());
                } else if (dataQualityCertificationTypeGUID == null) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName());
                }
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                CocoClinicalTrialBaseService.PersonContactDetails hospitalContactDetails = this.checkHospitalCertification(projectGUID, clinicalTrialName, hospitalGUID, hospitalName, hospitalCertificationTypeGUID, stewardGUID);
                String landingAreaFolderGUID = this.catalogLandingAreaFolder(hospitalName, landingAreaPathName, landingAreaDirectoryTemplateGUID);
                String hospitalLandingAreaTemplateName = this.createTemplate(landingAreaFileTemplateGUID, hospitalName, clinicalTrialId, clinicalTrialName, hospitalContactDetails);
                String hospitalDataLakeTemplateName = this.createTemplate(dataLakeFileTemplateGUID, hospitalName, clinicalTrialId, clinicalTrialName, hospitalContactDetails);
                this.provisionLandingFolder(landingAreaPathName);
                newFileProcessName = this.createNewFileProcess(onboardingProcessGUID, clinicalTrialId, clinicalTrialName, hospitalName, stewardGUID, hospitalDataLakeTemplateName, dataQualityCertificationTypeGUID);
                this.startMonitoringLandingArea(landingAreaFolderGUID, integrationConnectorGUID, hospitalLandingAreaTemplateName, hospitalName, clinicalTrialId, clinicalTrialName, newFileProcessName);
                completionStatus = CocoClinicalTrialGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.SET_UP_COMPLETE.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private CocoClinicalTrialBaseService.PersonContactDetails checkHospitalCertification(String projectGUID, String clinicalTrialName, String hospitalGUID, String hospitalName, String certificationTypeGUID, String stewardGUID) throws ConnectorCheckedException, InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "checkHospitalCertification";
        CocoClinicalTrialBaseService.PersonContactDetails custodianContactDetails = null;
        int startFrom = 0;
        RelatedMetadataElementList certifications = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(hospitalGUID, 1, "Certification", startFrom, this.governanceContext.getOpenMetadataStore().getMaxPagingSize());
        while (certifications != null && certifications.getElementList() != null) {
            for (RelatedMetadataElement certification : certifications.getElementList()) {
                if (certification == null || certificationTypeGUID != null && !certificationTypeGUID.equals(certification.getElement().getElementGUID())) continue;
                Date startDate = this.propertyHelper.getDateProperty(this.governanceServiceName, "start", certification.getRelationshipProperties(), "checkHospitalCertification");
                Date endDate = this.propertyHelper.getDateProperty(this.governanceServiceName, "end", certification.getRelationshipProperties(), "checkHospitalCertification");
                String hospitalContactGUID = this.propertyHelper.getStringProperty(this.governanceServiceName, "recipient", certification.getRelationshipProperties(), "checkHospitalCertification");
                String custodianGUID = this.propertyHelper.getStringProperty(this.governanceServiceName, "custodian", certification.getRelationshipProperties(), "checkHospitalCertification");
                CocoClinicalTrialBaseService.PersonContactDetails hospitalContactDetails = super.getContactDetailsForPersonGUID(hospitalContactGUID);
                if (custodianGUID != null) {
                    custodianContactDetails = super.getContactDetailsForPersonGUID(custodianGUID);
                }
                if (startDate == null || endDate != null) continue;
                int projectStartFrom = 0;
                RelatedMetadataElementList projects = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(certification.getElement().getElementGUID(), 1, "GovernedBy", projectStartFrom, this.governanceContext.getMaxPageSize());
                while (projects != null && projects.getElementList() != null) {
                    for (RelatedMetadataElement project : projects.getElementList()) {
                        if (project == null || !projectGUID.equals(project.getElement().getElementGUID())) continue;
                        this.auditLog.logMessage("checkHospitalCertification", GovernanceActionSamplesAuditCode.CERTIFIED_HOSPITAL.getMessageDefinition(this.governanceServiceName, hospitalName, hospitalGUID, clinicalTrialName, projectGUID));
                        return hospitalContactDetails;
                    }
                    projects = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(certification.getElement().getElementGUID(), 2, "GovernedBy", projectStartFrom += this.governanceContext.getMaxPageSize(), this.governanceContext.getMaxPageSize());
                }
            }
            certifications = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElements(hospitalGUID, 1, "CertificationType", startFrom += this.governanceContext.getMaxPageSize(), this.governanceContext.getOpenMetadataStore().getMaxPagingSize());
        }
        CocoClinicalTrialBaseService.PersonContactDetails stewardContactDetails = super.getContactDetailsForPersonGUID(stewardGUID);
        if (stewardContactDetails != null) {
            if (custodianContactDetails != null) {
                title = "Set up of onboarding pipeline for hospital " + hospitalName + "(" + hospitalGUID + ") failed because this hospital is not certified for project " + clinicalTrialName + "(" + projectGUID + ")";
                instructions = "Contact the clinical records clerk for this project to resolve the certification status of the hospital.  Once it is resolved, rerun this onboarding process.";
                instructions = (String)instructions + "\n\n Contact Details:\n\n * Name: " + custodianContactDetails.contactName + "\n * Email: " + custodianContactDetails.contactEmail + "\n * GUID: " + custodianContactDetails.personGUID;
                this.governanceContext.openToDo("From " + this.governanceServiceName + ":" + this.connectorInstanceId + " to " + stewardGUID, title, (String)instructions, "Clinical Trial Action", 1, null, stewardGUID, hospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL.getName());
                instructions = "Determine whether this hospital is to be included in the clinical trial.  If it is to be included, review the certification status and contact the hospital to complete the certification process.  Contact the steward to keep them informed of the hospital's status";
                instructions = (String)instructions + "\n\n Contact Details for Steward:\n\n * Name: " + stewardContactDetails.contactName + "\n * Email: " + stewardContactDetails.contactEmail + "\n * GUID: " + stewardContactDetails.personGUID;
                this.governanceContext.openToDo("From " + this.governanceServiceName + ":" + this.connectorInstanceId + " to " + custodianContactDetails.personGUID, title, (String)instructions, "Clinical Trial Action", 1, null, custodianContactDetails.personGUID, hospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL.getName());
            } else {
                title = "Set up of onboarding pipeline for hospital " + hospitalName + "(" + hospitalGUID + ") failed because this hospital is not nominated for project " + clinicalTrialName + "(" + projectGUID + ")";
                instructions = "Check with the clinical records clerk if you think this hospital should be included in the clinical trial.  Otherwise ignore this message.";
                this.governanceContext.openToDo("From " + this.governanceServiceName + ":" + this.connectorInstanceId + " to " + stewardGUID, title, (String)instructions, "Clinical Trial Action", 1, null, stewardGUID, hospitalGUID, CocoClinicalTrialActionTarget.HOSPITAL.getName());
            }
        }
        throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNCERTIFIED_HOSPITAL.getMessageDefinition(this.governanceServiceName, hospitalName, hospitalGUID, clinicalTrialName, projectGUID), ((Object)((Object)this)).getClass().getName(), "checkHospitalCertification");
    }

    private String catalogLandingAreaFolder(String hospitalName, String landingAreaPathName, String landingAreaDirectoryTemplateGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        HashMap<String, Object> placeholderPropertyValues = new HashMap<String, Object>();
        placeholderPropertyValues.put(PlaceholderProperty.DIRECTORY_PATH_NAME.getName(), landingAreaPathName);
        placeholderPropertyValues.put(PlaceholderProperty.DIRECTORY_NAME.getName(), "drop-foot");
        placeholderPropertyValues.put(PlaceholderProperty.VERSION_IDENTIFIER.getName(), "V1.0");
        placeholderPropertyValues.put(PlaceholderProperty.FILE_SYSTEM_NAME.getName(), "");
        placeholderPropertyValues.put(PlaceholderProperty.DESCRIPTION.getName(), "Landing Area folder for" + hospitalName + "'s Teddy Bear Drop Foot clinical trial.");
        return this.governanceContext.getOpenMetadataStore().createMetadataElementFromTemplate(OpenMetadataType.FILE_FOLDER.typeName, null, true, null, null, landingAreaDirectoryTemplateGUID, null, placeholderPropertyValues, null, null, null, true);
    }

    private String createTemplate(String rawTemplateGUID, String hospitalName, String clinicalTrialId, String clinicalTrialName, CocoClinicalTrialBaseService.PersonContactDetails hospitalContactDetails) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createTemplate";
        HashMap<String, String> placeholderProperties = new HashMap<String, String>();
        placeholderProperties.put(CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_ID.getName(), clinicalTrialId);
        placeholderProperties.put(CocoClinicalTrialPlaceholderProperty.CLINICAL_TRIAL_NAME.getName(), clinicalTrialName);
        placeholderProperties.put(CocoClinicalTrialPlaceholderProperty.HOSPITAL_NAME.getName(), hospitalName);
        placeholderProperties.put(CocoClinicalTrialPlaceholderProperty.CONTACT_NAME.getName(), hospitalContactDetails.contactName);
        placeholderProperties.put(CocoClinicalTrialPlaceholderProperty.CONTACT_EMAIL.getName(), hospitalContactDetails.contactEmail);
        String templateGUID = this.governanceContext.getOpenMetadataStore().createMetadataElementFromTemplate(OpenMetadataType.CSV_FILE.typeName, null, true, null, null, rawTemplateGUID, null, placeholderProperties, null, null, null, true);
        OpenMetadataElement templateElement = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(templateGUID);
        return this.propertyHelper.getStringProperty(templateGUID, OpenMetadataProperty.QUALIFIED_NAME.name, templateElement.getElementProperties(), "createTemplate");
    }

    private String createNewFileProcess(String onboardingProcessGUID, String clinicalTrialId, String clinicalTrialName, String hospitalName, String stewardGUID, String dataLakeTemplateName, String dataQualityCertificationType) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String methodName = "createNewFileProcess";
        String processQualifiedName = "Coco:GovernanceActionProcess:" + clinicalTrialId + ":" + hospitalName + ":WeeklyMeasurements:Onboarding";
        OpenMetadataElement genericProcess = this.governanceContext.getOpenMetadataStore().getMetadataElementByGUID(onboardingProcessGUID);
        if (genericProcess != null) {
            String processGUID = super.createGovernanceActionProcess(processQualifiedName, "Onboard Landing Area Files for " + clinicalTrialName, null);
            RelatedMetadataElement firstProcessStep = this.governanceContext.getOpenMetadataStore().getRelatedMetadataElement(onboardingProcessGUID, 1, "GovernanceActionProcessFlow", new Date());
            if (firstProcessStep != null) {
                ElementProperties relationshipProperties = new ElementProperties(firstProcessStep.getRelationshipProperties());
                HashMap<String, CallSite> requestParameters = this.propertyHelper.getStringMapFromProperty(this.governanceServiceName, OpenMetadataProperty.REQUEST_PARAMETERS.name, relationshipProperties, "createNewFileProcess");
                if (requestParameters == null) {
                    requestParameters = new HashMap<String, CallSite>();
                }
                requestParameters.put(MoveCopyFileRequestParameter.TARGET_FILE_NAME_PATTERN.getName(), (CallSite)((Object)(clinicalTrialId + "_{1, number,000000}.csv")));
                requestParameters.put("publishZones", (CallSite)((Object)"data-lake,clinical-trials"));
                requestParameters.put(MoveCopyFileRequestParameter.DESTINATION_TEMPLATE_NAME.getName(), (CallSite)((Object)dataLakeTemplateName));
                relationshipProperties = this.propertyHelper.addStringMapProperty(relationshipProperties, OpenMetadataProperty.REQUEST_PARAMETERS.name, requestParameters);
                this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore("GovernanceActionProcessFlow", processGUID, firstProcessStep.getElement().getElementGUID(), null, null, relationshipProperties);
                ElementProperties actionTargetProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, ActionTarget.STEWARD.getName());
                this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.TARGET_FOR_ACTION_PROCESS.typeName, processGUID, stewardGUID, null, null, actionTargetProperties);
                actionTargetProperties = this.propertyHelper.addStringProperty(null, OpenMetadataProperty.ACTION_TARGET_NAME.name, CocoClinicalTrialActionTarget.DATA_QUALITY_CERTIFICATION_TYPE.getName());
                this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore(OpenMetadataType.TARGET_FOR_ACTION_PROCESS.typeName, processGUID, dataQualityCertificationType, null, null, actionTargetProperties);
            }
        }
        return processQualifiedName;
    }

    private void startMonitoringLandingArea(String folderGUID, String integrationConnectorGUID, String templateName, String hospitalName, String clinicalTrialId, String clinicalTrialName, String newFileProcessName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        CatalogTargetProperties catalogTargetProperties = new CatalogTargetProperties();
        catalogTargetProperties.setCatalogTargetName(clinicalTrialId + ":" + clinicalTrialName + ":" + hospitalName);
        HashMap<String, String> templateProperties = new HashMap<String, String>();
        templateProperties.put(OpenMetadataType.DATA_FILE.typeName, templateName);
        templateProperties.put(OpenMetadataType.CSV_FILE.typeName, templateName);
        catalogTargetProperties.setTemplateProperties(templateProperties);
        HashMap<String, String> configurationProperties = new HashMap<String, String>();
        configurationProperties.put(BasicFilesMonitoringConfigurationProperty.NEW_FILE_PROCESS_NAME.getName(), newFileProcessName);
        if (this.governanceContext.getRequestParameters() != null) {
            for (String requestParameter : this.governanceContext.getRequestParameters().keySet()) {
                configurationProperties.put(requestParameter, (String)this.governanceContext.getRequestParameters().get(requestParameter));
            }
        }
        catalogTargetProperties.setConfigurationProperties(configurationProperties);
        this.governanceContext.addCatalogTarget(integrationConnectorGUID, folderGUID, catalogTargetProperties);
    }

    private void provisionLandingFolder(String pathName) {
        String methodName = "provisionLandingFolder";
        File landingFolder = new File(pathName);
        if (!landingFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)landingFolder);
            }
            catch (IOException error) {
                this.auditLog.logMessage("provisionLandingFolder", GovernanceActionSamplesAuditCode.NO_LANDING_FOLDER.getMessageDefinition(this.governanceServiceName, pathName));
            }
        }
    }

    private void initiateWatchdog(String landingAreaFolderGUID, String dataLakeTemplateName, String newElementProcessName) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        String actionTargetName = "watchedFolder";
        String governanceActionTypeName = "AssetOnboarding:watch-for-new-files-in-folder";
        String governanceEngineName = "ClinicalTrials@CocoPharmaceuticals";
        HashMap<String, String> requestParameters = this.governanceContext.getRequestParameters();
        if (requestParameters == null) {
            requestParameters = new HashMap<String, String>();
        }
        requestParameters.put("interestingTypeName", OpenMetadataType.CSV_FILE.typeName);
        requestParameters.put("actionTargetName", "sourceFile");
        requestParameters.put("newElementProcessName", newElementProcessName);
        requestParameters.put("targetFileNamePattern", "DropFoot_{1, number,000000}.csv");
        requestParameters.put("publishZones", "data-lake,clinical-trials");
        requestParameters.put(MoveCopyFileRequestParameter.DESTINATION_TEMPLATE_NAME.getName(), dataLakeTemplateName);
        NewActionTarget newActionTarget = new NewActionTarget();
        newActionTarget.setActionTargetName("watchedFolder");
        newActionTarget.setActionTargetGUID(landingAreaFolderGUID);
        ArrayList<NewActionTarget> actionTargets = new ArrayList<NewActionTarget>();
        actionTargets.add(newActionTarget);
        this.governanceContext.initiateGovernanceActionType("AssetOnboarding:watch-for-new-files-in-folder", null, actionTargets, null, requestParameters, this.governanceServiceName, "ClinicalTrials@CocoPharmaceuticals");
    }
}

