/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.connectors.ffdc.ConnectorCheckedException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.OCFCheckedExceptionBase;
import org.odpi.openmetadata.frameworks.connectors.ffdc.PropertyServerException;
import org.odpi.openmetadata.frameworks.connectors.ffdc.UserNotAuthorizedException;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationship;
import org.odpi.openmetadata.frameworks.governanceaction.properties.OpenMetadataRelationshipList;
import org.odpi.openmetadata.frameworks.governanceaction.search.ElementProperties;
import org.odpi.openmetadata.frameworks.openmetadata.types.OpenMetadataProperty;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialActionTarget;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialBaseService;
import org.odpi.openmetadata.samples.governanceactions.clinicaltrials.CocoClinicalTrialGuard;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesAuditCode;
import org.odpi.openmetadata.samples.governanceactions.ffdc.GovernanceActionSamplesErrorCode;

public class CocoClinicalTrialNominateHospitalService
extends CocoClinicalTrialBaseService {
    public void start() throws ConnectorCheckedException {
        String methodName = "start";
        String projectGUID = null;
        String hospitalGUID = null;
        String certificationTypeGUID = null;
        String processOwnerGUID = null;
        String processOwnerTypeName = null;
        String custodianGUID = null;
        String custodianTypeName = null;
        String hospitalContactGUID = null;
        String hospitalContactTypeName = null;
        super.start();
        try {
            CompletionStatus completionStatus;
            if (this.governanceContext.getActionTargetElements() != null) {
                for (ActionTargetElement actionTargetElement : this.governanceContext.getActionTargetElements()) {
                    if (actionTargetElement == null) continue;
                    if (CocoClinicalTrialActionTarget.PROJECT.getName().equals(actionTargetElement.getActionTargetName())) {
                        projectGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL.getName().equals(actionTargetElement.getActionTargetName())) {
                        hospitalGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName().equals(actionTargetElement.getActionTargetName())) {
                        certificationTypeGUID = actionTargetElement.getTargetElement().getElementGUID();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.CUSTODIAN.getName().equals(actionTargetElement.getActionTargetName())) {
                        custodianGUID = actionTargetElement.getTargetElement().getElementGUID();
                        custodianTypeName = actionTargetElement.getTargetElement().getType().getTypeName();
                        continue;
                    }
                    if (CocoClinicalTrialActionTarget.PROCESS_OWNER.getName().equals(actionTargetElement.getActionTargetName())) {
                        processOwnerGUID = actionTargetElement.getTargetElement().getElementGUID();
                        processOwnerTypeName = actionTargetElement.getTargetElement().getType().getTypeName();
                        continue;
                    }
                    if (!CocoClinicalTrialActionTarget.CONTACT_PERSON.getName().equals(actionTargetElement.getActionTargetName())) continue;
                    hospitalContactGUID = actionTargetElement.getTargetElement().getElementGUID();
                    hospitalContactTypeName = actionTargetElement.getTargetElement().getType().getTypeName();
                }
            }
            ArrayList<String> outputGuards = new ArrayList<String>();
            AuditLogMessageDefinition messageDefinition = null;
            if (projectGUID == null || hospitalGUID == null || certificationTypeGUID == null || hospitalContactGUID == null || custodianGUID == null || processOwnerGUID == null) {
                if (projectGUID == null || projectGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.PROJECT.getName());
                }
                if (hospitalGUID == null || hospitalGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL.getName());
                }
                if (certificationTypeGUID == null || certificationTypeGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.HOSPITAL_CERTIFICATION_TYPE.getName());
                }
                if (custodianGUID == null || custodianGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.CUSTODIAN.getName());
                }
                if (processOwnerGUID == null || processOwnerGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.PROCESS_OWNER.getName());
                }
                if (hospitalContactGUID == null || hospitalContactGUID.isBlank()) {
                    messageDefinition = GovernanceActionSamplesAuditCode.MISSING_VALUE.getMessageDefinition(this.governanceServiceName, CocoClinicalTrialActionTarget.CONTACT_PERSON.getName());
                }
                completionStatus = CocoClinicalTrialGuard.MISSING_INFO.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.MISSING_INFO.getName());
            } else {
                this.checkCertificationValidForProject(projectGUID, certificationTypeGUID);
                this.addNewCertificationToHospital(hospitalGUID, processOwnerGUID, processOwnerTypeName, custodianGUID, custodianTypeName, hospitalContactGUID, hospitalContactTypeName, certificationTypeGUID);
                completionStatus = CocoClinicalTrialGuard.SET_UP_COMPLETE.getCompletionStatus();
                outputGuards.add(CocoClinicalTrialGuard.SET_UP_COMPLETE.getName());
            }
            if (messageDefinition != null) {
                this.auditLog.logMessage("start", messageDefinition);
            }
            this.governanceContext.recordCompletionStatus(completionStatus, outputGuards, null, null, messageDefinition);
        }
        catch (ConnectorCheckedException error) {
            throw error;
        }
        catch (OCFCheckedExceptionBase error) {
            throw new ConnectorCheckedException(error.getReportedErrorMessage(), error);
        }
        catch (Exception error) {
            throw new ConnectorCheckedException(GovernanceActionSamplesErrorCode.UNEXPECTED_EXCEPTION.getMessageDefinition(this.governanceServiceName, error.getClass().getName(), error.getMessage()), error.getClass().getName(), "start", (Throwable)error);
        }
    }

    private void addNewCertificationToHospital(String hospitalGUID, String processOwnerGUID, String processOwnerTypeName, String custodianGUID, String custodianTypeName, String hospitalContactGUID, String hospitalContactTypeName, String certificationTypeGUID) throws InvalidParameterException, PropertyServerException, UserNotAuthorizedException {
        int startFrom = 0;
        OpenMetadataRelationshipList existingCertifications = this.governanceContext.getOpenMetadataStore().getMetadataElementRelationships(hospitalGUID, certificationTypeGUID, "Certification", startFrom, this.governanceContext.getMaxPageSize());
        while (existingCertifications != null) {
            ElementProperties updatedProperties = this.propertyHelper.addDateProperty(null, "end", new Date());
            for (OpenMetadataRelationship certification : existingCertifications.getElementList()) {
                if (certification == null) continue;
                this.governanceContext.getOpenMetadataStore().updateRelatedElementsInStore(certification.getRelationshipGUID(), false, updatedProperties);
            }
            existingCertifications = this.governanceContext.getOpenMetadataStore().getMetadataElementRelationships(hospitalGUID, certificationTypeGUID, "Certification", startFrom += this.governanceContext.getMaxPageSize(), this.governanceContext.getMaxPageSize());
        }
        ElementProperties elementProperties = this.propertyHelper.addDateProperty(null, "start", null);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "certificateGUID", UUID.randomUUID().toString());
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "certifiedBy", processOwnerGUID);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "certifiedByTypeName", processOwnerTypeName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "certifiedByPropertyName", OpenMetadataProperty.GUID.name);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "custodian", custodianGUID);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "custodianTypeName", custodianTypeName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "custodianPropertyName", OpenMetadataProperty.GUID.name);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "recipient", hospitalContactGUID);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "recipientTypeName", hospitalContactTypeName);
        elementProperties = this.propertyHelper.addStringProperty(elementProperties, "recipientPropertyName", OpenMetadataProperty.GUID.name);
        this.governanceContext.getOpenMetadataStore().createRelatedElementsInStore("Certification", hospitalGUID, certificationTypeGUID, null, null, elementProperties);
    }
}

