/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderProperty;
import org.odpi.openmetadata.frameworks.openmetadata.controls.PlaceholderPropertyType;

public enum CocoClinicalTrialPlaceholderProperty {
    CLINICAL_TRIAL_ID("clinicalTrialId", "Add the identifier of the clinical trial.", "string", "PROJ-CT-TBDF"),
    CLINICAL_TRIAL_NAME("clinicalTrialName", "Add the display name of the clinical trial.", "string", "Teddy Bear Drop Foot"),
    HOSPITAL_NAME("hospitalName", "Add the name of the hospital that sent the measurements.", "string", "Oak Dene Hospital"),
    CONTACT_NAME("contactName", "Add the name of the person at the hospital who is responsible for supplying the measurements.", "string", "Robbie Records"),
    CONTACT_EMAIL("contactEmail", "Add the email used to contact the person from the hospital.", "string", "RobbieRec@oak-dene.org");

    public final String name;
    public final String description;
    public final String dataType;
    public final String example;

    private CocoClinicalTrialPlaceholderProperty(String name, String description, String dataType, String example) {
        this.name = name;
        this.description = description;
        this.dataType = dataType;
        this.example = example;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return "{{" + this.name + "}}";
    }

    public String getDescription() {
        return this.description;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getExample() {
        return this.example;
    }

    public static List<PlaceholderPropertyType> getPlaceholderPropertyTypes() {
        ArrayList<PlaceholderPropertyType> placeholderPropertyTypes = new ArrayList<PlaceholderPropertyType>();
        for (CocoClinicalTrialPlaceholderProperty placeholderProperty : CocoClinicalTrialPlaceholderProperty.values()) {
            placeholderPropertyTypes.add(placeholderProperty.getPlaceholderType());
        }
        placeholderPropertyTypes.add(PlaceholderProperty.FILE_PATH_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.FILE_NAME.getPlaceholderType());
        placeholderPropertyTypes.add(PlaceholderProperty.RECEIVED_DATE.getPlaceholderType());
        return placeholderPropertyTypes;
    }

    public PlaceholderPropertyType getPlaceholderType() {
        PlaceholderPropertyType placeholderPropertyType = new PlaceholderPropertyType();
        placeholderPropertyType.setName(this.name);
        placeholderPropertyType.setDescription(this.description);
        placeholderPropertyType.setDataType(this.dataType);
        placeholderPropertyType.setExample(this.example);
        placeholderPropertyType.setRequired(true);
        return placeholderPropertyType;
    }

    public String toString() {
        return "CocoClinicalTrialPlaceholderProperty{ name=" + this.name + "}";
    }
}

