/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.clinicaltrials;

import java.util.ArrayList;
import java.util.List;
import org.odpi.openmetadata.frameworks.openmetadata.types.DataType;
import org.odpi.openmetadata.frameworks.surveyaction.measurements.SurveyMetric;

public enum CocoClinicalTrialQualityDimension implements SurveyMetric
{
    NO_OF_COLUMNS_MATCH("matchingColumnCount", DataType.STRING.getName(), "Matching Column Count", "Do the number of columns described in the schema match the number of columns in the resource?  Zero means a perfect match.  A negative value means the resource has less columns and a positive value means that the resource has more columns."),
    NAMES_OF_COLUMNS_MATCH("matchingColumnNames", DataType.STRING.getName(), "Matching Column Names", "Do the column names in the schema match those in the resource.  The order is important. Zero means a perfect match.  A negative value means there are mismatched columns."),
    VALID_PATIENT_ID("patientIdInRange", DataType.STRING.getName(), "Patient Identifier In Range", "Is the patient identifier valid?  Zero means it is in range.  A negative value indicates the number of rows where it is out of range."),
    VALID_DATE("dateInRange", DataType.STRING.getName(), "Date In Range", "Is the date of the measurement in date for the clinical trial?  Zero means it is in range.  A negative value indicates the number of rows where it is out of range."),
    VALID_LEFT_ANGLE("leftFootAngleInRange", DataType.STRING.getName(), "Left FootAngle In Range", "Is the measured angle between -90 degrees and +90 degrees?  Zero means it is in range.  A negative value indicates the number of rows where it is out of range."),
    VALID_RIGHT_ANGLE("rightFootAngleInRange", DataType.STRING.getName(), "Right Foot Angle In Range", "Is the measured angle between -90 degrees and +90 degrees?  Zero means it is in range.  A negative value indicates the number of rows where it is out of range.");

    public final String propertyName;
    public final String dataType;
    public final String displayName;
    public final String description;

    private CocoClinicalTrialQualityDimension(String propertyName, String dataType, String displayName, String description) {
        this.propertyName = propertyName;
        this.dataType = dataType;
        this.displayName = displayName;
        this.description = description;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static List<SurveyMetric> getQualityDimensions() {
        return new ArrayList<SurveyMetric>(List.of(CocoClinicalTrialQualityDimension.values()));
    }

    public static List<SurveyMetric> getSchemaValidationQualityDimensions() {
        ArrayList<SurveyMetric> surveyMetrics = new ArrayList<SurveyMetric>();
        surveyMetrics.add(NO_OF_COLUMNS_MATCH);
        surveyMetrics.add(NAMES_OF_COLUMNS_MATCH);
        return surveyMetrics;
    }

    public static List<SurveyMetric> getPatientIdValidationQualityDimensions() {
        ArrayList<SurveyMetric> surveyMetrics = new ArrayList<SurveyMetric>();
        surveyMetrics.add(VALID_PATIENT_ID);
        return surveyMetrics;
    }

    public static List<SurveyMetric> getDateValidationQualityDimensions() {
        ArrayList<SurveyMetric> surveyMetrics = new ArrayList<SurveyMetric>();
        surveyMetrics.add(VALID_DATE);
        return surveyMetrics;
    }

    public static List<SurveyMetric> getAngleValidationQualityDimensions() {
        ArrayList<SurveyMetric> surveyMetrics = new ArrayList<SurveyMetric>();
        surveyMetrics.add(VALID_LEFT_ANGLE);
        surveyMetrics.add(VALID_RIGHT_ANGLE);
        return surveyMetrics;
    }

    public String toString() {
        return "CocoClinicalTrialQualityDimension{" + this.displayName + "}";
    }
}

