/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.samples.governanceactions.ffdc;

import org.odpi.openmetadata.frameworks.auditlog.AuditLogRecordSeverityLevel;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageDefinition;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogMessageSet;
import org.odpi.openmetadata.frameworks.auditlog.messagesets.AuditLogRecordSeverity;

public enum GovernanceActionSamplesAuditCode implements AuditLogMessageSet
{
    CERTIFIED_HOSPITAL("GOVERNANCE-ACTION-SAMPLES-0001", AuditLogRecordSeverityLevel.DECISION, "The {0} governance action service has verified that hospital {1} ({2}) is certified to supply data for project {3} ({4})", "The service sets up the onboarding pipeline for this hospital.", "No specific action is required.  This message is to log that a verification check has taken place."),
    MISSING_VALUE("GOVERNANCE-ACTION-SAMPLES-0002", AuditLogRecordSeverityLevel.ERROR, "The {0} governance action service was passed a null value for {1}", "The governance action service returns an INVALID completion status.", "This is an error in the way that the governance action service has been called, which could be a direct invocation through the initiateEngineAction() method, initiateGovernanceActionType() methodor as part of a governance action process.  Identify which approach was used and add the required information as an action target to the invocation code.  Then rerun the request."),
    MISSING_CATALOG("GOVERNANCE-ACTION-SAMPLES-0003", AuditLogRecordSeverityLevel.INFO, "The {0} governance action service has not been passed a Unity Catalog (UC) catalog for the data lake", "The governance action service is not able to set up the data lake for the clinical trial.", "Retry the request, but ensure that the action target for the catalog is supplied."),
    NO_LANDING_FOLDER("GOVERNANCE-ACTION-SAMPLES-0004", AuditLogRecordSeverityLevel.INFO, "The {0} governance action service was unable to create the landing area directory {1}", "The governance action service is not able to set up the landing area directory for the clinical trial.", "Add the landing area directory manually."),
    NO_VOLUME_DIRECTORY("GOVERNANCE-ACTION-SAMPLES-0005", AuditLogRecordSeverityLevel.INFO, "The {0} governance action service was unable to create the volume directory {1} for Unity Catalog Volume {2}", "The governance action service is not able to set up the directory for a Unity Catalog Volume.", "Add the volume's directory manually.");

    private final String logMessageId;
    private final AuditLogRecordSeverityLevel severity;
    private final String logMessage;
    private final String systemAction;
    private final String userAction;

    private GovernanceActionSamplesAuditCode(String messageId, AuditLogRecordSeverityLevel severity, String message, String systemAction, String userAction) {
        this.logMessageId = messageId;
        this.severity = severity;
        this.logMessage = message;
        this.systemAction = systemAction;
        this.userAction = userAction;
    }

    public AuditLogMessageDefinition getMessageDefinition() {
        return new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
    }

    public AuditLogMessageDefinition getMessageDefinition(String ... params) {
        AuditLogMessageDefinition messageDefinition = new AuditLogMessageDefinition(this.logMessageId, (AuditLogRecordSeverity)this.severity, this.logMessage, this.systemAction, this.userAction);
        messageDefinition.setMessageParameters(params);
        return messageDefinition;
    }

    public String toString() {
        return "GovernanceActionSamplesAuditCode{logMessageId='" + this.logMessageId + "', severity=" + this.severity + ", logMessage='" + this.logMessage + "', systemAction='" + this.systemAction + "', userAction='" + this.userAction + "'}";
    }
}

