/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.handlers;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.odpi.openmetadata.accessservices.governanceengine.client.GovernanceEngineClient;
import org.odpi.openmetadata.accessservices.governanceengine.properties.GovernanceEngineProperties;
import org.odpi.openmetadata.engineservices.governanceaction.context.GovernanceListenerManager;
import org.odpi.openmetadata.engineservices.governanceaction.context.OpenMetadataStoreClient;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionAuditCode;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.Connector;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.OpenMetadataClient;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.ProvisioningGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.RemediationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.TriageGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.VerificationGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceActionService;
import org.odpi.openmetadata.frameworks.governanceaction.WatchdogGovernanceContext;
import org.odpi.openmetadata.frameworks.governanceaction.properties.ActionTargetElement;
import org.odpi.openmetadata.frameworks.governanceaction.properties.CompletionStatus;
import org.odpi.openmetadata.frameworks.governanceaction.properties.RequestSourceElement;
import org.odpi.openmetadata.governanceservers.enginehostservices.admin.GovernanceServiceHandler;

public class GovernanceActionServiceHandler
extends GovernanceServiceHandler {
    private GovernanceActionService governanceActionService;
    private String governanceActionServiceType;
    private GovernanceContext governanceContext;

    GovernanceActionServiceHandler(GovernanceEngineProperties governanceActionEngineProperties, String governanceActionEngineGUID, String governanceActionUserId, String governanceActionGUID, GovernanceEngineClient governanceActionClient, String requestType, Map<String, String> requestParameters, List<RequestSourceElement> requestSourceElements, List<ActionTargetElement> actionTargetElements, String governanceActionServiceGUID, String governanceActionServiceName, Connector governanceActionServiceConnector, String partnerServerName, String partnerServerPlatformURLRoot, GovernanceEngineClient governanceEngineClient, GovernanceListenerManager governanceListenerManager, AuditLog auditLog) throws InvalidParameterException {
        block9: {
            super(governanceActionEngineProperties, governanceActionEngineGUID, governanceActionUserId, governanceActionGUID, governanceActionClient, requestType, governanceActionServiceGUID, governanceActionServiceName, governanceActionServiceConnector, auditLog);
            String actionDescription = "Initializing GovernanceActionService";
            String governanceActionServiceConnectorParameterName = "governanceActionServiceConnector";
            String watchdogGovernanceActionServiceType = "WatchdogGovernanceActionService";
            String provisioningGovernanceActionServiceType = "ProvisioningGovernanceActionService";
            String verificationGovernanceActionServiceType = "VerificationGovernanceActionService";
            String triageGovernanceActionServiceType = "TriageGovernanceActionService";
            String remediationGovernanceActionServiceType = "RemediationGovernanceActionService";
            try {
                OpenMetadataStoreClient openMetadataClient = new OpenMetadataStoreClient(partnerServerName, partnerServerPlatformURLRoot, governanceEngineClient, governanceListenerManager, this, governanceActionUserId);
                if (governanceActionServiceConnector instanceof WatchdogGovernanceActionService) {
                    WatchdogGovernanceContext context = new WatchdogGovernanceContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
                    WatchdogGovernanceActionService service = (WatchdogGovernanceActionService)governanceActionServiceConnector;
                    service.setGovernanceContext(context);
                    service.setAuditLog(auditLog);
                    this.governanceContext = context;
                    this.governanceActionService = service;
                    this.governanceActionServiceType = "WatchdogGovernanceActionService";
                    break block9;
                }
                if (governanceActionServiceConnector instanceof VerificationGovernanceActionService) {
                    VerificationGovernanceContext context = new VerificationGovernanceContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
                    VerificationGovernanceActionService service = (VerificationGovernanceActionService)governanceActionServiceConnector;
                    service.setGovernanceContext(context);
                    service.setAuditLog(auditLog);
                    this.governanceContext = context;
                    this.governanceActionService = service;
                    this.governanceActionServiceType = "VerificationGovernanceActionService";
                    break block9;
                }
                if (governanceActionServiceConnector instanceof TriageGovernanceActionService) {
                    TriageGovernanceContext context = new TriageGovernanceContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
                    TriageGovernanceActionService service = (TriageGovernanceActionService)governanceActionServiceConnector;
                    service.setGovernanceContext(context);
                    service.setAuditLog(auditLog);
                    this.governanceContext = context;
                    this.governanceActionService = service;
                    this.governanceActionServiceType = "TriageGovernanceActionService";
                    break block9;
                }
                if (governanceActionServiceConnector instanceof RemediationGovernanceActionService) {
                    RemediationGovernanceContext context = new RemediationGovernanceContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
                    RemediationGovernanceActionService service = (RemediationGovernanceActionService)governanceActionServiceConnector;
                    service.setGovernanceContext(context);
                    service.setAuditLog(auditLog);
                    this.governanceContext = context;
                    this.governanceActionService = service;
                    this.governanceActionServiceType = "RemediationGovernanceActionService";
                    break block9;
                }
                if (governanceActionServiceConnector instanceof ProvisioningGovernanceActionService) {
                    ProvisioningGovernanceContext context = new ProvisioningGovernanceContext(governanceActionUserId, governanceActionGUID, requestType, requestParameters, requestSourceElements, actionTargetElements, (OpenMetadataClient)openMetadataClient);
                    ProvisioningGovernanceActionService service = (ProvisioningGovernanceActionService)governanceActionServiceConnector;
                    service.setGovernanceContext(context);
                    service.setAuditLog(auditLog);
                    this.governanceContext = context;
                    this.governanceActionService = service;
                    this.governanceActionServiceType = "ProvisioningGovernanceActionService";
                    break block9;
                }
                if (governanceActionServiceConnector instanceof GovernanceActionService) {
                    auditLog.logMessage("Initializing GovernanceActionService", GovernanceActionAuditCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}));
                    throw new InvalidParameterException(GovernanceActionErrorCode.UNKNOWN_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", "governanceActionServiceConnector");
                }
                auditLog.logMessage("Initializing GovernanceActionService", GovernanceActionAuditCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}));
                throw new InvalidParameterException(GovernanceActionErrorCode.NOT_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, governanceActionServiceConnector.getClass().getName()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", "governanceActionServiceConnector");
            }
            catch (InvalidParameterException error) {
                throw error;
            }
            catch (Exception error) {
                auditLog.logException("Initializing GovernanceActionService", GovernanceActionAuditCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, error.getClass().getName(), error.getMessage()}), (Throwable)error);
                throw new InvalidParameterException(GovernanceActionErrorCode.INVALID_GOVERNANCE_ACTION_SERVICE.getMessageDefinition(new String[]{governanceActionServiceName, requestType, error.getClass().getName(), error.getMessage()}), ((Object)((Object)this)).getClass().getName(), "Initializing GovernanceActionService", (Throwable)error, "governanceActionServiceConnector");
            }
        }
    }

    public void run() {
        String actionDescription = "Run governance service";
        try {
            this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_STARTING.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType, this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID}));
            Date startTime = new Date();
            this.governanceActionService.start();
            Date endTime = new Date();
            CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
            if (completionStatus == null) {
                this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_RETURNED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType, Long.toString(endTime.getTime() - startTime.getTime())}));
            } else {
                this.auditLog.logMessage("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_COMPLETE.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, this.requestType, Long.toString(endTime.getTime() - startTime.getTime())}));
            }
        }
        catch (Throwable error) {
            this.auditLog.logException("Run governance service", GovernanceActionAuditCode.GOVERNANCE_ACTION_SERVICE_FAILED.getMessageDefinition(new String[]{this.governanceActionServiceType, this.governanceServiceName, error.getClass().getName(), this.governanceEngineProperties.getQualifiedName(), this.governanceEngineGUID, error.getMessage()}), error.toString(), error);
            try {
                CompletionStatus completionStatus = this.governanceContext.getCompletionStatus();
                if (completionStatus == null) {
                    this.governanceContext.recordCompletionStatus(CompletionStatus.FAILED, null, null);
                }
            }
            catch (Throwable statusError) {
                this.auditLog.logException("Run governance service", GovernanceActionAuditCode.EXC_ON_ERROR_STATUS_UPDATE.getMessageDefinition(new String[]{this.governanceEngineProperties.getDisplayName(), this.governanceServiceName, statusError.getClass().getName(), statusError.getMessage()}), statusError.toString(), statusError);
            }
        }
    }
}

