/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.server;

import java.util.Map;
import org.odpi.openmetadata.commonservices.multitenant.OMESServiceInstance;
import org.odpi.openmetadata.engineservices.governanceaction.ffdc.GovernanceActionErrorCode;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionEngineHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.connectors.ffdc.InvalidParameterException;

public class GovernanceActionInstance
extends OMESServiceInstance {
    private Map<String, GovernanceActionEngineHandler> governanceActionEngineInstances;

    public GovernanceActionInstance(String serverName, String serviceName, AuditLog auditLog, String localServerUserId, int maxPageSize, String accessServiceRootURL, String accessServiceServerName, Map<String, GovernanceActionEngineHandler> governanceActionEngineInstances) {
        super(serverName, serviceName, auditLog, localServerUserId, maxPageSize, accessServiceRootURL, accessServiceServerName);
        this.governanceActionEngineInstances = governanceActionEngineInstances;
    }

    synchronized GovernanceActionEngineHandler getGovernanceActionEngine(String governanceActionEngineName) throws InvalidParameterException {
        String methodName = "getGovernanceActionEngine";
        String guidParameterName = "governanceActionEngineName";
        GovernanceActionEngineHandler instance = this.governanceActionEngineInstances.get(governanceActionEngineName);
        if (instance == null) {
            throw new InvalidParameterException(GovernanceActionErrorCode.UNKNOWN_GOVERNANCE_ACTION_ENGINE.getMessageDefinition(new String[]{this.serverName, governanceActionEngineName}), ((Object)((Object)this)).getClass().getName(), "getGovernanceActionEngine", "governanceActionEngineName");
        }
        return instance;
    }
}

