/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.server;

import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.engineservices.governanceaction.handlers.GovernanceActionEngineHandler;
import org.odpi.openmetadata.engineservices.governanceaction.rest.EngineSummaryListResponse;
import org.odpi.openmetadata.engineservices.governanceaction.server.GovernanceActionInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.slf4j.LoggerFactory;

public class GovernanceActionRESTServices {
    private static GovernanceActionInstanceHandler instanceHandler = new GovernanceActionInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceActionRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public EngineSummaryListResponse getLocalEngines(String serverName, String userId) {
        String methodName = "getLocalEngines";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "getLocalEngines");
        EngineSummaryListResponse response = new EngineSummaryListResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "getLocalEngines");
            GovernanceActionEngineHandler handler = instanceHandler.getGovernanceActionEngineHandler(userId, serverName, null, "getLocalEngines");
            response.setEngineSummaries(handler.getLocalEngines());
        }
        catch (Throwable error) {
            this.restExceptionHandler.captureThrowable((FFDCResponse)response, error, "getLocalEngines", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

