/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.engineservices.governanceaction.server;

import org.odpi.openmetadata.adminservices.configuration.registration.EngineServiceDescription;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallLogger;
import org.odpi.openmetadata.commonservices.ffdc.RESTCallToken;
import org.odpi.openmetadata.commonservices.ffdc.RESTExceptionHandler;
import org.odpi.openmetadata.commonservices.ffdc.properties.ConnectorReport;
import org.odpi.openmetadata.commonservices.ffdc.rest.ConnectorTypeResponse;
import org.odpi.openmetadata.commonservices.ffdc.rest.FFDCResponse;
import org.odpi.openmetadata.engineservices.governanceaction.server.GovernanceActionInstanceHandler;
import org.odpi.openmetadata.frameworks.auditlog.AuditLog;
import org.odpi.openmetadata.frameworks.governanceaction.GovernanceActionServiceConnector;
import org.slf4j.LoggerFactory;

public class GovernanceActionRESTServices {
    private static GovernanceActionInstanceHandler instanceHandler = new GovernanceActionInstanceHandler();
    private static RESTCallLogger restCallLogger = new RESTCallLogger(LoggerFactory.getLogger(GovernanceActionRESTServices.class), instanceHandler.getServiceName());
    private RESTExceptionHandler restExceptionHandler = new RESTExceptionHandler();

    public ConnectorTypeResponse validateConnector(String serverName, String userId, String connectorProviderClassName) {
        String methodName = "validateConnector";
        RESTCallToken token = restCallLogger.logRESTCall(serverName, userId, "validateConnector");
        ConnectorTypeResponse response = new ConnectorTypeResponse();
        AuditLog auditLog = null;
        try {
            auditLog = instanceHandler.getAuditLog(userId, serverName, "validateConnector");
            ConnectorReport connectorReport = instanceHandler.validateConnector(connectorProviderClassName, GovernanceActionServiceConnector.class, EngineServiceDescription.GOVERNANCE_ACTION_OMES.getEngineServiceFullName());
            if (connectorReport != null) {
                response = new ConnectorTypeResponse(connectorReport);
            }
        }
        catch (Exception error) {
            this.restExceptionHandler.captureExceptions((FFDCResponse)response, error, "validateConnector", auditLog);
        }
        restCallLogger.logRESTCallReturn(token, response.toString());
        return response;
    }
}

